/*
 * Decompiled with CFR 0.152.
 */
package docking.action.builder;

import docking.ActionContext;
import docking.action.builder.AbstractActionBuilder;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.Icon;

public class MultiStateActionBuilder<T>
extends AbstractActionBuilder<MultiStateDockingAction<T>, ActionContext, MultiStateActionBuilder<T>> {
    private BiConsumer<ActionState<T>, EventTrigger> actionStateChangedCallback;
    private boolean performActionOnButtonClick = false;
    private boolean fireFirstAction = true;
    private List<ActionState<T>> states = new ArrayList<ActionState<T>>();

    public MultiStateActionBuilder(String name, String owner) {
        super(name, owner);
    }

    @Override
    protected MultiStateActionBuilder<T> self() {
        return this;
    }

    public MultiStateActionBuilder<T> onActionStateChanged(BiConsumer<ActionState<T>, EventTrigger> biConsumer) {
        this.actionStateChangedCallback = biConsumer;
        return this.self();
    }

    public MultiStateActionBuilder<T> performActionOnButtonClick(boolean b) {
        this.performActionOnButtonClick = b;
        return this.self();
    }

    public MultiStateActionBuilder<T> addState(String displayName, Icon icon, T userData) {
        this.states.add(new ActionState<T>(displayName, icon, userData));
        return this.self();
    }

    public MultiStateActionBuilder<T> addState(ActionState<T> actionState) {
        this.states.add(actionState);
        return this.self();
    }

    public MultiStateActionBuilder<T> addStates(List<ActionState<T>> list) {
        this.states.addAll(list);
        return this.self();
    }

    public MultiStateActionBuilder<T> fireFirstAction(boolean fireFirstAction) {
        this.fireFirstAction = fireFirstAction;
        return this.self();
    }

    @Override
    public MultiStateDockingAction<T> build() {
        this.validate();
        MultiStateDockingAction action = new MultiStateDockingAction<T>(this.name, this.owner, this.isToolbarAction()){

            @Override
            public void actionStateChanged(ActionState<T> newActionState, EventTrigger trigger) {
                MultiStateActionBuilder.this.actionStateChangedCallback.accept(newActionState, trigger);
            }

            @Override
            protected void doActionPerformed(ActionContext context) {
                if (MultiStateActionBuilder.this.actionCallback != null) {
                    MultiStateActionBuilder.this.actionCallback.accept(context);
                }
            }
        };
        action.setFireFirstEvent(this.fireFirstAction);
        for (ActionState<T> actionState : this.states) {
            action.addActionState(actionState);
        }
        this.decorateAction(action);
        action.setPerformActionOnPrimaryButtonClick(this.performActionOnButtonClick);
        return action;
    }

    @Override
    protected void validate() {
        if (this.performActionOnButtonClick) {
            super.validate();
        }
        if (this.actionStateChangedCallback == null) {
            throw new IllegalStateException("Can't build a MultiStateDockingAction without an action state changed callback");
        }
    }
}

