/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DockingActionProxy;
import docking.DockingWindowManager;
import docking.WindowNode;
import docking.action.DockingActionIf;
import docking.menu.MenuBarManager;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import docking.menu.ToolBarManager;
import ghidra.util.task.SwingUpdateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuBar;

public class WindowActionManager {
    private Map<DockingActionIf, DockingActionProxy> actionToProxyMap;
    private MenuBarManager menuBarMgr;
    private ToolBarManager toolBarMgr;
    private final WindowNode node;
    private final DockingWindowManager winMgr;
    private boolean disposed;
    private ComponentPlaceholder placeHolderForScheduledActionUpdate;
    private Runnable updateActionsRunnable = () -> this.processContextChanged();
    private SwingUpdateManager updateManager = new SwingUpdateManager(500, 500, "Context Update Manager", this.updateActionsRunnable);

    public WindowActionManager(WindowNode node, MenuHandler menuBarHandler, DockingWindowManager winMgr, MenuGroupMap menuGroupMap) {
        this.node = node;
        this.winMgr = winMgr;
        this.actionToProxyMap = new HashMap<DockingActionIf, DockingActionProxy>();
        this.menuBarMgr = new MenuBarManager(menuBarHandler, menuGroupMap);
        this.toolBarMgr = new ToolBarManager(winMgr);
    }

    public void setActions(List<DockingActionIf> actionList) {
        this.menuBarMgr.clearActions();
        this.toolBarMgr.clearActions();
        for (DockingActionIf action : actionList) {
            this.addAction(action);
        }
    }

    public void addAction(DockingActionIf action) {
        if (action.getMenuBarData() != null || action.getToolBarData() != null) {
            DockingActionProxy proxyAction = new DockingActionProxy(action);
            this.actionToProxyMap.put(action, proxyAction);
            this.menuBarMgr.addAction(proxyAction);
            this.toolBarMgr.addAction(proxyAction);
        }
    }

    public void removeAction(DockingActionIf action) {
        DockingActionProxy proxyAction = this.actionToProxyMap.remove(action);
        if (proxyAction != null) {
            this.menuBarMgr.removeAction(proxyAction);
            this.toolBarMgr.removeAction(proxyAction);
        }
    }

    public DockingActionIf getToolbarAction(String actionName) {
        return this.toolBarMgr.getAction(actionName);
    }

    public void update() {
        JMenuBar menuBar = this.menuBarMgr.getMenuBar();
        if (menuBar.getMenuCount() > 0) {
            this.node.setMenuBar(menuBar);
        }
        this.node.setToolBar(this.toolBarMgr.getToolBar());
        this.node.validate();
    }

    public synchronized void dispose() {
        this.disposed = true;
        this.updateManager.dispose();
        this.node.setToolBar(null);
        this.node.setMenuBar(null);
        this.actionToProxyMap.clear();
        this.menuBarMgr.dispose();
        this.toolBarMgr.dispose();
    }

    synchronized void contextChanged(ComponentPlaceholder placeHolder) {
        if (!this.node.isVisible()) {
            return;
        }
        this.placeHolderForScheduledActionUpdate = placeHolder;
        this.updateManager.update();
    }

    private synchronized void processContextChanged() {
        if (this.disposed) {
            return;
        }
        ActionContext localContext = this.getContext();
        ActionContext globalContext = this.winMgr.getDefaultToolContext();
        ArrayList<DockingActionProxy> list = new ArrayList<DockingActionProxy>(this.actionToProxyMap.values());
        for (DockingActionIf dockingActionIf : list) {
            if (dockingActionIf.isValidContext(localContext)) {
                dockingActionIf.setEnabled(dockingActionIf.isEnabledForContext(localContext));
                continue;
            }
            if (this.isValidDefaultToolContext(dockingActionIf, globalContext)) {
                dockingActionIf.setEnabled(dockingActionIf.isEnabledForContext(globalContext));
                continue;
            }
            dockingActionIf.setEnabled(false);
        }
        this.winMgr.notifyContextListeners(this.placeHolderForScheduledActionUpdate, localContext);
    }

    private boolean isValidDefaultToolContext(DockingActionIf action, ActionContext toolContext) {
        return action.supportsDefaultToolContext() && action.isValidContext(toolContext);
    }

    private ActionContext getContext() {
        ActionContext context;
        ComponentProvider provider = this.placeHolderForScheduledActionUpdate == null ? null : this.placeHolderForScheduledActionUpdate.getProvider();
        ActionContext actionContext = context = provider == null ? null : provider.getActionContext(null);
        if (context == null) {
            context = new ActionContext();
        }
        return context;
    }
}

