/*
 * Decompiled with CFR 0.152.
 */
package docking;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.LayerUI;

public class DisabledComponentLayerFactory {
    private static DisabledComponentLayerUI disabledUI = new DisabledComponentLayerUI();

    private DisabledComponentLayerFactory() {
    }

    public static JLayer<JComponent> getDisabledLayer(JComponent component) {
        JLayer<JComponent> layer = new JLayer<JComponent>(component, disabledUI);
        return layer;
    }

    private static class DisabledComponentLayerUI
    extends LayerUI<JComponent> {
        private DisabledComponentLayerUI() {
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            JLayer l = (JLayer)c;
            l.setLayerEventMask(28L);
        }

        @Override
        public void uninstallUI(JComponent c) {
            super.uninstallUI(c);
            JLayer l = (JLayer)c;
            l.setLayerEventMask(0L);
        }

        private Color getColorForComponent(JComponent comp) {
            if (comp instanceof AbstractButton) {
                return UIManager.getColor("Button.background");
            }
            if (comp instanceof JComboBox) {
                return UIManager.getColor("ComboBox.background");
            }
            if (comp instanceof JMenu) {
                return UIManager.getColor("Menu.background");
            }
            if (comp instanceof JMenuBar) {
                return UIManager.getColor("MenuBar.background");
            }
            if (comp instanceof JMenuItem) {
                return UIManager.getColor("MenuItem.background");
            }
            return UIManager.getColor("Panel.background");
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            if (c.isEnabled()) {
                return;
            }
            Color disabledColor = this.getColorForComponent(c);
            Graphics2D g2 = (Graphics2D)g.create();
            int w = c.getWidth();
            int h = c.getHeight();
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2.setPaint(disabledColor);
            g2.fillRect(0, 0, w, h);
            g2.dispose();
        }

        @Override
        public void eventDispatched(AWTEvent e, JLayer<? extends JComponent> layer) {
            boolean block;
            boolean bl = block = !layer.isEnabled();
            if (block) {
                if (e instanceof FocusEvent) {
                    return;
                }
                if (e instanceof MouseEvent) {
                    ((MouseEvent)e).consume();
                    return;
                }
                if (e instanceof KeyEvent) {
                    ((KeyEvent)e).consume();
                    return;
                }
            }
            super.eventDispatched(e, layer);
        }
    }
}

