/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.actions.RenameTask;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class RenameStructureFieldTask
extends RenameTask {
    private Structure structure;
    public int offset;

    public RenameStructureFieldTask(PluginTool tool, Program program, DecompilerPanel panel, ClangToken token, Structure structure, int offset) {
        super(tool, program, panel, token, token.getText());
        this.structure = structure;
        this.offset = offset;
    }

    @Override
    public void commit() throws DuplicateNameException, InvalidInputException {
        DataTypeComponent comp;
        if (this.structure.isNotYetDefined()) {
            Undefined1DataType newtype = new Undefined1DataType();
            this.structure.insert(0, (DataType)newtype);
        }
        if ((comp = this.structure.getComponentAt(this.offset)).getDataType() == DataType.DEFAULT) {
            Undefined1DataType newtype = new Undefined1DataType();
            this.structure.replaceAtOffset(this.offset, (DataType)newtype, 1, this.newName, "Created by retype action");
        } else {
            comp.setFieldName(this.newName);
        }
    }

    @Override
    public String getTransactionName() {
        return "Rename Structure Field";
    }

    @Override
    public boolean isValid(String newNm) {
        DataTypeComponent[] comp;
        this.newName = newNm;
        for (DataTypeComponent element : comp = this.structure.getDefinedComponents()) {
            String fieldname = element.getFieldName();
            if (fieldname == null || !fieldname.equals(this.newName)) continue;
            this.errorMsg = "Duplicate Field Name";
            return false;
        }
        return true;
    }
}

