/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.util.HelpLocation;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.io.File;

public class DebugDecompilerAction
extends AbstractDecompilerAction {
    private DecompilerController controller;

    public DebugDecompilerAction(DecompilerController controller) {
        super("Debug Function Decompilation");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ToolBarDebug"));
        this.controller = controller;
        this.setMenuBarData(new MenuData(new String[]{"Debug Function Decompilation"}, "xDebug"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return context.getFunction() != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DecompilerPanel parentComponent = context.getDecompilerPanel();
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)parentComponent);
        fileChooser.setTitle("Please Choose Output File");
        fileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(new String[]{"xml"}, "XML Files"));
        File file = fileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (file.exists() && OptionDialog.showYesNoDialog((Component)parentComponent, (String)"Overwrite Existing File?", (String)"Do you want to overwrite the existing file?") == 2) {
            return;
        }
        this.controller.setStatusMessage("Dumping debug info to " + file.getAbsolutePath());
        this.controller.refreshDisplay(this.controller.getProgram(), this.controller.getLocation(), file);
    }
}

