/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.plugin.core.decompile.actions.ASTGraphTask;
import ghidra.app.plugin.core.graph.AddressBasedGraphDisplayListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeBlockBasic;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ASTGraphDisplayListener
extends AddressBasedGraphDisplayListener {
    private HighFunction hfunction;
    private ASTGraphTask.GraphType graphType;

    ASTGraphDisplayListener(PluginTool tool, GraphDisplay display, HighFunction hfunction, ASTGraphTask.GraphType graphType) {
        super(tool, hfunction.getFunction().getProgram(), display);
        this.hfunction = hfunction;
        this.graphType = graphType;
    }

    protected Set<AttributedVertex> getVertices(AddressSetView selection) {
        if (this.graphType != ASTGraphTask.GraphType.CONTROL_FLOW_GRAPH) {
            return null;
        }
        HashSet<AttributedVertex> vertices = new HashSet<AttributedVertex>();
        ArrayList blocks = this.hfunction.getBasicBlocks();
        for (PcodeBlockBasic block : blocks) {
            Address stop;
            Address start = block.getStart();
            if (!selection.intersects(start, stop = block.getStop())) continue;
            String id = Integer.toString(block.getIndex());
            AttributedVertex vertex = this.graphDisplay.getGraph().getVertex(id);
            if (vertex == null) continue;
            vertices.add(vertex);
        }
        return vertices;
    }

    protected AddressSet getAddresses(Set<AttributedVertex> vertices) {
        if (this.graphType != ASTGraphTask.GraphType.CONTROL_FLOW_GRAPH) {
            return null;
        }
        AddressSet set = new AddressSet();
        ArrayList blocks = this.hfunction.getBasicBlocks();
        for (AttributedVertex vertex : vertices) {
            try {
                int index = Integer.parseInt(vertex.getId());
                PcodeBlockBasic block = (PcodeBlockBasic)blocks.get(index);
                Address start = block.getStart();
                set.addRange(start, block.getStop());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return set;
    }

    protected String getVertexId(Address address) {
        if (this.graphType != ASTGraphTask.GraphType.CONTROL_FLOW_GRAPH) {
            return null;
        }
        ArrayList blocks = this.hfunction.getBasicBlocks();
        for (PcodeBlockBasic block : blocks) {
            Address start = block.getStart();
            Address stop = block.getStop();
            if (address.compareTo((Object)start) < 0 || address.compareTo((Object)stop) > 0) continue;
            return Integer.toString(block.getIndex());
        }
        return super.getVertexId(address);
    }

    protected Address getAddress(AttributedVertex vertex) {
        ArrayList blocks = this.hfunction.getBasicBlocks();
        try {
            int index = Integer.parseInt(vertex.getId());
            PcodeBlockBasic block = (PcodeBlockBasic)blocks.get(index);
            return block.getStart();
        }
        catch (NumberFormatException e) {
            throw new AssertException("Bad vertex id, expected a number but got " + vertex.getId());
        }
    }

    public GraphDisplayListener cloneWith(GraphDisplay display) {
        return new ASTGraphDisplayListener(this.tool, this.graphDisplay, this.hfunction, this.graphType);
    }
}

