/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.decompiler.DecompileDebug;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.UniqueAddressFactory;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.TerminatedUnicode32DataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.ConstantPool;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionError;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PackedBytes;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionPcodeOverride;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.model.pcode.HighCodeSymbol;
import ghidra.program.model.pcode.HighExternalSymbol;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionShellSymbol;
import ghidra.program.model.pcode.HighFunctionSymbol;
import ghidra.program.model.pcode.HighLabelSymbol;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOverride;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.SymbolEntry;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.util.xml.XmlUtilities;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DecompileCallback {
    public static final int MAX_SYMBOL_COUNT = 16;
    private DecompileDebug debug;
    private Program program;
    private Listing listing;
    private UniqueAddressFactory uniqueFactory;
    private Function cachedFunction;
    private AddressSet undefinedBody;
    private Address funcEntry;
    private int default_extrapop;
    private Language pcodelanguage;
    private CompilerSpec pcodecompilerspec;
    private AddressFactory addrfactory;
    private ConstantPool cpool;
    private PcodeDataTypeManager dtmanage;
    private Charset utf8Charset;
    private String nativeMessage;
    private InstructionBlock lastPseudoInstructionBlock;
    private Disassembler pseudoDisassembler;

    public DecompileCallback(Program prog, Language language, CompilerSpec compilerSpec, PcodeDataTypeManager dt) {
        this.program = prog;
        this.pcodelanguage = language;
        this.uniqueFactory = new UniqueAddressFactory(prog.getAddressFactory(), language);
        this.pcodecompilerspec = compilerSpec;
        this.listing = this.program.getListing();
        this.addrfactory = this.program.getAddressFactory();
        this.dtmanage = dt;
        this.default_extrapop = this.pcodecompilerspec.getDefaultCallingConvention().getExtrapop();
        this.cpool = null;
        this.nativeMessage = null;
        this.debug = null;
        this.utf8Charset = (Charset)Charset.availableCharsets().get("UTF-8");
    }

    private static SAXParser getSAXParser() throws PcodeXMLException {
        try {
            SAXParserFactory saxParserFactory = XmlUtilities.createSecureSAXParserFactory((boolean)false);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", false);
            saxParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            return saxParserFactory.newSAXParser();
        }
        catch (Exception e) {
            Msg.error(DecompileCallback.class, (Object)e.getMessage());
            throw new PcodeXMLException("Failed to instantiate XML parser", (Throwable)e);
        }
    }

    public void setFunction(Function func, Address entry, DecompileDebug dbg) {
        this.cachedFunction = func;
        this.undefinedBody = null;
        if (func instanceof UndefinedFunction) {
            this.undefinedBody = new AddressSet(func.getBody());
        }
        this.funcEntry = entry;
        this.debug = dbg;
        if (this.debug != null) {
            this.debug.setPcodeDataTypeManager(this.dtmanage);
        }
        this.nativeMessage = null;
        this.lastPseudoInstructionBlock = null;
        if (this.pseudoDisassembler != null) {
            this.pseudoDisassembler.resetDisassemblerContext();
        }
        this.uniqueFactory.reset();
    }

    public String getNativeMessage() {
        return this.nativeMessage;
    }

    void setNativeMessage(String msg) {
        this.nativeMessage = msg;
    }

    public synchronized int readXMLSize(String addrxml) {
        int attrend;
        int attrstart = addrxml.indexOf("size=\"");
        if (attrstart >= 4 && (attrend = addrxml.indexOf(34, attrstart += 6)) > attrstart) {
            int size = SpecXmlUtils.decodeInt((String)addrxml.substring(attrstart, attrend));
            return size;
        }
        return 0;
    }

    public synchronized ArrayList<String> readXMLNameList(String xml) throws PcodeXMLException {
        try {
            NameListHandler nmHandler = new NameListHandler();
            DecompileCallback.getSAXParser().parse(new InputSource(new StringReader(xml)), (DefaultHandler)nmHandler);
            return nmHandler.getList();
        }
        catch (SAXException e1) {
            throw new PcodeXMLException("Problem parsing list string " + xml, (Throwable)e1);
        }
        catch (IOException e1) {
            throw new PcodeXMLException("Problem parsing list string " + xml, (Throwable)e1);
        }
    }

    public byte[] getBytes(String addrxml) {
        try {
            int size = this.readXMLSize(addrxml);
            Address addr = Varnode.readXMLAddress((String)addrxml, (AddressFactory)this.addrfactory, (AddressSpace)this.funcEntry.getAddressSpace());
            if (addr == Address.NO_ADDRESS) {
                throw new PcodeXMLException("Address does not physically map");
            }
            if (addr.isRegisterAddress()) {
                return null;
            }
            byte[] resbytes = new byte[size];
            int bytesRead = this.program.getMemory().getBytes(addr, resbytes, 0, size);
            if (this.debug != null) {
                if (bytesRead != size) {
                    byte[] debugBytes = new byte[bytesRead];
                    System.arraycopy(resbytes, 0, debugBytes, 0, bytesRead);
                    this.debug.getBytes(addr, debugBytes);
                } else {
                    this.debug.getBytes(addr, resbytes);
                }
            }
            return resbytes;
        }
        catch (MemoryAccessException e) {
            Msg.warn((Object)this, (Object)("Decompiling " + this.funcEntry + ": " + e.getMessage()));
        }
        catch (PcodeXMLException e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ": " + e.getMessage()));
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ", error while accessing bytes: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    public String getComments(String addrstring, String types) {
        Address addr;
        try {
            addr = Varnode.readXMLAddress((String)addrstring, (AddressFactory)this.addrfactory, (AddressSpace)this.funcEntry.getAddressSpace());
        }
        catch (PcodeXMLException e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ": " + e.getMessage()));
            return null;
        }
        int flags = SpecXmlUtils.decodeInt((String)types);
        Function func = this.getFunctionAt(addr);
        if (func == null) {
            return null;
        }
        AddressSetView addrset = func.getBody();
        StringBuilder buf = new StringBuilder();
        buf.append("<commentdb>\n");
        if ((flags & 8) != 0) {
            this.generateHeaderCommentXML(func, buf);
        }
        if ((flags & 1) != 0) {
            this.generateCommentXML(addrset, addr, buf, 0);
        }
        if ((flags & 2) != 0) {
            this.generateCommentXML(addrset, addr, buf, 1);
        }
        if ((flags & 4) != 0) {
            this.generateCommentXML(addrset, addr, buf, 2);
        }
        if ((flags & 8) != 0) {
            this.generateCommentXML(addrset, addr, buf, 3);
        }
        buf.append("</commentdb>\n");
        String res = buf.toString();
        if (this.debug != null) {
            this.debug.getComments(res);
        }
        return res;
    }

    public PackedBytes getPcodePacked(String addrstring) {
        Address addr = null;
        try {
            addr = Varnode.readXMLAddress((String)addrstring, (AddressFactory)this.addrfactory, (AddressSpace)this.funcEntry.getAddressSpace());
        }
        catch (PcodeXMLException e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ": " + e.getMessage()));
            return null;
        }
        try {
            Instruction instr = this.getInstruction(addr);
            if (instr == null) {
                return null;
            }
            if (this.undefinedBody != null) {
                this.undefinedBody.addRange(instr.getMinAddress(), instr.getMaxAddress());
                this.cachedFunction.setBody((AddressSetView)this.undefinedBody);
            }
            if (this.debug != null) {
                this.debug.getPcode(addr, instr);
                FlowOverride fo = instr.getFlowOverride();
                if (fo != FlowOverride.NONE) {
                    this.debug.addFlowOverride(addr, fo);
                }
            }
            PackedBytes pcode = instr.getPrototype().getPcodePacked(instr.getInstructionContext(), (PcodeOverride)new InstructionPcodeOverride(instr), this.uniqueFactory);
            return pcode;
        }
        catch (UsrException e) {
            Msg.warn((Object)this, (Object)("Decompiling " + this.funcEntry + ", pcode error at " + addr + ": " + e.getMessage()));
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ", pcode error at " + addr + ": " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    public static String buildInstruction(PcodeOp[] ops, int fallthruoffset, int paramshift, AddressFactory addrFactory) {
        StringBuilder resBuf = new StringBuilder();
        if (ops.length == 1 && ops[0].getOpcode() == 0) {
            resBuf.append("<unimpl");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"offset", (long)fallthruoffset);
            resBuf.append("/>\n");
            return resBuf.toString();
        }
        resBuf.append("<inst");
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"offset", (long)fallthruoffset);
        if (paramshift != 0) {
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"paramshift", (long)paramshift);
        }
        resBuf.append('>');
        for (PcodeOp op : ops) {
            op.buildXML(resBuf, addrFactory);
        }
        resBuf.append("</inst>\n");
        return resBuf.toString();
    }

    public String getPcodeInject(String nm, String context, int type) {
        PcodeInjectLibrary snippetLibrary = this.pcodecompilerspec.getPcodeInjectLibrary();
        InjectPayload payload = snippetLibrary.getPayload(type, nm, this.program, context);
        if (payload == null) {
            Msg.warn((Object)this, (Object)("Decompiling " + this.funcEntry + ", no pcode inject with name: " + nm));
            return null;
        }
        InjectContext con = snippetLibrary.buildInjectContext();
        try {
            con.restoreXml(DecompileCallback.getSAXParser(), context, this.addrfactory);
        }
        catch (PcodeXMLException e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ": " + e.getMessage()));
            return null;
        }
        try {
            int fallThruOffset;
            if (payload.getType() == 4) {
                fallThruOffset = 4;
            } else {
                Instruction instr = this.getInstruction(con.baseAddr);
                if (instr == null) {
                    Msg.warn((Object)this, (Object)("Decompiling " + this.funcEntry + ", pcode inject error at " + con.baseAddr + ": instruction not found"));
                    return null;
                }
                fallThruOffset = instr.getDefaultFallThroughOffset();
                con.nextAddr = con.baseAddr.add((long)fallThruOffset);
                con.refAddr = null;
                for (Reference ref : this.program.getReferenceManager().getReferencesFrom(con.baseAddr)) {
                    if (!ref.isPrimary() || !ref.getReferenceType().isCall()) continue;
                    con.refAddr = ref.getToAddress();
                    break;
                }
            }
            PcodeOp[] pcode = payload.getPcode(this.program, con);
            if (pcode == null) {
                return null;
            }
            String finalPayload = DecompileCallback.buildInstruction(pcode, fallThruOffset, payload.getParamShift(), this.addrfactory);
            if (this.debug != null) {
                this.debug.addInject(con.baseAddr, nm, type, finalPayload);
            }
            return finalPayload;
        }
        catch (UnknownInstructionException e) {
            Msg.warn((Object)this, (Object)("Decompiling " + this.funcEntry + ", pcode inject error at " + con.baseAddr + ": " + e.getMessage()));
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ", pcode inject error at " + con.baseAddr + ": " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    public String getCPoolRef(long[] refs) throws IOException {
        if (this.cpool == null) {
            this.cpool = this.pcodecompilerspec.getPcodeInjectLibrary().getConstantPool(this.program);
        }
        ConstantPool.Record record = this.cpool.getRecord(refs);
        String res = record.build(refs[0], this.dtmanage).toString();
        if (this.debug != null) {
            this.debug.getCPoolRef(res, refs);
        }
        return res;
    }

    private Instruction getInstruction(Address addr) throws UnknownInstructionException {
        Instruction instr = this.listing.getInstructionAt(addr);
        if (instr == null) {
            instr = this.pseudoDisassemble(addr);
        }
        return instr;
    }

    private Instruction pseudoDisassemble(Address addr) throws UnknownInstructionException {
        Instruction instr;
        if (this.lastPseudoInstructionBlock != null) {
            instr = this.lastPseudoInstructionBlock.getInstructionAt(addr);
            if (instr != null) {
                return instr;
            }
            InstructionError error = this.lastPseudoInstructionBlock.getInstructionConflict();
            if (error != null && addr.equals((Object)error.getInstructionAddress())) {
                throw new UnknownInstructionException(error.getConflictMessage());
            }
            this.lastPseudoInstructionBlock = null;
        }
        if (this.pseudoDisassembler == null) {
            this.pseudoDisassembler = Disassembler.getDisassembler((Program)this.program, (boolean)false, (boolean)false, (boolean)false, (TaskMonitor)TaskMonitor.DUMMY, msg -> {});
        }
        RegisterValue entryContext = null;
        ProgramContext programContext = this.program.getProgramContext();
        Register baseContextRegister = programContext.getBaseContextRegister();
        if (baseContextRegister != null) {
            entryContext = programContext.getRegisterValue(baseContextRegister, this.funcEntry);
        }
        this.lastPseudoInstructionBlock = this.pseudoDisassembler.pseudoDisassembleBlock(addr, entryContext, 64);
        if (this.lastPseudoInstructionBlock != null) {
            InstructionError error = this.lastPseudoInstructionBlock.getInstructionConflict();
            if (error != null && error.getConflictMessage().startsWith("Maximum run of Zero-Byte")) {
                throw new UnknownInstructionException(error.getConflictMessage());
            }
            instr = this.lastPseudoInstructionBlock.getInstructionAt(addr);
            if (instr != null) {
                return instr;
            }
            if (error != null && addr.equals((Object)error.getInstructionAddress())) {
                throw new UnknownInstructionException(error.getConflictMessage());
            }
            if (MemoryBlock.isExternalBlockAddress((Address)addr, (Program)this.program)) {
                throw new UnknownInstructionException("Unable to disassemble EXTERNAL block location: " + addr);
            }
        }
        throw new UnknownInstructionException("Invalid instruction address (improperly aligned)");
    }

    public String getSymbol(String addrstring) {
        Address addr;
        try {
            addr = Varnode.readXMLAddress((String)addrstring, (AddressFactory)this.addrfactory, (AddressSpace)this.funcEntry.getAddressSpace());
        }
        catch (PcodeXMLException e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ": " + e.getMessage()));
            return null;
        }
        try {
            Symbol sym = this.program.getSymbolTable().getPrimarySymbol(addr);
            if (sym == null) {
                return null;
            }
            String res = this.getSymbolName(sym);
            if (this.debug != null) {
                this.debug.getCodeSymbol(addr, sym.getID(), res, sym.getParentNamespace());
            }
            return res;
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ", error while accessing symbol: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private String getSymbolName(Symbol sym) {
        String prefix = this.getNamespacePrefix(sym.getParentNamespace());
        if (prefix != null) {
            return prefix + "_" + sym.getName();
        }
        return sym.getName();
    }

    private Namespace getNameSpaceByID(long id) {
        Symbol namespaceSym = this.program.getSymbolTable().getSymbol(id);
        if (namespaceSym == null) {
            return null;
        }
        Object namespace = namespaceSym.getObject();
        if (namespace instanceof Namespace) {
            return (Namespace)namespace;
        }
        return null;
    }

    private String getNamespacePrefix(Namespace ns) {
        if (ns.getID() == 0L) {
            return null;
        }
        if (ns instanceof Function && ((Function)ns).getEntryPoint().equals((Object)this.funcEntry)) {
            return null;
        }
        String name = ns.getName();
        String parentName = this.getNamespacePrefix(ns.getParentNamespace());
        if (parentName != null) {
            return parentName + "_" + name;
        }
        return name;
    }

    public boolean isNameUsed(String name, long startId, long stopId) {
        Namespace namespace = this.getNameSpaceByID(startId);
        int pathSize = 0;
        Namespace curspace = namespace;
        long curId = namespace.getID();
        while (curId != stopId && curId != 0L && !HighFunction.collapseToGlobal((Namespace)curspace)) {
            ++pathSize;
            curspace = curspace.getParentNamespace();
            curId = curspace.getID();
        }
        long[] path = new long[pathSize];
        curspace = namespace;
        path[0] = startId;
        for (int i = 1; i < pathSize; ++i) {
            curspace = curspace.getParentNamespace();
            path[i] = curspace.getID();
        }
        int count = 0;
        SymbolIterator iter = this.program.getSymbolTable().getSymbols(name);
        while (iter.hasNext() && ++count <= 16) {
            Namespace symSpace = iter.next().getParentNamespace();
            long id = symSpace.getID();
            if (id == 0L) continue;
            for (int i = 0; i < pathSize; ++i) {
                if (path[i] != id) continue;
                if (this.debug != null) {
                    this.debug.nameIsUsed(symSpace, name);
                }
                return true;
            }
        }
        return count > 16;
    }

    public String getNamespacePath(long id) {
        Namespace namespace = this.getNameSpaceByID(id);
        StringBuilder buf = new StringBuilder();
        HighFunction.createNamespaceTag((StringBuilder)buf, (Namespace)namespace);
        if (this.debug != null) {
            this.debug.getNamespacePath(namespace);
        }
        return buf.toString();
    }

    private void generateHeaderCommentXML(Function func, StringBuilder buf) {
        Address addr = func.getEntryPoint();
        String text = this.listing.getComment(3, addr);
        if (text != null) {
            buf.append("<comment");
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"type", (String)"header");
            buf.append(">\n");
            buf.append(Varnode.buildXMLAddress((Address)addr));
            buf.append(Varnode.buildXMLAddress((Address)addr));
            buf.append("\n<text>");
            SpecXmlUtils.xmlEscape((StringBuilder)buf, (String)text);
            buf.append("</text>\n");
            buf.append("</comment>\n");
        }
    }

    private void generateCommentXML(AddressSetView addrset, Address addr, StringBuilder buf, int commenttype) {
        String typename;
        switch (commenttype) {
            case 0: {
                typename = "user1";
                break;
            }
            case 1: {
                typename = "user2";
                break;
            }
            case 2: {
                typename = "user3";
                break;
            }
            case 3: {
                typename = "header";
                break;
            }
            default: {
                typename = "";
            }
        }
        AddressIterator iter = this.listing.getCommentAddressIterator(commenttype, addrset, true);
        while (iter.hasNext()) {
            Address commaddr = iter.next();
            String text = this.listing.getComment(commenttype, commaddr);
            if (text == null || commenttype == 3 && commaddr.equals((Object)addr)) continue;
            buf.append("<comment");
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"type", (String)typename);
            buf.append(">\n");
            buf.append(Varnode.buildXMLAddress((Address)addr));
            buf.append(Varnode.buildXMLAddress((Address)commaddr));
            buf.append("\n<text>");
            SpecXmlUtils.xmlEscape((StringBuilder)buf, (String)text);
            buf.append("</text>\n");
            buf.append("</comment>\n");
        }
    }

    public String getMappedSymbolsXML(String addrstring) {
        Address addr;
        try {
            addr = Varnode.readXMLAddress((String)addrstring, (AddressFactory)this.addrfactory, (AddressSpace)this.funcEntry.getAddressSpace());
            if (addr == Address.NO_ADDRESS) {
                return null;
            }
        }
        catch (PcodeXMLException e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ": " + e.getMessage()));
            return null;
        }
        try {
            String res = null;
            Object obj = this.lookupSymbol(addr);
            if (obj instanceof Function) {
                boolean includeDefaults = addr.equals((Object)this.funcEntry);
                res = this.buildFunctionXML((Function)obj, addr, includeDefaults);
            } else if (obj instanceof Data) {
                res = this.buildData((Data)obj);
            } else if (obj instanceof ExternalReference) {
                res = this.buildExternalRef(addr, (ExternalReference)obj);
            } else if (obj instanceof Symbol) {
                res = this.buildLabel((Symbol)obj, addr);
            }
            if (res == null) {
                res = this.buildHole(addr).toString();
            }
            return res;
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ", mapped symbol error for " + addrstring + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String getExternalRefXML(String addrstring) {
        Address addr;
        try {
            addr = Varnode.readXMLAddress((String)addrstring, (AddressFactory)this.addrfactory, (AddressSpace)this.funcEntry.getAddressSpace());
        }
        catch (PcodeXMLException e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ": " + e.getMessage()));
            return null;
        }
        try {
            int extrapop;
            Function func = null;
            if (this.cachedFunction != null && this.cachedFunction.getEntryPoint().equals((Object)addr)) {
                func = this.cachedFunction;
            } else {
                ExternalReference extRef = this.getExternalReference(addr);
                if (extRef != null) {
                    func = this.listing.getFunctionAt(extRef.getToAddress());
                    if (func == null) {
                        Symbol symbol = extRef.getExternalLocation().getSymbol();
                        long extId = symbol != null ? symbol.getID() : this.program.getSymbolTable().getDynamicSymbolID(addr);
                        HighFunctionShellSymbol shellSymbol = new HighFunctionShellSymbol(extId, extRef.getLabel(), addr, this.dtmanage);
                        return this.buildResult((HighSymbol)shellSymbol, null);
                    }
                } else {
                    func = this.listing.getFunctionAt(addr);
                }
            }
            if (func == null) {
                return null;
            }
            HighFunction hfunc = new HighFunction(func, this.pcodelanguage, this.pcodecompilerspec, this.dtmanage);
            hfunc.grabFromFunction(extrapop, false, (extrapop = this.getExtraPopOverride(func, addr)) != this.default_extrapop);
            HighFunctionSymbol funcSymbol = new HighFunctionSymbol(addr, 2, hfunc);
            Namespace namespc = funcSymbol.getNamespace();
            if (this.debug != null) {
                this.debug.getFNTypes(hfunc);
            }
            return this.buildResult((HighSymbol)funcSymbol, namespc);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ", error in getExternalRefXML: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String getType(String name, String idstr) {
        DataType type = this.dtmanage.findBaseType(name, idstr);
        if (type == null) {
            return null;
        }
        StringBuilder resBuf = this.dtmanage.buildType(type, 0);
        resBuf.append("\n");
        String res = resBuf.toString();
        if (this.debug != null) {
            this.debug.getType(type);
        }
        return res;
    }

    public String getRegister(String name) {
        Register reg = this.pcodelanguage.getRegister(name);
        if (reg == null) {
            throw new RuntimeException("No Register Defined: " + name);
        }
        StringBuilder resBuf = this.buildRegister(reg);
        resBuf.append("\n");
        return resBuf.toString();
    }

    public String getRegisterName(String addrstring) {
        try {
            Address addr = Varnode.readXMLAddress((String)addrstring, (AddressFactory)this.addrfactory, null);
            int size = this.readXMLSize(addrstring);
            Register reg = this.pcodelanguage.getRegister(addr, size);
            if (reg == null) {
                return null;
            }
            return reg.getName();
        }
        catch (PcodeXMLException e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ", error while searching for register name: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String getTrackedRegisters(String addrstring) {
        Address addr;
        try {
            addr = Varnode.readXMLAddress((String)addrstring, (AddressFactory)this.addrfactory, (AddressSpace)this.funcEntry.getAddressSpace());
        }
        catch (PcodeXMLException e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ": " + e.getMessage()));
            return null;
        }
        ProgramContext context = this.program.getProgramContext();
        StringBuilder stringBuf = new StringBuilder();
        stringBuf.append("<tracked_pointset");
        Varnode.appendSpaceOffset((StringBuilder)stringBuf, (Address)addr);
        stringBuf.append(">\n");
        for (Register reg : context.getRegisters()) {
            BigInteger val;
            if (reg.isProcessorContext() || (val = context.getValue(reg, addr, false)) == null) continue;
            this.buildTrackSet(stringBuf, reg, val.longValue());
        }
        stringBuf.append("</tracked_pointset>\n");
        String res = stringBuf.toString();
        if (this.debug != null) {
            this.debug.getTrackedRegisters(res);
        }
        return res;
    }

    public String getUserOpName(String indexStr) {
        int index = Integer.parseInt(indexStr);
        String name = this.pcodelanguage.getUserDefinedOpName(index);
        return name;
    }

    private String buildResult(HighSymbol highSymbol, Namespace namespc) {
        long namespaceId = namespc == null || namespc instanceof Library ? 0L : namespc.getID();
        StringBuilder res = new StringBuilder();
        res.append("<result");
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)res, (String)"id", (long)namespaceId);
        res.append(">\n");
        if (this.debug != null) {
            StringBuilder res2 = new StringBuilder();
            HighSymbol.buildMapSymXML((StringBuilder)res2, (HighSymbol)highSymbol);
            String res2string = res2.toString();
            this.debug.getMapped(namespc, res2string);
            res.append(res2string);
        } else {
            HighSymbol.buildMapSymXML((StringBuilder)res, (HighSymbol)highSymbol);
        }
        res.append("</result>\n");
        return res.toString();
    }

    private String buildData(Data data) {
        HighCodeSymbol highSymbol;
        Symbol sym = data.getPrimarySymbol();
        if (sym != null) {
            highSymbol = new HighCodeSymbol(sym.getID(), sym.getName(), data, this.dtmanage);
        } else {
            highSymbol = new HighCodeSymbol(0L, SymbolUtilities.getDynamicName((Program)this.program, (Address)data.getAddress()), data, this.dtmanage);
            SymbolEntry entry = highSymbol.getFirstWholeMap();
            if (data.getDataType() == DataType.DEFAULT && !entry.isReadOnly() && !entry.isVolatile()) {
                return null;
            }
        }
        if (this.debug != null) {
            this.debug.getType(highSymbol.getDataType());
        }
        Namespace namespc = sym != null ? sym.getParentNamespace() : null;
        return this.buildResult((HighSymbol)highSymbol, namespc);
    }

    private StringBuilder buildRegister(Register reg) {
        StringBuilder resBuf = new StringBuilder();
        resBuf.append("<addr");
        SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"space", (String)reg.getAddressSpace().getName());
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)resBuf, (String)"offset", (long)reg.getOffset());
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)reg.getMinimumByteSize());
        resBuf.append("/>");
        return resBuf;
    }

    private String buildLabel(Symbol sym, Address addr) {
        HighLabelSymbol labelSymbol = new HighLabelSymbol(sym.getName(), addr, this.dtmanage);
        Namespace namespc = sym.getParentNamespace();
        return this.buildResult((HighSymbol)labelSymbol, namespc);
    }

    private boolean isReadOnlyNoData(Address addr) {
        boolean readonly = false;
        MemoryBlock block = this.program.getMemory().getBlock(addr);
        if (block != null) {
            boolean bl = readonly = !block.isWrite();
            if (readonly) {
                ReferenceIterator refIter = this.program.getReferenceManager().getReferencesTo(addr);
                for (int count = 0; refIter.hasNext() && count < 100; ++count) {
                    Reference ref = refIter.next();
                    if (ref.getReferenceType().isWrite()) {
                        readonly = false;
                        break;
                    }
                    if (!ref.getReferenceType().isRead()) continue;
                }
            }
        }
        return readonly;
    }

    private String buildFunctionXML(Function func, Address addr, boolean includeDefaultNames) {
        long diff;
        Address entry = func.getEntryPoint();
        if (entry.getAddressSpace().equals(addr.getAddressSpace()) && (diff = addr.getOffset() - entry.getOffset()) >= 0L && diff < 8L) {
            int extrapop;
            HighFunction hfunc = new HighFunction(func, this.pcodelanguage, this.pcodecompilerspec, this.dtmanage);
            hfunc.grabFromFunction(extrapop, includeDefaultNames, (extrapop = this.getExtraPopOverride(func, addr)) != this.default_extrapop);
            HighFunctionSymbol functionSymbol = new HighFunctionSymbol(entry, (int)(diff + 1L), hfunc);
            Namespace namespc = functionSymbol.getNamespace();
            if (this.debug != null) {
                this.debug.getFNTypes(hfunc);
            }
            return this.buildResult((HighSymbol)functionSymbol, namespc);
        }
        AddressRangeIterator iter = func.getBody().getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            if (!range.contains(addr)) continue;
            Address first = range.getMinAddress();
            Address last = range.getMaxAddress();
            boolean readonly = true;
            return this.buildHoleXML(first.getAddressSpace().getPhysicalSpace().getName(), first.getOffset(), last.getOffset(), readonly, false);
        }
        return this.buildHoleXML(addr.getAddressSpace().getPhysicalSpace().getName(), addr.getOffset(), addr.getOffset(), true, false);
    }

    private int getExtraPopOverride(Function func, Address addr) {
        if (func.getEntryPoint().equals((Object)this.funcEntry)) {
            return this.default_extrapop;
        }
        int extrapop = this.default_extrapop;
        Function containedFunc = this.getFunctionAt(this.funcEntry);
        if (containedFunc == null) {
            return extrapop;
        }
        AddressIterator iter = CallDepthChangeInfo.getStackDepthChanges((Program)containedFunc.getProgram(), (AddressSetView)containedFunc.getBody());
        while (iter.hasNext()) {
            Reference[] refs;
            Address changeAddr = iter.next();
            for (Reference element : refs = func.getProgram().getReferenceManager().getFlowReferencesFrom(changeAddr)) {
                Integer change;
                if (!element.getToAddress().equals((Object)addr) || (change = CallDepthChangeInfo.getStackDepthChange((Program)func.getProgram(), (Address)changeAddr)) == null) continue;
                extrapop = change;
            }
        }
        return extrapop;
    }

    private String buildHoleXML(String nm, long first, long last, boolean readonly, boolean isVolatile) {
        StringBuilder resBuf = new StringBuilder();
        resBuf.append("<hole");
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)resBuf, (String)"readonly", (boolean)readonly);
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)resBuf, (String)"volatile", (boolean)isVolatile);
        SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"space", (String)nm);
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)resBuf, (String)"first", (long)first);
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)resBuf, (String)"last", (long)last);
        resBuf.append("/>\n");
        return resBuf.toString();
    }

    private String buildHole(Address addr) {
        boolean readonly = this.isReadOnlyNoData(addr);
        boolean isvolatile = this.isVolatileNoData(addr);
        return this.buildHoleXML(addr.getAddressSpace().getPhysicalSpace().getName(), addr.getOffset(), addr.getOffset(), readonly, isvolatile);
    }

    private String buildExternalRef(Address addr, ExternalReference ref) {
        HighExternalSymbol externSymbol = new HighExternalSymbol(ref.getLabel(), addr, addr, this.dtmanage);
        return this.buildResult((HighSymbol)externSymbol, null);
    }

    private void buildTrackSet(StringBuilder buf, Register reg, long val) {
        AddressSpace spc = reg.getAddressSpace();
        long offset = reg.getOffset();
        int size = reg.getMinimumByteSize();
        buf.append("<set");
        SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"space", (String)spc.getName());
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"offset", (long)offset);
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"size", (long)size);
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"val", (long)val);
        buf.append("/>\n");
    }

    private ExternalReference getExternalReference(Address addr) {
        Reference ref;
        Data data = this.listing.getDefinedDataAt(addr);
        if (data != null && data.isPointer() && (ref = data.getPrimaryReference(0)) instanceof ExternalReference) {
            return (ExternalReference)ref;
        }
        return null;
    }

    private Object lookupSymbol(Address addr) {
        ExternalReference ref = this.getExternalReference(addr);
        if (ref != null) {
            return ref;
        }
        Function func = this.getFunctionContaining(addr);
        if (func != null) {
            return func;
        }
        Register reg = this.program.getRegister(addr);
        if (reg != null) {
            return null;
        }
        Data data = this.listing.getDataContaining(addr);
        if (data != null) {
            return data;
        }
        Symbol sym = this.program.getSymbolTable().getPrimarySymbol(addr);
        if (sym != null && sym.isGlobal()) {
            return sym;
        }
        return null;
    }

    private boolean isVolatileNoData(Address addr) {
        if (this.program.getLanguage().isVolatile(addr)) {
            return true;
        }
        MemoryBlock block = this.program.getMemory().getBlock(addr);
        return block != null && block.isVolatile();
    }

    private Function getFunctionContaining(Address addr) {
        if (this.cachedFunction != null && this.cachedFunction.getBody().contains(addr)) {
            return this.cachedFunction;
        }
        return this.listing.getFunctionContaining(addr);
    }

    private Function getFunctionAt(Address addr) {
        if (this.cachedFunction != null && this.cachedFunction.getEntryPoint().equals((Object)addr)) {
            return this.cachedFunction;
        }
        ExternalReference extRef = this.getExternalReference(addr);
        if (extRef != null) {
            return this.listing.getFunctionAt(extRef.getToAddress());
        }
        return this.listing.getFunctionAt(addr);
    }

    private boolean isValidChars(String string) {
        char replaceChar = '\ufffd';
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != replaceChar) continue;
            return false;
        }
        return true;
    }

    public StringData getStringData(String addrString, String dtName, String dtId) {
        String stringVal;
        Address addr;
        int maxChars;
        try {
            maxChars = this.readXMLSize(addrString);
            addr = Varnode.readXMLAddress((String)addrString, (AddressFactory)this.addrfactory, (AddressSpace)this.funcEntry.getAddressSpace());
            if (addr == Address.NO_ADDRESS) {
                throw new PcodeXMLException("Address does not physically map");
            }
        }
        catch (PcodeXMLException e) {
            Msg.error((Object)this, (Object)("Decompiling " + this.funcEntry + ": " + e.getMessage()));
            return null;
        }
        Data data = this.program.getListing().getDataContaining(addr);
        Settings settings = SettingsImpl.NO_SETTINGS;
        Object dataType = null;
        StringDataInstance stringInstance = null;
        int length = 0;
        if (data != null && data.getDataType() instanceof AbstractStringDataType) {
            settings = data;
            dataType = (AbstractStringDataType)data.getDataType();
            length = data.getLength();
            if (length <= 0) {
                return null;
            }
            long diff = addr.subtract(data.getAddress()) * (long)addr.getAddressSpace().getAddressableUnitSize();
            if (diff < 0L || diff >= (long)length) {
                return null;
            }
            length = (int)((long)length - diff);
            MemoryBufferImpl buf = new MemoryBufferImpl(this.program.getMemory(), addr, 64);
            stringInstance = dataType.getStringDataInstance((MemBuffer)buf, settings, length);
        }
        if (stringInstance == null) {
            int size;
            DataType dt = this.dtmanage.findBaseType(dtName, dtId);
            dataType = dt instanceof AbstractStringDataType ? (AbstractStringDataType)dt : (dt != null ? ((size = dt.getLength()) == 2 ? TerminatedUnicodeDataType.dataType : (size == 4 ? TerminatedUnicode32DataType.dataType : TerminatedStringDataType.dataType)) : TerminatedStringDataType.dataType);
            MemoryBufferImpl buf = new MemoryBufferImpl(this.program.getMemory(), addr, 64);
            stringInstance = dataType.getStringDataInstance((MemBuffer)buf, settings, maxChars);
            length = stringInstance.getStringLength();
            if (length < 0 || length > maxChars) {
                return null;
            }
        }
        if (!this.isValidChars(stringVal = stringInstance.isShowTranslation() && stringInstance.getTranslatedValue() != null ? stringInstance.getTranslatedValue() : stringInstance.getStringValue())) {
            return null;
        }
        StringData stringData = new StringData();
        stringData.isTruncated = false;
        if (stringVal.length() > maxChars) {
            stringData.isTruncated = true;
            stringVal = stringVal.substring(0, maxChars);
        }
        stringData.byteData = stringVal.getBytes(this.utf8Charset);
        if (this.debug != null) {
            this.debug.getStringData(addr, stringData);
        }
        return stringData;
    }

    private class NameListHandler
    extends DefaultHandler {
        private ArrayList<String> res = new ArrayList();
        private StringBuilder curbuffer = null;

        NameListHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String rawName, Attributes attr) throws SAXException {
            if (localName.equals("val")) {
                this.curbuffer = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            if (this.curbuffer != null && arg0 != null) {
                this.curbuffer.append(arg0, arg1, arg2);
            }
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            if (arg1.equals("val")) {
                this.res.add(this.curbuffer.toString());
                this.curbuffer = null;
            }
        }

        public ArrayList<String> getList() {
            return this.res;
        }
    }

    public static class StringData {
        boolean isTruncated;
        public byte[] byteData;
    }
}

