/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.functionassociation;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.TableFilter;
import docking.widgets.table.TableSortingContext;
import ghidra.feature.vt.api.db.DeletedMatch;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationManager;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.provider.functionassociation.FilterSettings;
import ghidra.feature.vt.gui.provider.functionassociation.FunctionAssociationInfo;
import ghidra.feature.vt.gui.provider.functionassociation.VTFunctionRowObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.util.LongIterator;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.FunctionSignatureTableColumn;
import ghidra.util.table.field.LabelTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

class VTFunctionAssociationTableModel
extends AddressBasedTableModel<VTFunctionRowObject> {
    static final String NAME_COL_NAME = "Name";
    static final String ADDRESS_COL_NAME = "Address";
    static final String PROTOTYPE_COL_NAME = "Prototype";
    static final int ADDRESS_COL_WIDTH = 50;
    static final int NAME_COL = 0;
    static final int ADDRESS_COL = 1;
    static final int PROTOTYPE_COL = 2;
    private static final String TITLE = "VTFunctionAssociation Table Model";
    private final VTController controller;
    private final boolean isSourceProgram;
    private FilterSettings filterSettings = FilterSettings.SHOW_ALL;

    VTFunctionAssociationTableModel(PluginTool tool, VTController controller, Program program, boolean isSourceProgram) {
        super(TITLE + (isSourceProgram ? " Source Program" : " Destination Program"), (ServiceProvider)tool, program, null);
        this.controller = controller;
        this.isSourceProgram = isSourceProgram;
    }

    protected TableColumnDescriptor<VTFunctionRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new LabelTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionSignatureTableColumn()));
        return descriptor;
    }

    public int getKeyCount() {
        if (this.getProgram() == null) {
            return 0;
        }
        FunctionManager functionManager = this.getProgram().getFunctionManager();
        return functionManager.getFunctionCount();
    }

    void functionAdded(Function function) {
        this.addObject(new VTFunctionRowObject(this.getInitializedFunctionInfo(function)));
    }

    private FunctionAssociationInfo getInitializedFunctionInfo(Function function) {
        VTSession session = this.controller.getSession();
        VTAssociationManager associationManager = session.getAssociationManager();
        Collection<VTAssociation> associations = null;
        associations = this.isSourceProgram ? associationManager.getRelatedAssociationsBySourceAddress(function.getEntryPoint()) : associationManager.getRelatedAssociationsByDestinationAddress(function.getEntryPoint());
        boolean isInAssociation = !associations.isEmpty();
        boolean isInAcceptedAssociation = this.containsAcceptedAssocation(associations);
        FunctionAssociationInfo info = new FunctionAssociationInfo(function.getID());
        info.setFilterData(isInAssociation, isInAcceptedAssociation);
        return info;
    }

    private boolean containsAcceptedAssocation(Collection<VTAssociation> associations) {
        for (VTAssociation vtAssociation : associations) {
            if (vtAssociation.getStatus() != VTAssociationStatus.ACCEPTED) continue;
            return true;
        }
        return false;
    }

    void functionRemoved(Function function) {
        this.removeObject(new VTFunctionRowObject(new FunctionAssociationInfo(function.getID())));
    }

    void associationChanged(VTAssociation association) {
        Address address = null;
        address = this.isSourceProgram ? association.getSourceAddress() : association.getDestinationAddress();
        FunctionManager functionManager = this.getProgram().getFunctionManager();
        Function function = functionManager.getFunctionAt(address);
        if (function == null) {
            return;
        }
        FunctionAssociationInfo info = this.getFunctionInfo(function);
        if (info == null) {
            return;
        }
        info.setFilterData(true, association.getStatus() == VTAssociationStatus.ACCEPTED);
        this.reFilter();
    }

    void matchAdded(VTMatch match) {
        VTAssociation association = match.getAssociation();
        Address address = null;
        address = this.isSourceProgram ? association.getSourceAddress() : association.getDestinationAddress();
        FunctionManager functionManager = this.getProgram().getFunctionManager();
        Function function = functionManager.getFunctionAt(address);
        if (function == null) {
            return;
        }
        FunctionAssociationInfo info = this.getFunctionInfo(function);
        if (info == null) {
            return;
        }
        info.setFilterData(true, association.getStatus() == VTAssociationStatus.ACCEPTED);
        this.reFilter();
    }

    private FunctionAssociationInfo getFunctionInfo(Function function) {
        int index = this.getUnfilteredIndexForRowObject(new VTFunctionRowObject(new FunctionAssociationInfo(function.getID())));
        VTFunctionRowObject existingRowObject = (VTFunctionRowObject)this.getUnfilteredRowObjectForIndex(index);
        if (existingRowObject == null) {
            return null;
        }
        return existingRowObject.getInfo();
    }

    void matchRemoved(DeletedMatch match) {
        Address address = null;
        address = this.isSourceProgram ? match.getSourceAddress() : match.getDestinationAddress();
        FunctionManager functionManager = this.getProgram().getFunctionManager();
        Function function = functionManager.getFunctionAt(address);
        if (function == null) {
            return;
        }
        FunctionAssociationInfo info = this.getFunctionInfo(function);
        if (info == null) {
            return;
        }
        info.setFilterData(false, false);
        this.reFilter();
    }

    void clear() {
        this.clearData();
    }

    Function getFunction(int row) {
        VTFunctionRowObject rowObject = (VTFunctionRowObject)this.getRowObject(row);
        FunctionAssociationInfo info = rowObject.getInfo();
        Program program = this.getProgram();
        FunctionManager manager = program.getFunctionManager();
        return manager.getFunction(info.getFunctionID());
    }

    public Address getAddress(int row) {
        Function function = this.getFunction(row);
        return function != null ? function.getEntryPoint() : null;
    }

    public void setFilterSettings(FilterSettings settings) {
        this.filterSettings = settings;
        this.reFilter();
    }

    protected void doLoad(Accumulator<VTFunctionRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        LongIterator it = LongIterator.EMPTY;
        if (this.getProgram() != null) {
            FunctionManager functionManager = this.getProgram().getFunctionManager();
            it = new FunctionKeyIterator(functionManager);
            monitor.initialize((long)this.getKeyCount());
            while (it.hasNext()) {
                monitor.incrementProgress(1L);
                monitor.checkCanceled();
                long key = it.next();
                Function f = functionManager.getFunction(key);
                if (f.isThunk()) continue;
                accumulator.add((Object)new VTFunctionRowObject(new FunctionAssociationInfo(key)));
            }
        }
    }

    public List<VTFunctionRowObject> doFilter(List<VTFunctionRowObject> data, TableSortingContext<VTFunctionRowObject> lastSortingContext, TaskMonitor monitor) throws CancelledException {
        if (data.size() == 0) {
            return data;
        }
        if (this.hasNoFilter()) {
            return data;
        }
        if (this.filterSettings != FilterSettings.SHOW_ALL) {
            this.initializeFilterData(data, monitor);
        }
        monitor.initialize((long)data.size());
        ArrayList<VTFunctionRowObject> filteredList = new ArrayList<VTFunctionRowObject>();
        for (int row = 0; row < data.size(); ++row) {
            if (monitor.isCancelled()) {
                return filteredList;
            }
            monitor.incrementProgress(1L);
            VTFunctionRowObject rowObject = data.get(row);
            FunctionAssociationInfo info = rowObject.getInfo();
            if (!this.passesUnmatchedFunctionFilter(info) || !this.rowMatchesFilters(row, rowObject, monitor)) continue;
            VTFunctionRowObject newObject = new VTFunctionRowObject(info);
            filteredList.add(newObject);
        }
        return filteredList;
    }

    private boolean hasNoFilter() {
        return this.filterSettings == FilterSettings.SHOW_ALL && !this.hasFilter();
    }

    private boolean passesUnmatchedFunctionFilter(FunctionAssociationInfo info) {
        switch (this.filterSettings) {
            case SHOW_UNACCEPTED: {
                return !info.isInAcceptedAssociation();
            }
            case SHOW_UNMATCHED: {
                return !info.isInAssociation();
            }
        }
        return true;
    }

    private void initializeFilterData(List<VTFunctionRowObject> data, TaskMonitor monitor) throws CancelledException {
        VTSession session = this.controller.getSession();
        VTAssociationManager associationManager = session.getAssociationManager();
        monitor.setMessage("Loading matched functions...");
        monitor.initialize((long)associationManager.getAssociationCount());
        HashSet<Long> matchSet = new HashSet<Long>();
        HashSet<Long> acceptedSet = new HashSet<Long>();
        FunctionManager functionManager = this.getProgram().getFunctionManager();
        List<VTAssociation> associations = associationManager.getAssociations();
        for (VTAssociation association : associations) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            Address functionAddress = null;
            functionAddress = this.isSourceProgram ? association.getSourceAddress() : association.getDestinationAddress();
            Function function = functionManager.getFunctionAt(functionAddress);
            if (function == null) continue;
            Long functionID = function.getID();
            matchSet.add(functionID);
            if (association.getStatus() != VTAssociationStatus.ACCEPTED) continue;
            acceptedSet.add(functionID);
        }
        monitor.setMessage("Setting filter data...");
        monitor.initialize((long)data.size());
        for (int row = 0; row < data.size(); ++row) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            VTFunctionRowObject rowObject = data.get(row);
            FunctionAssociationInfo info = rowObject.getInfo();
            Long functionID = info.getFunctionID();
            info.setFilterData(matchSet.contains(functionID), acceptedSet.contains(functionID));
        }
    }

    private boolean rowMatchesFilters(int row, VTFunctionRowObject rowObject, TaskMonitor monitor) {
        TableFilter tableFilter = this.getTableFilter();
        return tableFilter.acceptsRow((Object)rowObject);
    }

    private class FunctionKeyIterator
    implements LongIterator {
        private FunctionIterator itr;

        FunctionKeyIterator(FunctionManager functionMgr) {
            this.itr = functionMgr.getFunctions(true);
        }

        public boolean hasNext() {
            if (this.itr == null) {
                return false;
            }
            return this.itr.hasNext();
        }

        public long next() {
            Function function = (Function)this.itr.next();
            return function.getID();
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        public long previous() {
            throw new UnsupportedOperationException();
        }
    }
}

