/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.plugin;

import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.plugin.VTSubToolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SubToolContext {
    private final VTPlugin plugin;
    private VTSubToolManager toolManager;
    private VTMatch match;

    public SubToolContext(VTPlugin plugin) {
        this.plugin = plugin;
        this.toolManager = plugin.getToolManager();
    }

    public Function getSourceFunction() {
        return this.toolManager.getSourceFunction();
    }

    public Function getDestinationFunction() {
        return this.toolManager.getDestinationFunction();
    }

    public boolean isSourceCursorOnScreen() {
        return this.toolManager.isSourceCursorOnScreen();
    }

    public boolean isDestinationCursorOnScreen() {
        return this.toolManager.isDestinationCursorOnScreen();
    }

    public VTMatch getMatch() {
        if (this.match == null) {
            this.match = this.getExistingMatch(this.getSourceFunction(), this.getDestinationFunction());
        }
        return this.match;
    }

    private VTMatch getExistingMatch(Function sourceFunction, Function destinationFunction) {
        if (sourceFunction == null || destinationFunction == null) {
            return null;
        }
        Address sourceAddress = sourceFunction.getEntryPoint();
        Address destinationAddress = destinationFunction.getEntryPoint();
        VTController controller = this.plugin.getController();
        VTSession session = controller.getSession();
        List<VTMatchSet> matchSets = session.getMatchSets();
        for (VTMatchSet matchSet : matchSets) {
            Collection<VTMatch> matches = matchSet.getMatches(sourceAddress, destinationAddress);
            Iterator<VTMatch> iterator = matches.iterator();
            if (!iterator.hasNext()) continue;
            VTMatch nextMatch = iterator.next();
            return nextMatch;
        }
        return null;
    }
}

