/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryField;
import db.DBFieldIterator;
import db.DBHandle;
import db.DBLongIterator;
import db.Field;
import db.IndexBuffer;
import db.IndexTable;
import db.Record;
import db.Schema;
import db.Table;
import db.TableRecord;
import java.io.IOException;
import java.util.NoSuchElementException;

class FixedIndexTable
extends IndexTable {
    private static final Class<?>[] fieldClasses = new Class[]{BinaryField.class};
    private static final String[] fieldNames = new String[]{"IndexBuffer"};
    private static Schema indexSchema = new Schema(0, "IndexKey", fieldClasses, fieldNames);

    FixedIndexTable(Table primaryTable, int colIndex) throws IOException {
        this(primaryTable, primaryTable.getDBHandle().getMasterTable().createTableRecord(primaryTable.getName(), indexSchema, colIndex));
    }

    FixedIndexTable(Table primaryTable, TableRecord indexTableRecord) throws IOException {
        super(primaryTable, indexTableRecord);
    }

    @Override
    long[] findPrimaryKeys(Field indexValue) throws IOException {
        if (!indexValue.getClass().equals(this.fieldType.getClass())) {
            throw new IllegalArgumentException("Incorrect indexed field type");
        }
        Record indexRecord = this.indexTable.getRecord(indexValue.getLongValue());
        if (indexRecord == null) {
            return emptyKeyArray;
        }
        IndexBuffer indexBuffer = new IndexBuffer(indexValue, indexRecord.getBinaryData(0));
        return indexBuffer.getPrimaryKeys();
    }

    @Override
    int getKeyCount(Field indexValue) throws IOException {
        if (!indexValue.getClass().equals(this.fieldType.getClass())) {
            throw new IllegalArgumentException("Incorrect indexed field type");
        }
        Record indexRecord = this.indexTable.getRecord(indexValue.getLongValue());
        if (indexRecord == null) {
            return 0;
        }
        IndexBuffer indexBuffer = new IndexBuffer(indexValue, indexRecord.getBinaryData(0));
        return indexBuffer.keyCount;
    }

    @Override
    void addEntry(Record record) throws IOException {
        Field indexField = record.getField(this.colIndex);
        long secondaryKey = indexField.getLongValue();
        Record indexRecord = this.indexTable.getRecord(secondaryKey);
        if (indexRecord == null) {
            indexRecord = indexSchema.createRecord(secondaryKey);
        }
        IndexBuffer indexBuffer = new IndexBuffer(indexField, indexRecord.getBinaryData(0));
        indexBuffer.addEntry(record.getKey());
        indexRecord.setBinaryData(0, indexBuffer.getData());
        this.indexTable.putRecord(indexRecord);
    }

    @Override
    void deleteEntry(Record record) throws IOException {
        Field indexField = record.getField(this.colIndex);
        long secondaryKey = indexField.getLongValue();
        Record indexRecord = this.indexTable.getRecord(secondaryKey);
        if (indexRecord != null) {
            IndexBuffer indexBuffer = new IndexBuffer(indexField, indexRecord.getBinaryData(0));
            indexBuffer.deleteEntry(record.getKey());
            byte[] data = indexBuffer.getData();
            if (data == null) {
                this.indexTable.deleteRecord(secondaryKey);
            } else {
                indexRecord.setBinaryData(0, data);
                this.indexTable.putRecord(indexRecord);
            }
        }
    }

    private IndexBuffer getIndexBuffer(Field indexKey) throws IOException {
        Record indexRec = this.indexTable.getRecord(indexKey.getLongValue());
        return indexRec != null ? new IndexBuffer(indexKey, indexRec.getBinaryData(0)) : null;
    }

    @Override
    DBFieldIterator indexIterator() throws IOException {
        return new IndexLongIterator();
    }

    @Override
    DBFieldIterator indexIterator(Field minField, Field maxField, boolean atMin) throws IOException {
        long min = minField != null ? minField.getLongValue() : Long.MIN_VALUE;
        long max = maxField != null ? maxField.getLongValue() : Long.MAX_VALUE;
        return new IndexLongIterator(min, max, atMin);
    }

    @Override
    DBFieldIterator indexIterator(Field minField, Field maxField, Field startField, boolean before) throws IOException {
        if (startField == null) {
            throw new IllegalArgumentException("starting index value required");
        }
        long min = minField != null ? minField.getLongValue() : Long.MIN_VALUE;
        long max = maxField != null ? maxField.getLongValue() : Long.MAX_VALUE;
        return new IndexLongIterator(min, max, startField.getLongValue(), before);
    }

    class IndexLongIterator
    implements DBFieldIterator {
        private Field lastKey;
        private Field keyField;
        private DBLongIterator indexIterator;
        private boolean hasNext;
        private boolean hasPrev;

        IndexLongIterator() throws IOException {
            this.hasNext = false;
            this.hasPrev = false;
            this.indexIterator = FixedIndexTable.this.indexTable.longKeyIterator();
        }

        IndexLongIterator(long minValue, long maxValue, boolean atMin) throws IOException {
            this.hasNext = false;
            this.hasPrev = false;
            long start = atMin ? minValue : maxValue;
            this.indexIterator = FixedIndexTable.this.indexTable.longKeyIterator(minValue, maxValue, start);
            if (this.indexIterator.hasNext()) {
                this.indexIterator.next();
                if (atMin) {
                    this.indexIterator.previous();
                }
            }
        }

        public IndexLongIterator(long minValue, long maxValue, long start, boolean before) throws IOException {
            this.hasNext = false;
            this.hasPrev = false;
            this.indexIterator = FixedIndexTable.this.indexTable.longKeyIterator(minValue, maxValue, start);
            if (this.indexIterator.hasNext()) {
                long val = this.indexIterator.next();
                if (before || val != start) {
                    this.indexIterator.previous();
                }
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.hasNext) {
                return true;
            }
            try {
                long key = this.indexIterator.next();
                this.keyField = FixedIndexTable.this.fieldType.newField();
                this.keyField.setLongValue(key);
                this.hasNext = true;
                this.hasPrev = false;
            }
            catch (NoSuchElementException e) {
                return false;
            }
            return true;
        }

        @Override
        public boolean hasPrevious() throws IOException {
            if (this.hasPrev) {
                return true;
            }
            try {
                long key = this.indexIterator.previous();
                this.keyField = FixedIndexTable.this.fieldType.newField();
                this.keyField.setLongValue(key);
                this.hasNext = false;
                this.hasPrev = true;
            }
            catch (NoSuchElementException e) {
                return false;
            }
            return true;
        }

        @Override
        public Field next() throws IOException {
            if (this.hasNext || this.hasNext()) {
                this.hasNext = false;
                this.hasPrev = true;
                this.lastKey = this.keyField;
                return this.keyField;
            }
            return null;
        }

        @Override
        public Field previous() throws IOException {
            if (this.hasPrev || this.hasPrevious()) {
                this.hasNext = true;
                this.hasPrev = false;
                this.lastKey = this.keyField;
                return this.keyField;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete() throws IOException {
            if (this.lastKey == null) {
                return false;
            }
            DBHandle dBHandle = FixedIndexTable.this.db;
            synchronized (dBHandle) {
                IndexBuffer indexBuf = FixedIndexTable.this.getIndexBuffer(this.lastKey);
                if (indexBuf != null) {
                    long[] keys;
                    for (long key : keys = indexBuf.getPrimaryKeys()) {
                        FixedIndexTable.this.primaryTable.deleteRecord(key);
                    }
                    this.indexIterator.delete();
                }
                this.lastKey = null;
                return true;
            }
        }
    }
}

