/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.DBFieldIterator;
import db.DBHandle;
import db.DBLongIterator;
import db.Field;
import db.IndexField;
import db.IndexTable;
import db.Record;
import db.Schema;
import db.Table;
import db.TableRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class FieldIndexTable
extends IndexTable {
    private static final Class<?>[] fieldClasses = new Class[0];
    private static final String[] fieldNames = new String[0];
    private final Schema indexSchema;
    private final int indexColumn;

    FieldIndexTable(Table primaryTable, int colIndex) throws IOException {
        this(primaryTable, primaryTable.getDBHandle().getMasterTable().createTableRecord(primaryTable.getName(), FieldIndexTable.getIndexTableSchema(primaryTable, colIndex), colIndex));
    }

    FieldIndexTable(Table primaryTable, TableRecord indexTableRecord) throws IOException {
        super(primaryTable, indexTableRecord);
        this.indexSchema = this.indexTable.getSchema();
        this.indexColumn = indexTableRecord.getIndexedColumn();
    }

    private static Schema getIndexTableSchema(Table primaryTable, int colIndex) {
        byte fieldType = primaryTable.getSchema().getField(colIndex).getFieldType();
        IndexField indexKeyField = IndexField.getIndexField(fieldType);
        return new Schema(0, indexKeyField.getClass(), "IndexKey", fieldClasses, fieldNames);
    }

    @Override
    long[] findPrimaryKeys(Field indexValue) throws IOException {
        IndexField f;
        IndexField indexField = IndexField.getIndexField(indexValue, Long.MIN_VALUE);
        DBFieldIterator iter = this.indexTable.fieldKeyIterator(indexField);
        ArrayList<IndexField> list = new ArrayList<IndexField>(20);
        while (iter.hasNext() && (f = (IndexField)iter.next()).hasSameIndex(indexField)) {
            Record rec;
            Field val;
            if (indexField.usesTruncatedFieldValue() && !indexValue.equals(val = (rec = this.primaryTable.getRecord(f.getPrimaryKey())).getField(this.indexColumn))) continue;
            list.add(f);
        }
        long[] keys = new long[list.size()];
        for (int i = 0; i < keys.length; ++i) {
            IndexField f2 = (IndexField)list.get(i);
            keys[i] = f2.getPrimaryKey();
        }
        return keys;
    }

    @Override
    int getKeyCount(Field indexValue) throws IOException {
        return this.findPrimaryKeys(indexValue).length;
    }

    @Override
    void addEntry(Record record) throws IOException {
        Field indexedField = record.getField(this.colIndex);
        IndexField f = IndexField.getIndexField(indexedField, record.getKey());
        Record rec = this.indexSchema.createRecord(f);
        this.indexTable.putRecord(rec);
    }

    @Override
    void deleteEntry(Record record) throws IOException {
        Field indexedField = record.getField(this.colIndex);
        IndexField f = IndexField.getIndexField(indexedField, record.getKey());
        this.indexTable.deleteRecord(f);
    }

    @Override
    DBFieldIterator indexIterator() throws IOException {
        return new IndexFieldIterator();
    }

    @Override
    DBFieldIterator indexIterator(Field minField, Field maxField, boolean before) throws IOException {
        return new IndexFieldIterator(minField, maxField, before);
    }

    @Override
    DBFieldIterator indexIterator(Field minField, Field maxField, Field startField, boolean before) throws IOException {
        return new IndexFieldIterator(minField, maxField, startField, before);
    }

    @Override
    boolean hasRecord(Field field) throws IOException {
        IndexField indexField = IndexField.getIndexField(field, Long.MIN_VALUE);
        DBFieldIterator iter = this.indexTable.fieldKeyIterator(indexField);
        while (iter.hasNext()) {
            Record rec;
            Field val;
            IndexField f = (IndexField)iter.next();
            if (!f.hasSameIndex(indexField)) {
                return false;
            }
            if (indexField.usesTruncatedFieldValue() && !field.equals(val = (rec = this.primaryTable.getRecord(f.getPrimaryKey())).getField(this.indexColumn))) continue;
            return true;
        }
        return false;
    }

    @Override
    DBLongIterator keyIterator() throws IOException {
        return new PrimaryKeyIterator();
    }

    @Override
    DBLongIterator keyIteratorBefore(Field startField) throws IOException {
        return new PrimaryKeyIterator(startField, false);
    }

    @Override
    DBLongIterator keyIteratorAfter(Field startField) throws IOException {
        return new PrimaryKeyIterator(startField, true);
    }

    @Override
    DBLongIterator keyIteratorBefore(Field startField, long primaryKey) throws IOException {
        return new PrimaryKeyIterator(null, null, startField, primaryKey, false);
    }

    @Override
    DBLongIterator keyIteratorAfter(Field startField, long primaryKey) throws IOException {
        return new PrimaryKeyIterator(null, null, startField, primaryKey, true);
    }

    @Override
    DBLongIterator keyIterator(Field startField, Field endField, boolean atStart) throws IOException {
        return new PrimaryKeyIterator(startField, endField, atStart ? startField : endField, atStart ? Long.MIN_VALUE : Long.MAX_VALUE, !atStart);
    }

    @Override
    DBLongIterator keyIterator(Field minField, Field maxField, Field startField, boolean before) throws IOException {
        return new PrimaryKeyIterator(minField, maxField, startField, before ? Long.MIN_VALUE : Long.MAX_VALUE, !before);
    }

    private class PrimaryKeyIterator
    implements DBLongIterator {
        private IndexField min;
        private IndexField max;
        private DBFieldIterator indexIterator;
        private boolean hasNext = false;
        private boolean hasPrev = false;
        private IndexField key;
        private IndexField lastKey;

        PrimaryKeyIterator() throws IOException {
            this.indexIterator = FieldIndexTable.this.indexTable.fieldKeyIterator();
        }

        PrimaryKeyIterator(Field startValue, boolean after) throws IOException {
            this(null, null, startValue, after ? Long.MAX_VALUE : Long.MIN_VALUE, after);
        }

        PrimaryKeyIterator(Field minValue, Field maxValue, Field startValue, long primaryKey, boolean after) throws IOException {
            this.min = minValue != null ? IndexField.getIndexField(minValue, Long.MIN_VALUE) : null;
            this.max = maxValue != null ? IndexField.getIndexField(maxValue, Long.MAX_VALUE) : null;
            IndexField start = null;
            if (after && startValue == null && maxValue == null) {
                this.indexIterator = FieldIndexTable.this.indexTable.fieldKeyIterator((Field)this.min, (Field)this.max, !after);
                if (this.indexIterator.hasNext()) {
                    this.indexIterator.next();
                }
            } else {
                start = startValue != null ? IndexField.getIndexField(startValue, primaryKey) : null;
                this.indexIterator = FieldIndexTable.this.indexTable.fieldKeyIterator((Field)this.min, (Field)this.max, start);
                if (this.indexIterator.hasNext()) {
                    Field f = this.indexIterator.next();
                    if (!after || !f.equals(start)) {
                        this.indexIterator.previous();
                    }
                }
            }
        }

        private boolean indexValueOutOfRange(IndexField f) throws IOException {
            Record rec;
            Comparable val = null;
            if (this.min != null && this.min.usesTruncatedFieldValue() && this.min.hasSameIndex(f) && (val = (rec = FieldIndexTable.this.primaryTable.getRecord(f.getPrimaryKey())).getField(FieldIndexTable.this.indexColumn)).compareTo(this.min.getNonTruncatedIndexField()) < 0) {
                return true;
            }
            if (this.max != null && this.max.usesTruncatedFieldValue() && this.max.hasSameIndex(f)) {
                if (val == null) {
                    rec = FieldIndexTable.this.primaryTable.getRecord(f.getPrimaryKey());
                    val = rec.getField(FieldIndexTable.this.indexColumn);
                }
                if (val.compareTo(this.min.getNonTruncatedIndexField()) > 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.hasNext) {
                return true;
            }
            while (this.indexIterator.hasNext()) {
                this.hasPrev = false;
                this.key = (IndexField)this.indexIterator.next();
                if (this.indexValueOutOfRange(this.key)) continue;
                this.hasNext = true;
                break;
            }
            return this.hasNext;
        }

        @Override
        public boolean hasPrevious() throws IOException {
            if (this.hasPrev) {
                return true;
            }
            while (this.indexIterator.hasPrevious()) {
                this.hasNext = false;
                this.key = (IndexField)this.indexIterator.previous();
                if (this.indexValueOutOfRange(this.key)) continue;
                this.hasPrev = true;
                break;
            }
            return this.hasPrev;
        }

        @Override
        public long next() throws IOException {
            if (this.hasNext()) {
                this.lastKey = this.key;
                this.hasNext = false;
                return this.key.getPrimaryKey();
            }
            throw new NoSuchElementException();
        }

        @Override
        public long previous() throws IOException {
            if (this.hasPrevious()) {
                this.lastKey = this.key;
                this.hasPrev = false;
                return this.key.getPrimaryKey();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean delete() throws IOException {
            if (this.lastKey != null) {
                long primaryKey = this.lastKey.getPrimaryKey();
                this.lastKey = null;
                return FieldIndexTable.this.primaryTable.deleteRecord(primaryKey);
            }
            return false;
        }
    }

    class IndexFieldIterator
    implements DBFieldIterator {
        private IndexField min;
        private IndexField max;
        private IndexField lastKey;
        private IndexField indexKey;
        private DBFieldIterator indexIterator;
        private boolean hasNext = false;
        private boolean hasPrev = false;

        IndexFieldIterator() throws IOException {
            this(null, null, true);
        }

        IndexFieldIterator(Field minValue, Field maxValue, boolean before) throws IOException {
            if (FieldIndexTable.this.primaryTable.getSchema().getField(FieldIndexTable.this.indexColumn).isVariableLength()) {
                throw new UnsupportedOperationException("Due to potential truncation issues, operation not permitted on variable length fields");
            }
            this.min = minValue != null ? IndexField.getIndexField(minValue, Long.MIN_VALUE) : null;
            this.max = maxValue != null ? IndexField.getIndexField(maxValue, Long.MAX_VALUE) : null;
            IndexField start = null;
            if (before && minValue != null) {
                start = this.min;
            } else if (!before && maxValue != null) {
                start = this.max;
            }
            this.indexIterator = start != null ? FieldIndexTable.this.indexTable.fieldKeyIterator((Field)this.min, (Field)this.max, start) : FieldIndexTable.this.indexTable.fieldKeyIterator((Field)this.min, (Field)this.max, before);
            if (this.indexIterator.hasNext()) {
                this.indexIterator.next();
                if (before) {
                    this.indexIterator.previous();
                }
            }
        }

        public IndexFieldIterator(Field minValue, Field maxValue, Field startValue, boolean before) throws IOException {
            if (FieldIndexTable.this.primaryTable.getSchema().getField(FieldIndexTable.this.indexColumn).isVariableLength()) {
                throw new UnsupportedOperationException("Due to potential truncation issues, operation not permitted on variable length fields");
            }
            if (startValue == null) {
                throw new IllegalArgumentException("starting index value required");
            }
            this.min = minValue != null ? IndexField.getIndexField(minValue, Long.MIN_VALUE) : null;
            this.max = maxValue != null ? IndexField.getIndexField(maxValue, Long.MAX_VALUE) : null;
            IndexField start = IndexField.getIndexField(startValue, before ? Long.MIN_VALUE : Long.MAX_VALUE);
            this.indexIterator = FieldIndexTable.this.indexTable.fieldKeyIterator((Field)this.min, (Field)this.max, start);
            if (this.indexIterator.hasNext()) {
                IndexField f = (IndexField)this.indexIterator.next();
                if (before || !f.getIndexField().equals(startValue)) {
                    this.indexIterator.previous();
                }
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.hasNext) {
                return true;
            }
            this.hasPrev = false;
            this.indexKey = (IndexField)this.indexIterator.next();
            int skipCnt = 0;
            while (this.indexKey != null && this.indexKey.hasSameIndex(this.lastKey)) {
                if (++skipCnt > 10) {
                    this.indexIterator = FieldIndexTable.this.indexTable.fieldKeyIterator((Field)this.min, (Field)this.max, IndexField.getIndexField(this.indexKey.getIndexField(), Long.MAX_VALUE));
                    skipCnt = 0;
                }
                this.indexKey = (IndexField)this.indexIterator.next();
            }
            if (this.indexKey == null) {
                return false;
            }
            this.hasNext = true;
            return true;
        }

        @Override
        public boolean hasPrevious() throws IOException {
            if (this.hasPrev) {
                return true;
            }
            this.hasNext = false;
            this.indexKey = (IndexField)this.indexIterator.previous();
            int skipCnt = 0;
            while (this.indexKey != null && this.indexKey.hasSameIndex(this.lastKey)) {
                if (++skipCnt > 10) {
                    this.indexIterator = FieldIndexTable.this.indexTable.fieldKeyIterator((Field)this.min, (Field)this.max, IndexField.getIndexField(this.indexKey.getIndexField(), Long.MIN_VALUE));
                    skipCnt = 0;
                }
                this.indexKey = (IndexField)this.indexIterator.previous();
            }
            if (this.indexKey == null) {
                return false;
            }
            this.hasPrev = true;
            return true;
        }

        @Override
        public Field next() throws IOException {
            if (this.hasNext || this.hasNext()) {
                this.hasNext = false;
                this.hasPrev = true;
                this.lastKey = this.indexKey;
                Field f = this.indexKey.getIndexField();
                return f.newField(f);
            }
            return null;
        }

        @Override
        public Field previous() throws IOException {
            if (this.hasPrev || this.hasPrevious()) {
                this.hasNext = true;
                this.hasPrev = false;
                this.lastKey = this.indexKey;
                Field f = this.indexKey.getIndexField();
                return f.newField(f);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete() throws IOException {
            if (this.lastKey == null) {
                return false;
            }
            DBHandle dBHandle = FieldIndexTable.this.db;
            synchronized (dBHandle) {
                long[] keys;
                for (long key : keys = FieldIndexTable.this.findPrimaryKeys(this.lastKey.getIndexField())) {
                    FieldIndexTable.this.primaryTable.deleteRecord(key);
                }
                this.lastKey = null;
                return true;
            }
        }
    }
}

