/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.RttiUtil;
import ghidra.app.cmd.data.rtti.VfTableModel;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;

public class CreateVfTableBackgroundCmd
extends AbstractCreateDataBackgroundCmd<VfTableModel> {
    private static final String NAME = "vftable";
    private static final String VF_TABLE_LABEL = "vftable";
    private static final String META_LABEL = "meta";
    private static final String NAME_SEPARATOR = "_";

    public CreateVfTableBackgroundCmd(Address address, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("vftable", address, 1, validationOptions, applyOptions);
    }

    CreateVfTableBackgroundCmd(VfTableModel vfTableModel, DataApplyOptions applyOptions) {
        super(vfTableModel, applyOptions);
    }

    @Override
    protected VfTableModel createModel(Program program) {
        if (this.model == null || program != ((VfTableModel)this.model).getProgram()) {
            this.model = new VfTableModel(program, this.getDataAddress(), this.validationOptions);
        }
        return (VfTableModel)this.model;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        boolean createTerminatorSuccess;
        this.monitor.checkCanceled();
        try {
            createTerminatorSuccess = this.createTableTerminator();
        }
        catch (InvalidDataTypeException e) {
            createTerminatorSuccess = false;
            this.handleErrorMessage(((VfTableModel)this.model).getProgram(), ((VfTableModel)this.model).getAddress(), e.getMessage());
        }
        boolean createMetaSuccess = this.createMetaPointer();
        return createTerminatorSuccess && createMetaSuccess;
    }

    private boolean createTableTerminator() throws CancelledException, InvalidDataTypeException {
        Program program = ((VfTableModel)this.model).getProgram();
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return false;
        }
        long displacement = dataType.getLength();
        Address terminatorAddress = this.getDataAddress().add(displacement);
        try {
            Address referencedAddress = MSDataTypeUtils.getAbsoluteAddress((Program)program, (Address)terminatorAddress);
            if (referencedAddress == null || referencedAddress.getOffset() != 0L) {
                return false;
            }
            Data data = DataUtilities.createData((Program)program, (Address)terminatorAddress, (DataType)PointerDataType.dataType, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)this.getClearDataMode());
            TypeDescriptorModel rtti0Model = ((VfTableModel)this.model).getRtti0Model();
            if (rtti0Model != null) {
                this.monitor.checkCanceled();
                String demangledTypeDescriptor = rtti0Model.getDemangledTypeDescriptor();
                Object prefixString = demangledTypeDescriptor != null ? demangledTypeDescriptor + "::" : "";
                data.setComment(0, "terminator for " + (String)prefixString + "vftable");
                return true;
            }
            return false;
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)((Object)this), (Object)("Couldn't create vf table's null terminator pointer. " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean createMetaPointer() {
        Program program = ((VfTableModel)this.model).getProgram();
        Address metaAddress = this.getDataAddress().subtract((long)program.getDefaultPointerSize());
        PointerDataType metaPointer = new PointerDataType((DataTypeManager)program.getDataTypeManager());
        try {
            DataUtilities.createData((Program)program, (Address)metaAddress, (DataType)metaPointer, (int)metaPointer.getLength(), (boolean)false, (DataUtilities.ClearDataMode)this.getClearDataMode());
            return true;
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)((Object)this), (Object)("Couldn't create vf table's meta pointer. " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean createMarkup() throws CancelledException, InvalidDataTypeException {
        boolean createdVfTableMarkup = this.createVfTableMarkup();
        boolean createdMetaMarkup = this.createMetaMarkup();
        return createdVfTableMarkup && createdMetaMarkup;
    }

    private boolean createVfTableMarkup() throws CancelledException, InvalidDataTypeException {
        Address vfTableAddress = this.getDataAddress();
        Program program = ((VfTableModel)this.model).getProgram();
        this.monitor.checkCanceled();
        TypeDescriptorModel rtti0Model = ((VfTableModel)this.model).getRtti0Model();
        if (rtti0Model != null) {
            EHDataTypeUtilities.createPlateCommentIfNeeded(program, "const " + RttiUtil.getDescriptorTypeNamespace(rtti0Model) + "::", "vftable", null, vfTableAddress, this.applyOptions);
            this.monitor.checkCanceled();
            if (this.applyOptions.shouldCreateLabel()) {
                RttiUtil.createSymbolFromDemangledType(program, vfTableAddress, rtti0Model, "vftable");
            }
        }
        if (this.applyOptions.shouldCreateFunction()) {
            int elementCount = ((VfTableModel)this.model).getElementCount();
            for (int tableElementIndex = 0; tableElementIndex < elementCount; ++tableElementIndex) {
                this.monitor.checkCanceled();
                Address vfPointer = ((VfTableModel)this.model).getVirtualFunctionPointer(tableElementIndex);
                if (vfPointer == null) continue;
                EHDataTypeUtilities.createFunctionIfNeeded(program, vfPointer);
            }
        }
        return true;
    }

    private boolean createMetaMarkup() throws CancelledException, InvalidDataTypeException {
        Program program = ((VfTableModel)this.model).getProgram();
        Address metaAddress = this.getMetaAddress(program);
        this.monitor.checkCanceled();
        TypeDescriptorModel rtti0Model = ((VfTableModel)this.model).getRtti0Model();
        if (rtti0Model != null) {
            EHDataTypeUtilities.createPlateCommentIfNeeded(program, "meta pointer for " + RttiUtil.getDescriptorTypeNamespace(rtti0Model) + "::", "vftable", null, metaAddress, this.applyOptions);
            this.monitor.checkCanceled();
            if (this.applyOptions.shouldCreateLabel()) {
                RttiUtil.createSymbolFromDemangledType(program, metaAddress, rtti0Model, "vftable_meta_ptr");
            }
        }
        return true;
    }

    private Address getMetaAddress(Program program) {
        return this.getDataAddress().subtract((long)program.getDefaultPointerSize());
    }
}

