/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.CreateRtti2BackgroundCmd;
import ghidra.app.cmd.data.rtti.Rtti3Model;
import ghidra.app.cmd.data.rtti.RttiUtil;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;

public class CreateRtti3BackgroundCmd
extends AbstractCreateDataBackgroundCmd<Rtti3Model> {
    private static final String RTTI_3_NAME = "RTTI Class Hierarchy Descriptor";

    public CreateRtti3BackgroundCmd(Address address, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("RTTIClassHierarchyDescriptor", address, 1, validationOptions, applyOptions);
    }

    CreateRtti3BackgroundCmd(Rtti3Model rtti3Model, DataApplyOptions applyOptions) {
        super(rtti3Model, applyOptions);
    }

    @Override
    protected Rtti3Model createModel(Program program) {
        if (this.model == null || program != ((Rtti3Model)this.model).getProgram()) {
            this.model = new Rtti3Model(program, this.getDataAddress(), this.validationOptions);
        }
        return (Rtti3Model)this.model;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        try {
            return this.createRtti2();
        }
        catch (InvalidDataTypeException e) {
            this.handleErrorMessage(((Rtti3Model)this.model).getProgram(), ((Rtti3Model)this.model).getAddress(), e.getMessage());
            return false;
        }
    }

    private boolean createRtti2() throws CancelledException, InvalidDataTypeException {
        this.monitor.checkCanceled();
        CreateRtti2BackgroundCmd cmd = new CreateRtti2BackgroundCmd(((Rtti3Model)this.model).getRtti2Model(), this.applyOptions);
        return cmd.applyTo((DomainObject)((Rtti3Model)this.model).getProgram(), this.monitor);
    }

    @Override
    protected boolean createMarkup() throws CancelledException, InvalidDataTypeException {
        this.monitor.checkCanceled();
        Program program = ((Rtti3Model)this.model).getProgram();
        TypeDescriptorModel rtti0Model = ((Rtti3Model)this.model).getRtti0Model();
        this.monitor.checkCanceled();
        if (rtti0Model != null) {
            EHDataTypeUtilities.createPlateCommentIfNeeded(program, RttiUtil.getDescriptorTypeNamespace(rtti0Model) + "::", RTTI_3_NAME, null, this.getDataAddress(), this.applyOptions);
            this.monitor.checkCanceled();
            if (this.applyOptions.shouldCreateLabel()) {
                RttiUtil.createSymbolFromDemangledType(program, this.getDataAddress(), rtti0Model, RTTI_3_NAME);
            }
        }
        return true;
    }
}

