/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.nio.json;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.alg.util.Triple;
import org.jgrapht.nio.Attribute;
import org.jgrapht.nio.BaseEventDrivenImporter;
import org.jgrapht.nio.DefaultAttribute;
import org.jgrapht.nio.GraphImporter;
import org.jgrapht.nio.ImportException;
import org.jgrapht.nio.json.JSONEventDrivenImporter;

public class JSONImporter<V, E>
extends BaseEventDrivenImporter<V, E>
implements GraphImporter<V, E> {
    public static final String DEFAULT_VERTEX_ID_KEY = "ID";
    private Function<String, V> vertexFactory;

    @Override
    public void importGraph(Graph<V, E> graph, Reader input) {
        JSONEventDrivenImporter genericImporter = new JSONEventDrivenImporter();
        Consumers consumers = new Consumers(graph);
        genericImporter.addVertexConsumer(consumers.vertexConsumer);
        genericImporter.addVertexAttributeConsumer(consumers.vertexAttributeConsumer);
        genericImporter.addEdgeConsumer(consumers.edgeConsumer);
        genericImporter.addEdgeAttributeConsumer(consumers.edgeAttributeConsumer);
        genericImporter.importInput(input);
    }

    public Function<String, V> getVertexFactory() {
        return this.vertexFactory;
    }

    public void setVertexFactory(Function<String, V> vertexFactory) {
        this.vertexFactory = vertexFactory;
    }

    private class Consumers {
        private Graph<V, E> graph;
        private GraphType graphType;
        private Map<String, V> map;
        private Triple<String, String, Double> lastTriple;
        private E lastEdge;
        public final Consumer<String> vertexConsumer = t -> {
            Object v;
            if (this.map.containsKey(t)) {
                throw new ImportException("Node " + t + " already exists");
            }
            if (JSONImporter.this.vertexFactory != null) {
                v = JSONImporter.this.vertexFactory.apply((String)t);
                this.graph.addVertex(v);
            } else {
                v = this.graph.addVertex();
            }
            this.map.put((String)t, v);
            JSONImporter.this.notifyVertex(v);
            JSONImporter.this.notifyVertexAttribute(v, JSONImporter.DEFAULT_VERTEX_ID_KEY, DefaultAttribute.createAttribute(t));
        };
        public final BiConsumer<Pair<String, String>, Attribute> vertexAttributeConsumer = (p, a) -> {
            String vertex = (String)p.getFirst();
            if (!this.map.containsKey(vertex)) {
                throw new ImportException("Node " + vertex + " does not exist");
            }
            JSONImporter.this.notifyVertexAttribute(this.map.get(vertex), (String)p.getSecond(), a);
        };
        public final Consumer<Triple<String, String, Double>> edgeConsumer = t -> {
            String source = (String)t.getFirst();
            Object from = this.map.get(t.getFirst());
            if (from == null) {
                throw new ImportException("Node " + source + " does not exist");
            }
            String target = (String)t.getSecond();
            Object to = this.map.get(target);
            if (to == null) {
                throw new ImportException("Node " + target + " does not exist");
            }
            Object e = this.graph.addEdge(from, to);
            if (this.graphType.isWeighted() && t.getThird() != null) {
                this.graph.setEdgeWeight(e, ((Double)t.getThird()).doubleValue());
            }
            JSONImporter.this.notifyEdge(e);
            this.lastTriple = t;
            this.lastEdge = e;
        };
        public final BiConsumer<Pair<Triple<String, String, Double>, String>, Attribute> edgeAttributeConsumer = (p, a) -> {
            Triple t = (Triple)p.getFirst();
            if (t == this.lastTriple) {
                JSONImporter.this.notifyEdgeAttribute(this.lastEdge, (String)p.getSecond(), a);
            }
        };

        public Consumers(Graph<V, E> graph) {
            this.graph = graph;
            this.graphType = graph.getType();
            this.map = new HashMap();
        }
    }
}

