/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.datatable.DomainFileContext;
import ghidra.framework.main.projectdata.actions.VersionControlAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class VersionControlUpdateAction
extends VersionControlAction {
    public VersionControlUpdateAction(Plugin plugin) {
        super("Update", plugin.getName(), plugin.getTool());
        ImageIcon icon = ResourceManager.loadImage((String)"images/vcMerge.png");
        this.setPopupMenuData(new MenuData(new String[]{"Update..."}, (Icon)icon, "Repository"));
        this.setToolBarData(new ToolBarData((Icon)icon, "Repository"));
        this.setDescription("Update checked out file with latest version");
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(DomainFileContext context) {
        this.update(context.getSelectedFiles());
    }

    @Override
    public boolean isEnabledForContext(DomainFileContext context) {
        List<DomainFile> providedList = context.getSelectedFiles();
        for (DomainFile domainFile : providedList) {
            if (!domainFile.isVersioned() || domainFile.getLatestVersion() == domainFile.getVersion()) continue;
            return true;
        }
        return false;
    }

    private void update(List<DomainFile> domainFiles) {
        if (!this.checkRepositoryConnected()) {
            return;
        }
        ArrayList<DomainFile> updateList = new ArrayList<DomainFile>();
        for (DomainFile domainFile : domainFiles) {
            if (domainFile == null || !domainFile.canMerge() || !this.canCloseDomainFile(domainFile)) continue;
            updateList.add(domainFile);
        }
        AppInfo.getFrontEndTool().merge(this.tool, updateList, new TaskListener(){

            public void taskCompleted(Task task) {
            }

            public void taskCancelled(Task task) {
            }
        });
    }
}

