/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatable;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.docking.settings.Settings;
import ghidra.framework.main.datatable.DomainFileInfo;
import ghidra.framework.main.datatable.DomainFileType;
import ghidra.framework.main.datatable.ProjectDataColumn;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class ProjectDataTableModel
extends ThreadedTableModel<DomainFileInfo, ProjectData> {
    private ProjectData projectData;
    private boolean editingOn;
    private boolean loadWasCancelled;

    protected ProjectDataTableModel(ServiceProvider serviceProvider) {
        super("Project Data Table", serviceProvider);
    }

    boolean loadWasCancelled() {
        return this.loadWasCancelled;
    }

    protected void doLoad(Accumulator<DomainFileInfo> accumulator, TaskMonitor monitor) throws CancelledException {
        this.loadWasCancelled = false;
        if (this.projectData != null) {
            this.loadWasCancelled = true;
            DomainFolder rootFolder = this.projectData.getRootFolder();
            this.addFiles(accumulator, rootFolder, monitor);
            this.loadWasCancelled = false;
        }
    }

    private void addFiles(Accumulator<DomainFileInfo> accumulator, DomainFolder folder, TaskMonitor monitor) throws CancelledException {
        DomainFolder[] folders;
        DomainFile[] files;
        for (DomainFile domainFile : files = folder.getFiles()) {
            monitor.checkCanceled();
            accumulator.add((Object)new DomainFileInfo(domainFile));
        }
        for (DomainFolder domainFolder : folders = folder.getFolders()) {
            monitor.checkCanceled();
            this.addFiles(accumulator, domainFolder, monitor);
        }
    }

    protected TableColumnDescriptor<DomainFileInfo> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new DomainFileTypeColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new DomainFileNameColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new DomainFilePathColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ModificationDateColumn());
        List<ProjectDataColumn<?>> appSpecificColumns = this.findAppSpecificColumns();
        for (ProjectDataColumn<?> projectDataColumn : appSpecificColumns) {
            if (projectDataColumn.isDefaultColumn()) {
                descriptor.addVisibleColumn(projectDataColumn);
                continue;
            }
            descriptor.addHiddenColumn(projectDataColumn);
        }
        return descriptor;
    }

    private List<ProjectDataColumn<?>> findAppSpecificColumns() {
        List instances = ClassSearcher.getInstances(ProjectDataColumn.class);
        ArrayList columns = new ArrayList();
        for (ProjectDataColumn projectDataColumn : instances) {
            columns.add(projectDataColumn);
        }
        Collections.sort(columns);
        return columns;
    }

    public ProjectData getDataSource() {
        return this.projectData;
    }

    public void refresh() {
        List modelData = this.getModelData();
        for (DomainFileInfo domainFileInfo : modelData) {
            domainFileInfo.refresh();
        }
        super.refresh();
    }

    public void setProjectData(ProjectData projectData) {
        this.projectData = projectData;
        this.reload();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.editingOn) {
            DynamicTableColumn column = this.getColumn(columnIndex);
            return column instanceof DomainFileNameColumn;
        }
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        DomainFileInfo info = (DomainFileInfo)this.getRowObject(rowIndex);
        try {
            String newName = aValue.toString();
            DomainFile domainFile = info.getDomainFile();
            if (!domainFile.getName().equals(newName)) {
                domainFile.setName(newName);
            }
        }
        catch (InvalidNameException | DuplicateFileException e) {
            Msg.showError((Object)((Object)this), null, (String)"Rename Failed", (Object)("Invalid name: " + e.getMessage()));
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Rename Failed", (Object)("There was a problem renaming the file:\n" + e.getMessage()), (Throwable)e);
        }
    }

    public void setEditing(boolean on) {
        this.editingOn = on;
    }

    private class DomainFilePathColumn
    extends AbstractDynamicTableColumn<DomainFileInfo, String, ProjectData> {
        private DomainFilePathColumn() {
        }

        public String getColumnName() {
            return "Path";
        }

        public String getValue(DomainFileInfo info, Settings settings, ProjectData data, ServiceProvider services) throws IllegalArgumentException {
            return info.getPath();
        }

        public int getColumnPreferredWidth() {
            return 200;
        }
    }

    private class ModificationDateColumn
    extends AbstractDynamicTableColumn<DomainFileInfo, Date, ProjectData> {
        private ModificationDateColumn() {
        }

        public String getColumnName() {
            return "Modified";
        }

        public Date getValue(DomainFileInfo info, Settings settings, ProjectData data, ServiceProvider services) throws IllegalArgumentException {
            return info.getModificationDate();
        }

        public int getColumnPreferredWidth() {
            return 200;
        }
    }

    private class DomainFileNameColumn
    extends AbstractDynamicTableColumn<DomainFileInfo, String, ProjectData> {
        private DomainFileNameColumn() {
        }

        public String getColumnName() {
            return "Name";
        }

        public String getValue(DomainFileInfo info, Settings settings, ProjectData data, ServiceProvider services) throws IllegalArgumentException {
            return info.getDisplayName();
        }

        public int getColumnPreferredWidth() {
            return 200;
        }
    }

    private class DomainFileTypeColumn
    extends AbstractDynamicTableColumn<DomainFileInfo, DomainFileType, ProjectData> {
        private DomainFileTypeColumn() {
        }

        public String getColumnName() {
            return "Type";
        }

        public DomainFileType getValue(DomainFileInfo rowObject, Settings settings, ProjectData data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getDomainFileType();
        }

        public int getColumnPreferredWidth() {
            return 25;
        }
    }
}

