/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DockingWindowManager;
import docking.dnd.DragGestureAdapter;
import docking.dnd.DragSrcAdapter;
import docking.dnd.Draggable;
import docking.dnd.DropTgtAdapter;
import docking.dnd.Droppable;
import docking.help.Help;
import docking.help.HelpService;
import docking.util.image.ToolIconURL;
import docking.widgets.EmptyBorderButton;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.GetVersionedObjectTask;
import ghidra.framework.main.MoveImageRunner;
import ghidra.framework.main.ToolButtonTransferable;
import ghidra.framework.main.ZoomImageRunner;
import ghidra.framework.main.ZoomedImagePainter;
import ghidra.framework.main.datatree.DataTreeDragNDropHandler;
import ghidra.framework.main.datatree.VersionInfo;
import ghidra.framework.main.datatree.VersionInfoTransferable;
import ghidra.framework.model.DefaultToolChangeListener;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ToolConnection;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.bean.GGlassPane;
import ghidra.util.bean.GGlassPanePainter;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;

class ToolButton
extends EmptyBorderButton
implements Draggable,
Droppable {
    private static final Runnable DUMMY_CALLBACK_RUNNABLE = () -> {};
    private DropTarget dropTarget;
    private DropTgtAdapter dropTargetAdapter;
    private DataFlavor[] acceptableFlavors;
    private DragSource dragSource;
    private DragGestureAdapter dragGestureAdapter;
    private DragSrcAdapter dragSourceAdapter;
    private int dragAction = 2;
    private FrontEndPlugin plugin;
    private ToolTemplate template;
    private PluginTool associatedRunningTool;
    private DefaultToolChangeListener toolChangeListener;
    private ToolServices toolServices;

    ToolButton(FrontEndPlugin plugin, ToolTemplate template) {
        this(plugin, null, template, template.getIconURL());
        this.setHelpLocation("Run_Tool");
    }

    ToolButton(FrontEndPlugin plugin, PluginTool tool, ToolTemplate template) {
        this(plugin, tool, template, tool.getIconURL());
        this.setHelpLocation("Run_Tool");
    }

    private ToolButton(FrontEndPlugin plugin, PluginTool tool, ToolTemplate template, ToolIconURL iconURL) {
        super((Icon)iconURL.getIcon());
        this.plugin = plugin;
        this.associatedRunningTool = tool;
        this.template = template;
        this.setUpDragDrop();
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.menuShowing()) {
                    return;
                }
                ToolButton.this.activateTool();
            }

            private boolean menuShowing() {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                MenuElement[] selectedPath = manager.getSelectedPath();
                return selectedPath != null && selectedPath.length != 0;
            }
        });
        this.toolServices = plugin.getTool().getToolServices();
        if (this.toolServices == null) {
            throw new AssertException("ToolButton requires ToolServices to run.");
        }
        if (!this.isRunningTool()) {
            this.toolChangeListener = new ToolChangeListener(template);
            this.toolServices.addDefaultToolChangeListener(this.toolChangeListener);
            this.setIcon(this.generateIcon());
        }
    }

    public String getToolTipText(MouseEvent event) {
        if (this.associatedRunningTool != null) {
            if (this.associatedRunningTool instanceof PluginTool) {
                return "<html>" + HTMLUtilities.escapeHTML((String)this.associatedRunningTool.getToolFrame().getTitle());
            }
            return "<html>" + HTMLUtilities.escapeHTML((String)this.associatedRunningTool.getName());
        }
        return "<html>" + HTMLUtilities.escapeHTML((String)this.template.getName());
    }

    public void launchTool(DomainFile domainFile) {
        this.doLaunchTool(new DomainFile[]{domainFile});
    }

    public void dragUnderFeedback(boolean ok, DropTargetDragEvent e) {
    }

    public boolean isDropOk(DropTargetDragEvent e) {
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        try {
            for (DataFlavor element : flavors) {
                Object draggedData;
                if (element.equals(DataTreeDragNDropHandler.localDomainFileFlavor)) {
                    draggedData = e.getTransferable().getTransferData(DataTreeDragNDropHandler.localDomainFileFlavor);
                    return this.containsSupportedDataTypes((List)draggedData);
                }
                if (element.equals(ToolButtonTransferable.localToolButtonFlavor)) {
                    draggedData = e.getTransferable().getTransferData(ToolButtonTransferable.localToolButtonFlavor);
                    ToolButton draggedButton = (ToolButton)((Object)draggedData);
                    if (draggedButton == null) continue;
                    return draggedButton.associatedRunningTool != this.associatedRunningTool;
                }
                if (!element.equals(VersionInfoTransferable.localVersionInfoFlavor)) continue;
                return true;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean containsSupportedDataTypes(List<DomainFile> fileList) {
        for (DomainFile file : fileList) {
            if (this.isSupportedDataType(file)) continue;
            return false;
        }
        return fileList.size() > 0;
    }

    public void undoDragUnderFeedback() {
    }

    public void add(Object obj, DropTargetDropEvent event, DataFlavor f) {
        if (f.equals(DataTreeDragNDropHandler.localDomainFileFlavor)) {
            this.resetButtonAfterDrag((JButton)((Object)this));
            List list = (List)obj;
            DomainFile[] domainFiles = list.toArray(new DomainFile[list.size()]);
            this.openFilesAndOpenToolAsNecessary(domainFiles);
        } else if (f.equals(VersionInfoTransferable.localVersionInfoFlavor)) {
            VersionInfo info = (VersionInfo)obj;
            PluginTool tool = this.plugin.getTool();
            Project project = tool.getProject();
            ProjectData projectData = project.getProjectData();
            DomainFile file = projectData.getFile(info.getDomainFilePath());
            DomainObject versionedObj = this.getVersionedObject(file, info.getVersionNumber());
            if (versionedObj != null) {
                DomainFile domainFile = versionedObj.getDomainFile();
                if (this.isSupportedDataType(domainFile)) {
                    this.resetButtonAfterDrag((JButton)((Object)this));
                    this.openFilesAndOpenToolAsNecessary(new DomainFile[]{domainFile}, () -> versionedObj.release((Object)this));
                } else {
                    versionedObj.release((Object)this);
                }
            }
        } else {
            this.plugin.setToolButtonTransferable(null);
            ToolButton toolButton = (ToolButton)((Object)obj);
            this.resetButtonAfterDrag((JButton)((Object)toolButton));
            this.addFromToolButton(toolButton);
        }
    }

    private void showFilesNotAcceptedMessage(DomainFile[] domainFiles) {
        StringBuffer buffer = new StringBuffer("Tool did not accept files: ");
        for (int i = 0; i < domainFiles.length; ++i) {
            buffer.append(domainFiles[i].getName());
            if (i == domainFiles.length - 1) continue;
            buffer.append(", ");
        }
        Msg.showError((Object)((Object)this), null, (String)"Error", (Object)buffer.toString());
    }

    private void addFromToolButton(ToolButton toolButton) {
        this.plugin.setToolButtonTransferable(null);
        PluginTool tool = null;
        if (this.associatedRunningTool != null && toolButton.associatedRunningTool != null) {
            PluginTool t2 = toolButton.associatedRunningTool;
            SwingUtilities.invokeLater(() -> this.connectTools(this.associatedRunningTool, t2));
            return;
        }
        boolean accepted = false;
        if (toolButton.associatedRunningTool == null) {
            tool = this.plugin.getActiveWorkspace().runTool(toolButton.template);
            accepted = tool.acceptDomainFiles(this.associatedRunningTool.getDomainFiles());
            PluginTool t = tool;
            SwingUtilities.invokeLater(() -> this.connectTools(t, this.associatedRunningTool));
        } else {
            tool = this.plugin.getActiveWorkspace().runTool(this.template);
            accepted = tool.acceptDomainFiles(toolButton.associatedRunningTool.getDomainFiles());
            PluginTool t = tool;
            PluginTool t2 = toolButton.associatedRunningTool;
            SwingUtilities.invokeLater(() -> this.connectTools(t, t2));
        }
        if (!accepted) {
            Msg.error((Object)((Object)this), (Object)(tool.getName() + " did not accept data."));
        }
    }

    private void connectTools(PluginTool t1, PluginTool t2) {
        ToolManager tm = this.plugin.getActiveProject().getToolManager();
        ToolConnection tc = tm.getConnection(t1, t2);
        this.connectAll(tc);
        tc = tm.getConnection(t2, t1);
        this.connectAll(tc);
    }

    private void connectAll(ToolConnection tc) {
        String[] events;
        for (String element : events = tc.getEvents()) {
            tc.connect(element);
        }
        this.plugin.updateToolConnectionDialog();
        Msg.info((Object)((Object)this), (Object)("Connected all events for " + tc.getProducer().getName() + " to " + tc.getConsumer().getName()));
    }

    private boolean isSupportedDataType(DomainFile file) {
        Class<?>[] classes;
        if (file == null) {
            return false;
        }
        Class<? extends DomainObject> c = file.getDomainObjectClass();
        for (Class<? extends DomainObject> clazz : classes = this.associatedRunningTool != null ? this.associatedRunningTool.getSupportedDataTypes() : this.template.getSupportedDataTypes()) {
            if (!clazz.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }

    private DomainObject getVersionedObject(DomainFile file, int versionNumber) {
        GetVersionedObjectTask task = new GetVersionedObjectTask((Object)this, file, versionNumber);
        this.plugin.getTool().execute(task, 250);
        return task.getVersionedObject();
    }

    private void resetButtonAfterDrag(JButton button) {
        ButtonModel buttonModel = button.getModel();
        buttonModel.setArmed(false);
        buttonModel.setPressed(false);
        buttonModel.setRollover(false);
        this.clearBorder();
    }

    public void dragCanceled(DragSourceDropEvent event) {
        this.plugin.setToolButtonTransferable(null);
        this.resetButtonAfterDrag((JButton)((Object)this));
        Container parent = this.getParent();
        if (parent == null) {
            return;
        }
        Point point = event.getLocation();
        if (point == null) {
            return;
        }
        SwingUtilities.convertPointFromScreen(point, parent);
        Component componentUnderMouse = SwingUtilities.getDeepestComponentAt(parent, point.x, point.y);
        if (componentUnderMouse == this) {
            this.handleMouseReleased();
        }
    }

    public boolean isStartDragOk(DragGestureEvent e) {
        this.plugin.setToolButtonTransferable(new ToolButtonTransferable(this));
        return true;
    }

    public DragSourceListener getDragSourceListener() {
        return this.dragSourceAdapter;
    }

    public Transferable getTransferable(Point p) {
        return this.plugin.getToolButtonTransferable();
    }

    public void move() {
        this.resetButtonAfterDrag((JButton)((Object)this));
    }

    public int getDragAction() {
        return this.dragAction;
    }

    void setToolTemplate(ToolTemplate template, Icon icon) {
        this.template = template;
        this.setIcon(icon);
    }

    ToolTemplate getToolTemplate() {
        return this.template;
    }

    boolean isRunningTool() {
        return this.associatedRunningTool != null;
    }

    void closeTool() {
        this.associatedRunningTool.close();
    }

    PluginTool getRunningTool() {
        return this.associatedRunningTool;
    }

    void dispose() {
        this.toolServices.removeDefaultToolChangeListener(this.toolChangeListener);
        this.plugin = null;
        this.template = null;
        this.associatedRunningTool = null;
        this.dropTarget = null;
        this.dropTargetAdapter = null;
        this.acceptableFlavors = null;
        this.dragSource = null;
        this.dragGestureAdapter = null;
    }

    private void activateTool() {
        if (this.associatedRunningTool == null) {
            this.doLaunchTool(null);
        } else {
            this.associatedRunningTool.toFront();
        }
    }

    private void doLaunchTool(DomainFile[] domainFiles) {
        this.openFilesAndOpenToolAsNecessary(domainFiles);
    }

    private void openFilesAndOpenToolAsNecessary(DomainFile[] domainFiles) {
        this.openFilesAndOpenToolAsNecessary(domainFiles, DUMMY_CALLBACK_RUNNABLE);
    }

    private void openFilesAndOpenToolAsNecessary(DomainFile[] domainFiles, Runnable finishedCallback) {
        if (this.associatedRunningTool != null) {
            this.openDomainFiles(this.associatedRunningTool, domainFiles);
            return;
        }
        DockingWindowManager manager = DockingWindowManager.getInstance((Component)((Object)this));
        JFrame toolFrame = manager.getRootFrame();
        Component glassPane = toolFrame.getGlassPane();
        if (!(glassPane instanceof GGlassPane)) {
            Msg.debug((Object)((Object)this), (Object)"Found root frame without a GhidraGlassPane registered!");
            PluginTool newTool = this.plugin.getActiveWorkspace().runTool(this.template);
            this.openDomainFiles(newTool, domainFiles);
            finishedCallback.run();
            return;
        }
        this.launchToolWithAnimationAndOpenFiles(domainFiles, toolFrame, (GGlassPane)glassPane, finishedCallback);
    }

    private void launchToolWithAnimationAndOpenFiles(final DomainFile[] domainFiles, JFrame toolFrame, final GGlassPane toolGlassPane, final Runnable finishedCallback) {
        Icon icon = this.getIcon();
        Point buttonLocation = this.getLocation();
        Insets insets = this.getInsets();
        buttonLocation.x += insets.left;
        buttonLocation.y += insets.top;
        buttonLocation = SwingUtilities.convertPoint(this.getParent(), buttonLocation, toolFrame.getRootPane());
        Rectangle startBounds = new Rectangle(buttonLocation, new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        Dimension frameSize = toolFrame.getSize();
        Rectangle endBounds = new Rectangle(new Point(0, 0), frameSize);
        Image image = ZoomedImagePainter.createIconImage(icon);
        final ZoomedImagePainter painter = new ZoomedImagePainter(startBounds, image);
        ZoomImageRunner zoomRunner = new ZoomImageRunner(toolGlassPane, painter, icon);
        MoveImageRunner moveRunner = new MoveImageRunner(toolGlassPane, startBounds, endBounds, painter);
        TimingTargetAdapter finishedTarget = new TimingTargetAdapter(){

            public void end() {
                toolGlassPane.removePainter((GGlassPanePainter)painter);
                try {
                    toolGlassPane.paintImmediately(toolGlassPane.getBounds());
                    PluginTool newTool = ToolButton.this.plugin.getActiveWorkspace().runTool(ToolButton.this.template);
                    ToolButton.this.openDomainFiles(newTool, domainFiles);
                }
                finally {
                    GGlassPane.setAllGlassPanesBusy((boolean)false);
                    finishedCallback.run();
                }
            }
        };
        zoomRunner.addTimingTargetListener((TimingTarget)finishedTarget);
        GGlassPane.setAllGlassPanesBusy((boolean)true);
        moveRunner.run();
        zoomRunner.run();
    }

    private void openDomainFiles(PluginTool tool, DomainFile[] domainFiles) {
        if (domainFiles == null) {
            return;
        }
        boolean accepted = tool.acceptDomainFiles(domainFiles);
        if (!accepted) {
            this.showFilesNotAcceptedMessage(domainFiles);
        }
    }

    private void setUpDragDrop() {
        this.acceptableFlavors = new DataFlavor[]{DataTreeDragNDropHandler.localDomainFileFlavor, ToolButtonTransferable.localToolButtonFlavor, VersionInfoTransferable.localVersionInfoFlavor};
        this.dropTargetAdapter = new ToolButtonDropTgtAdapter(3, this.acceptableFlavors);
        this.dropTarget = new DropTarget((Component)((Object)this), 3, (DropTargetListener)this.dropTargetAdapter, true);
        this.dropTarget.setActive(true);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragGestureAdapter = new DragGestureAdapter((Draggable)this);
        this.dragSourceAdapter = new DragSrcAdapter((Draggable)this);
        this.dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), this.dragAction, (DragGestureListener)this.dragGestureAdapter);
    }

    private Icon generateIcon() {
        ImageIcon icon = this.template.getIcon();
        if (this.isRunningTool()) {
            return icon;
        }
        return icon;
    }

    private void setHelpLocation(String anchorTag) {
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this, new HelpLocation("Tool", anchorTag));
    }

    private void handleMouseReleased() {
        this.activateTool();
    }

    private class ToolButtonDropTgtAdapter
    extends DropTgtAdapter {
        private boolean draggingOverValidDropTarget;

        public ToolButtonDropTgtAdapter(int acceptableDropActions, DataFlavor[] acceptableDropFlavors) {
            super((Droppable)ToolButton.this, acceptableDropActions, acceptableDropFlavors);
            this.draggingOverValidDropTarget = false;
        }

        public void dragEnter(DropTargetDragEvent e) {
            super.dragEnter(e);
            if (super.isDropOk(e)) {
                ToolButton.this.setBorder(EmptyBorderButton.RAISED_BUTTON_BORDER);
                this.draggingOverValidDropTarget = true;
            }
        }

        public void dragExit(DropTargetEvent e) {
            super.dragExit(e);
            if (this.draggingOverValidDropTarget) {
                ToolButton.this.clearBorder();
                this.draggingOverValidDropTarget = false;
            }
        }
    }

    private class ToolChangeListener
    implements DefaultToolChangeListener {
        private final ToolTemplate toolTemplate;

        public ToolChangeListener(ToolTemplate toolTemplate) {
            this.toolTemplate = toolTemplate;
        }

        @Override
        public void defaultToolChanged(String oldName, String newName) {
            String myName = this.toolTemplate.getName();
            if (myName.equals(oldName) || myName.equals(newName)) {
                ToolButton.this.setIcon(ToolButton.this.generateIcon());
            }
        }
    }
}

