/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import db.Record;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.framework.data.DomainObjectAdapterDB;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

class MetadataManager {
    private static final String TABLE_NAME = "Metadata";
    private static final Schema SCHEMA = new Schema(0, "ID", new Class[]{StringField.class, StringField.class}, new String[]{"Key", "Value"});

    MetadataManager() {
    }

    static void loadData(DomainObjectAdapterDB dobj, Map<String, String> metadata) throws IOException {
        metadata.clear();
        Table table = dobj.getDBHandle().getTable(TABLE_NAME);
        if (table != null) {
            for (Record record : table) {
                String key = record.getString(0);
                String value = record.getString(1);
                metadata.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveData(DomainObjectAdapterDB dobj, Map<String, String> metadata) throws IOException {
        int transactionID = dobj.startTransaction("Update Metadata");
        try {
            Table table = dobj.getDBHandle().getTable(TABLE_NAME);
            if (table == null) {
                table = dobj.getDBHandle().createTable(TABLE_NAME, SCHEMA);
            } else {
                table.deleteAll();
            }
            Iterator<String> keyIterator = metadata.keySet().iterator();
            long id = 1L;
            while (keyIterator.hasNext()) {
                String key = keyIterator.next();
                String value = metadata.get(key);
                Record record = SCHEMA.createRecord(id++);
                record.setString(0, key);
                record.setString(1, value);
                table.putRecord(record);
            }
        }
        finally {
            dobj.endTransaction(transactionID, true);
        }
    }
}

