/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.NeighborCache;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jgrapht.util.SupplierUtil;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.EiglspergerSteps;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.EiglspergerStepsBackward;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.EiglspergerStepsForward;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.HorizontalCoordinateAssignment;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.SyntheticLV;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.Synthetics;
import org.jungrapht.visualization.layout.algorithms.sugiyama.ArticulatedEdge;
import org.jungrapht.visualization.layout.algorithms.sugiyama.GraphLayers;
import org.jungrapht.visualization.layout.algorithms.sugiyama.GreedyCycleRemoval;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Layering;
import org.jungrapht.visualization.layout.algorithms.sugiyama.TransformedGraphSupplier;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Unaligned;
import org.jungrapht.visualization.layout.algorithms.sugiyama.VertexMetadata;
import org.jungrapht.visualization.layout.algorithms.util.Attributed;
import org.jungrapht.visualization.layout.algorithms.util.LayeredRunnable;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EiglspergerRunnable<V, E>
implements LayeredRunnable<E> {
    private static final Logger log = LoggerFactory.getLogger(EiglspergerRunnable.class);
    protected final LayoutModel<V> layoutModel;
    protected Function<V, Rectangle> vertexShapeFunction;
    protected Graph<V, E> graph;
    protected Graph<LV<V>, LE<V, E>> svGraph;
    protected NeighborCache<LV<V>, LE<V, E>> neighborCache;
    protected Predicate<V> vertexPredicate;
    protected Predicate<E> edgePredicate;
    protected boolean straightenEdges;
    protected boolean postStraighten;
    protected boolean transpose;
    protected int maxLevelCross;
    protected boolean minimizeEdgeLength;
    protected Layering layering;
    protected Map<LV<V>, VertexMetadata<V>> vertexMetadataMap = new HashMap<LV<V>, VertexMetadata<V>>();
    protected Map<E, List<Point>> edgePointMap = new HashMap<E, List<Point>>();
    protected EiglspergerStepsForward<V, E> stepsForward;
    protected EiglspergerStepsBackward<V, E> stepsBackward;
    protected EiglspergerSteps<V, E> steps = null;
    protected boolean multiComponent;
    protected boolean cancelled;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    protected EiglspergerRunnable(Builder<V, E, ?, ?> builder) {
        this(builder.layoutModel, builder.vertexShapeFunction, builder.straightenEdges, builder.postStraighten, builder.transpose, builder.maxLevelCross, builder.minimizeEdgeLength, builder.layering, builder.multiComponent);
    }

    protected EiglspergerRunnable(LayoutModel<V> layoutModel, Function<V, Rectangle> vertexShapeFunction, boolean straightenEdges, boolean postStraighten, boolean transpose, int maxLevelCross, boolean minimizeEdgeLength, Layering layering, boolean multiComponent) {
        this.layoutModel = layoutModel;
        this.vertexShapeFunction = vertexShapeFunction;
        this.straightenEdges = straightenEdges;
        this.postStraighten = postStraighten;
        this.transpose = transpose;
        this.maxLevelCross = maxLevelCross;
        this.minimizeEdgeLength = minimizeEdgeLength;
        if (layering == null) {
            layering = Layering.LONGEST_PATH;
        }
        this.layering = layering;
        this.multiComponent = multiComponent;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void run() {
        int n;
        int n2;
        List<List<LV<V>>> layers;
        this.graph = this.layoutModel.getGraph();
        if (this.graph.vertexSet().isEmpty()) {
            return;
        }
        if (this.graph.vertexSet().size() == 1) {
            Object v2 = this.graph.vertexSet().stream().findFirst().get();
            this.layoutModel.setSize(50, this.layoutModel.getHeight());
            this.layoutModel.set(v2, this.layoutModel.getWidth() / 2, this.layoutModel.getHeight() / 2);
            return;
        }
        long startTime = System.currentTimeMillis();
        TransformedGraphSupplier<V, E> transformedGraphSupplier = new TransformedGraphSupplier<V, E>(this.graph);
        this.svGraph = transformedGraphSupplier.get();
        this.neighborCache = new NeighborCache(this.svGraph);
        long transformTime = System.currentTimeMillis();
        log.trace("transform Graph took {}", (Object)(transformTime - startTime));
        GreedyCycleRemoval<LV<V>, LE<V, E>> greedyCycleRemoval = new GreedyCycleRemoval<LV<V>, LE<V, E>>(this.svGraph);
        Collection<LE<V, E>> feedbackArcs = greedyCycleRemoval.getFeedbackArcs();
        for (LE<V, E> se : feedbackArcs) {
            this.svGraph.removeEdge(se);
            LE newEdge = LE.of(se.getEdge(), se.getTarget(), se.getSource());
            this.svGraph.addEdge(newEdge.getSource(), newEdge.getTarget(), newEdge);
        }
        long cycles = System.currentTimeMillis();
        log.trace("remove cycles took {}", (Object)(cycles - transformTime));
        if (this.cancelled || Thread.currentThread().isInterrupted()) {
            log.info("interrupted before layering, cancelled: {}", (Object)this.cancelled);
            return;
        }
        switch (this.layering) {
            case LONGEST_PATH: {
                layers = GraphLayers.longestPath(this.svGraph, this.neighborCache);
                break;
            }
            case COFFMAN_GRAHAM: {
                layers = GraphLayers.coffmanGraham(this.svGraph, this.neighborCache, 0);
                break;
            }
            case NETWORK_SIMPLEX: {
                layers = GraphLayers.networkSimplex(this.svGraph);
                break;
            }
            default: {
                layers = GraphLayers.assign(this.svGraph);
            }
        }
        if (this.minimizeEdgeLength) {
            GraphLayers.minimizeEdgeLength(this.svGraph, layers);
        }
        long assignLayersTime = System.currentTimeMillis();
        log.trace("assign layers took {} ", (Object)(assignLayersTime - cycles));
        if (log.isTraceEnabled()) {
            GraphLayers.checkLayers(layers);
        }
        Synthetics synthetics = new Synthetics(this.svGraph);
        ArrayList edges = new ArrayList(this.svGraph.edgeSet());
        LV<V>[][] layersArray = synthetics.createVirtualVerticesAndEdges(edges, layers);
        if (log.isTraceEnabled()) {
            GraphLayers.checkLayers(layersArray);
        }
        long syntheticsTime = System.currentTimeMillis();
        log.trace("synthetics took {}", (Object)(syntheticsTime - assignLayersTime));
        if (this.svGraph.edgeSet().size() > 200) {
            this.maxLevelCross = 2;
        }
        this.stepsForward = new EiglspergerStepsForward<V, E>(this.svGraph, this.neighborCache, layersArray, this.transpose);
        this.stepsBackward = new EiglspergerStepsBackward<V, E>(this.svGraph, this.neighborCache, layersArray, this.transpose);
        int bestCrossCount = Integer.MAX_VALUE;
        Graph<LV<V>, Integer> bestCompactionGraph = null;
        for (int i = 0; i < this.maxLevelCross; ++i) {
            Graph compactionGraph;
            int sweepCrossCount;
            if (this.cancelled || Thread.currentThread().isInterrupted()) {
                log.info("interrupted in level cross, cancelled: {}", (Object)this.cancelled);
                return;
            }
            if (i % 2 == 0) {
                sweepCrossCount = this.stepsForward.sweep(layersArray);
                compactionGraph = this.stepsForward.compactionGraph;
                if (sweepCrossCount < bestCrossCount) {
                    bestCrossCount = sweepCrossCount;
                    this.vertexMetadataMap = this.save(layersArray);
                    bestCompactionGraph = this.copy(compactionGraph);
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace("best:{}", layersArray);
                continue;
            }
            sweepCrossCount = this.stepsBackward.sweep(layersArray);
            compactionGraph = this.stepsBackward.compactionGraph;
            if (sweepCrossCount < bestCrossCount) {
                bestCrossCount = sweepCrossCount;
                this.vertexMetadataMap = this.save(layersArray);
                bestCompactionGraph = this.copy(compactionGraph);
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("best:{}", layersArray);
        }
        log.trace("bestCrossCount: {}", (Object)bestCrossCount);
        this.restore(layersArray, this.vertexMetadataMap);
        Arrays.stream(layersArray).forEach(layer -> Arrays.sort(layer, Comparator.comparingInt(LV::getIndex)));
        Rectangle avgVertexBounds = EiglspergerRunnable.maxVertexBounds(layersArray, this.vertexShapeFunction);
        int horizontalOffset = (int)Math.max(avgVertexBounds.width, (double)Integer.getInteger("jungrapht.mincross.horizontalOffset", 50).intValue());
        int verticalOffset = (int)Math.max(avgVertexBounds.height, (double)Integer.getInteger("jungrapht.mincross.verticalOffset", 50).intValue());
        GraphLayers.checkLayers(layersArray);
        HashMap<LV<Point>, Point> vertexPointMap = new HashMap<LV<Point>, Point>();
        for (LV<V>[] value : layersArray) {
            for (int j = 0; j < value.length; ++j) {
                value[j].setIndex(j);
            }
        }
        if (this.cancelled || Thread.currentThread().isInterrupted()) {
            log.info("interrupted before compaction, cancelled: {}", (Object)this.cancelled);
            return;
        }
        if (this.straightenEdges) {
            HorizontalCoordinateAssignment<V, E> horizontalCoordinateAssignment = new HorizontalCoordinateAssignment<V, E>(layersArray, this.svGraph, bestCompactionGraph, new HashSet(), horizontalOffset, verticalOffset);
            horizontalCoordinateAssignment.horizontalCoordinateAssignment();
            GraphLayers.checkLayers(layersArray);
            for (LV<V>[] lvs : layersArray) {
                for (LV<V>[] lVArray : lvs) {
                    vertexPointMap.put((LV<Point>)lVArray, lVArray.getPoint());
                }
            }
        } else {
            Unaligned.centerPoints(layersArray, this.vertexShapeFunction, horizontalOffset, verticalOffset, vertexPointMap);
        }
        HashMap<Integer, Integer> rowWidthMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> rowMaxHeightMap = new HashMap<Integer, Integer>();
        int layerIndex = 0;
        int totalHeight = 0;
        int totalWidth = 0;
        for (LV<V>[] lVArray : layersArray) {
            int width = horizontalOffset;
            int maxHeight = 0;
            for (LV<V>[] v3 : lVArray) {
                if (!(v3 instanceof SyntheticLV)) {
                    Rectangle bounds = this.vertexShapeFunction.apply(v3.getVertex());
                    width = (int)((double)width + (bounds.width + (double)horizontalOffset));
                    maxHeight = Math.max(maxHeight, (int)bounds.height);
                    continue;
                }
                width += horizontalOffset;
            }
            rowWidthMap.put(layerIndex, width);
            rowMaxHeightMap.put(layerIndex, maxHeight);
            ++layerIndex;
        }
        int widestRowWidth = rowWidthMap.values().stream().mapToInt(v -> v).max().orElse(0);
        int x = horizontalOffset;
        int y = verticalOffset;
        layerIndex = 0;
        if (log.isTraceEnabled()) {
            log.trace("layerMaxHeights {}", rowMaxHeightMap);
        }
        for (LV<V>[] lVArray : layersArray) {
            int previousVertexWidth = 0;
            x += (widestRowWidth - (Integer)rowWidthMap.get(layerIndex)) / 2;
            y += (Integer)rowMaxHeightMap.get(layerIndex) / 2;
            if (layerIndex > 0) {
                y += (Integer)rowMaxHeightMap.get(layerIndex - 1) / 2;
            }
            int rowWidth = 0;
            for (LV<V> EiglspergerVertex : lVArray) {
                int vertexWidth = 0;
                if (!(EiglspergerVertex instanceof SyntheticLV)) {
                    vertexWidth = (int)this.vertexShapeFunction.apply(EiglspergerVertex.getVertex()).width;
                }
                rowWidth = (x += previousVertexWidth / 2 + vertexWidth / 2 + horizontalOffset) + vertexWidth / 2;
                log.trace("layerIndex {} y is {}", (Object)layerIndex, (Object)y);
                previousVertexWidth = vertexWidth;
            }
            totalWidth = Math.max(totalWidth, rowWidth);
            x = horizontalOffset;
            totalHeight = (y += verticalOffset) + (Integer)rowMaxHeightMap.get(layerIndex) / 2;
            ++layerIndex;
        }
        int n3 = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = -1;
        int n4 = -1;
        for (Point p : vertexPointMap.values()) {
            n2 = Math.min((int)p.x, n2);
            maxX = Math.max((int)p.x, maxX);
            minY = Math.min((int)p.y, minY);
            n = Math.max((int)p.y, n);
        }
        void var35_53 = n + verticalOffset;
        int pointRangeWidth = (maxX += horizontalOffset) - n2;
        int pointRangeHeight = var35_53 - minY;
        int offsetX = 0;
        int offsetY = 0;
        if (n2 < 0) {
            offsetX += -n2 + horizontalOffset;
        }
        if (minY < 0) {
            offsetY += -minY + verticalOffset;
        }
        pointRangeWidth = (int)((double)pointRangeWidth * 1.1);
        pointRangeHeight = (int)((double)pointRangeHeight * 1.1);
        int maxDimension = Math.max(totalWidth, totalHeight);
        this.layoutModel.setSize(this.multiComponent ? totalWidth : Math.max(maxDimension, this.layoutModel.getWidth()), Math.max(maxDimension, this.layoutModel.getHeight()));
        long pointsSetTime = System.currentTimeMillis();
        double scalex = (double)this.layoutModel.getWidth() / (double)pointRangeWidth;
        double scaley = (double)this.layoutModel.getHeight() / (double)pointRangeHeight;
        for (Map.Entry entry : vertexPointMap.entrySet()) {
            Point p = (Point)entry.getValue();
            Point q = Point.of(((double)offsetX + p.x) * scalex, ((double)offsetY + p.y) * scaley);
            entry.setValue(q);
        }
        this.svGraph.vertexSet().forEach(v -> v.setPoint((Point)vertexPointMap.get(v)));
        if (this.postStraighten) {
            synthetics.alignArticulatedEdges();
        }
        List<ArticulatedEdge<V, E>> articulatedEdges = synthetics.makeArticulatedEdges();
        HashSet feedbackEdges = new HashSet();
        feedbackArcs.forEach(a -> feedbackEdges.add(a.getEdge()));
        articulatedEdges.stream().filter(ae -> feedbackEdges.contains(ae.getEdge())).forEach(ae -> {
            this.svGraph.removeEdge(ae);
            ArticulatedEdge reversed = ae.reversed();
            this.svGraph.addEdge(reversed.getSource(), reversed.getTarget(), reversed);
        });
        for (ArticulatedEdge ae2 : articulatedEdges) {
            ArrayList<Point> points = new ArrayList<Point>();
            if (feedbackEdges.contains(ae2.getEdge())) {
                points.add(ae2.getTarget().getPoint());
                points.addAll(ae2.reversed().getIntermediatePoints());
                points.add(ae2.getSource().getPoint());
            } else {
                points.add(ae2.getSource().getPoint());
                points.addAll(ae2.getIntermediatePoints());
                points.add(ae2.getTarget().getPoint());
            }
            this.edgePointMap.put(ae2.edge, points);
        }
        long articulatedEdgeTime = System.currentTimeMillis();
        log.trace("articulated edges took {}", (Object)(articulatedEdgeTime - pointsSetTime));
        if (this.cancelled) {
            log.info("interrupted before setting layoutModel from svGraph, cancelled: {}", (Object)this.cancelled);
            return;
        }
        this.svGraph.vertexSet().forEach(v -> this.layoutModel.set(v.getVertex(), v.getPoint()));
        for (LV v4 : this.svGraph.vertexSet()) {
            if (!(v4.getVertex() instanceof Attributed)) continue;
            Attributed va = (Attributed)v4.getVertex();
            va.set("pos", "" + v4.getPos());
            va.set("idx", "" + v4.getIndex());
            va.set("rank", "" + v4.getRank());
        }
    }

    @Override
    public Map<E, List<Point>> getEdgePointMap() {
        return this.edgePointMap;
    }

    protected LV<V>[][] copy(LV<V>[][] in) {
        LV[][] copy = new LV[in.length][];
        for (int i = 0; i < in.length; ++i) {
            copy[i] = new LV[in[i].length];
            for (int j = 0; j < in[i].length; ++j) {
                copy[i][j] = in[i][j].copy();
            }
        }
        return copy;
    }

    protected Map<LV<V>, VertexMetadata<V>> save(LV<V>[][] in) {
        HashMap<LV<VertexMetadata>, VertexMetadata<VertexMetadata>> vertexMetadataMap = new HashMap<LV<VertexMetadata>, VertexMetadata<VertexMetadata>>();
        VertexMetadata[][] saved = new VertexMetadata[in.length][];
        for (int i = 0; i < in.length; ++i) {
            saved[i] = new VertexMetadata[in[i].length];
            for (int j = 0; j < in[i].length; ++j) {
                saved[i][j] = VertexMetadata.of(in[i][j]);
                vertexMetadataMap.put(in[i][j], saved[i][j]);
            }
        }
        return vertexMetadataMap;
    }

    protected LV<V>[][] restore(LV<V>[][] layers, Map<LV<V>, VertexMetadata<V>> vertexMetadataMap) {
        for (int i = 0; i < layers.length; ++i) {
            for (int j = 0; j < layers[i].length; ++j) {
                VertexMetadata<V> vertexMetadata = vertexMetadataMap.get(layers[i][j]);
                vertexMetadata.applyTo(layers[i][j]);
            }
        }
        return layers;
    }

    private static <V> Rectangle maxVertexBounds(LV<V>[][] layers, Function<V, Rectangle> vertexShapeFunction) {
        Rectangle maxVertexBounds = Rectangle.IDENTITY;
        LV<V>[][] lVArray = layers;
        int n = lVArray.length;
        for (int i = 0; i < n; ++i) {
            LV<V>[] layer;
            for (LV<V> vlv : layer = lVArray[i]) {
                if (vlv instanceof SyntheticLV) continue;
                Rectangle bounds = vertexShapeFunction.apply(vlv.getVertex());
                int width = (int)Math.max(bounds.width, maxVertexBounds.width);
                int height = (int)Math.max(bounds.height, maxVertexBounds.height);
                maxVertexBounds = Rectangle.of(0, 0, width, height);
            }
        }
        return maxVertexBounds;
    }

    private static <V> Rectangle avgVertexBounds(LV<V>[][] layers, Function<V, Rectangle> vertexShapeFunction) {
        LongSummaryStatistics w = new LongSummaryStatistics();
        LongSummaryStatistics h = new LongSummaryStatistics();
        LV<V>[][] lVArray = layers;
        int n = lVArray.length;
        for (int i = 0; i < n; ++i) {
            LV<V>[] layer;
            for (LV<V> vlv : layer = lVArray[i]) {
                if (vlv instanceof SyntheticLV) continue;
                Rectangle bounds = vertexShapeFunction.apply(vlv.getVertex());
                w.accept((int)bounds.width);
                h.accept((int)bounds.height);
            }
        }
        return Rectangle.of((int)w.getAverage(), (int)h.getAverage());
    }

    private Graph<LV<V>, Integer> copy(Graph<LV<V>, Integer> graph) {
        Graph out = GraphTypeBuilder.forGraph(graph).edgeSupplier(SupplierUtil.createIntegerSupplier()).buildGraph();
        graph.vertexSet().forEach(arg_0 -> ((Graph)out).addVertex(arg_0));
        graph.edgeSet().forEach(e -> out.addEdge((Object)((LV)graph.getEdgeSource(e)), (Object)((LV)graph.getEdgeTarget(e))));
        return out;
    }

    private void updatePositions(LV<V>[][] layersArray, Graph<LV<V>, Integer> compactionGraph) {
        if (log.isTraceEnabled()) {
            log.trace("vertices of compactionGraph:{}", (Object)compactionGraph.vertexSet());
            log.trace("edges of compactionGraph:{}", (Object)compactionGraph.edgeSet());
        }
        LV<V>[][] lVArray = layersArray;
        int n = lVArray.length;
        for (int i = 0; i < n; ++i) {
            LV<V>[] layer;
            for (LV<V> v : layer = lVArray[i]) {
                v.setPos(this.distanceToRoot(compactionGraph, v));
            }
        }
    }

    int distanceToRoot(Graph<LV<V>, Integer> compactionGraph, LV<V> v) {
        int distance = 0;
        Set preds = this.neighborCache.predecessorsOf(v);
        while (!preds.isEmpty()) {
            ++distance;
            LV pred = (LV)preds.stream().findFirst().get();
            preds = this.neighborCache.predecessorsOf((Object)pred);
        }
        return distance;
    }

    public static class Builder<V, E, T extends EiglspergerRunnable<V, E>, B extends Builder<V, E, T, B>> {
        protected LayoutModel<V> layoutModel;
        protected Function<V, Rectangle> vertexShapeFunction;
        protected boolean straightenEdges;
        protected boolean postStraighten;
        protected boolean transpose;
        protected int maxLevelCross;
        protected boolean minimizeEdgeLength = false;
        protected Layering layering = Layering.LONGEST_PATH;
        protected boolean multiComponent;

        protected B self() {
            return (B)this;
        }

        public B layoutModel(LayoutModel<V> layoutModel) {
            this.layoutModel = layoutModel;
            return this.self();
        }

        public B vertexShapeFunction(Function<V, Rectangle> vertexShapeFunction) {
            this.vertexShapeFunction = vertexShapeFunction;
            return this.self();
        }

        public B straightenEdges(boolean straightenEdges) {
            this.straightenEdges = straightenEdges;
            return this.self();
        }

        public B postStraighten(boolean postStraighten) {
            this.postStraighten = postStraighten;
            return this.self();
        }

        public B transpose(boolean transpose) {
            this.transpose = transpose;
            return this.self();
        }

        public B maxLevelCross(int maxLevelCross) {
            this.maxLevelCross = maxLevelCross;
            return this.self();
        }

        public B minimzeEdgeLength(boolean minimizeEdgeLength) {
            this.minimizeEdgeLength = minimizeEdgeLength;
            return this.self();
        }

        public B layering(Layering layering) {
            this.layering = layering;
            return this.self();
        }

        public B multiComponent(boolean multiComponent) {
            this.multiComponent = multiComponent;
            return this.self();
        }

        public T build() {
            return (T)new EiglspergerRunnable(this);
        }
    }
}

