/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TreeLayout;
import org.jungrapht.visualization.layout.algorithms.TreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.model.Dimension;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.layout.util.Caching;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiRowTreeLayoutAlgorithm<V>
extends TreeLayoutAlgorithm<V>
implements LayoutAlgorithm<V> {
    private static final Logger log = LoggerFactory.getLogger(MultiRowTreeLayoutAlgorithm.class);
    protected int rowCount = 1;

    public static <V> Builder<V, ?, ?> builder() {
        return new Builder();
    }

    public MultiRowTreeLayoutAlgorithm() {
        this(MultiRowTreeLayoutAlgorithm.builder());
    }

    protected MultiRowTreeLayoutAlgorithm(Builder<V, ?, ?> builder) {
        super(builder);
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        super.visit(layoutModel);
    }

    @Override
    protected Set<V> buildTree(LayoutModel<V> layoutModel) {
        this.rowCount = 1;
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            return Collections.emptySet();
        }
        if (layoutModel instanceof Caching) {
            ((Caching)((Object)layoutModel)).clear();
        }
        this.defaultRootPredicate = v -> graph.incomingEdgesOf(v).isEmpty() || TreeLayout.isIsolatedVertex(graph, v);
        if (this.vertexBoundsFunction != null) {
            Dimension averageVertexSize = this.computeAverageVertexDimension(graph, this.vertexBoundsFunction);
            this.horizontalVertexSpacing = averageVertexSize.width * 2;
            this.verticalVertexSpacing = averageVertexSize.height * 2;
        }
        this.rootPredicate = this.rootPredicate == null ? this.defaultRootPredicate : this.rootPredicate.or(this.defaultRootPredicate);
        Set roots = graph.vertexSet().stream().filter(this.rootPredicate).sorted(Comparator.comparingInt(v -> TreeLayout.vertexIsolationScore(graph, v))).collect(Collectors.toCollection(LinkedHashSet::new));
        if (roots.size() == 0) {
            Graph tree = TreeLayoutAlgorithm.getSpanningTree(graph);
            layoutModel.setGraph(tree);
            Set<V> treeRoots = this.buildTree(layoutModel);
            return treeRoots;
        }
        int overallWidth = this.calculateWidth(layoutModel, roots, (Set<V>)new HashSet());
        int overallHeight = this.calculateOverallHeight(layoutModel, roots, overallWidth);
        int cursor = this.horizontalVertexSpacing;
        int y = 0;
        HashSet rootsInRow = new HashSet();
        HashSet seen = new HashSet();
        HashSet seenForHeight = new HashSet();
        for (Object vertex : roots) {
            if (seen.contains(vertex)) continue;
            int w = (int)((Rectangle)this.baseBounds.get(vertex)).width;
            cursor += w;
            if ((cursor += this.horizontalVertexSpacing) > layoutModel.getWidth()) {
                cursor = this.getInitialPosition(this.horizontalVertexSpacing, layoutModel.getWidth(), overallWidth);
                cursor += w;
                cursor += this.horizontalVertexSpacing;
                int rowHeight = this.calculateHeight(layoutModel, rootsInRow, seenForHeight);
                y += rowHeight;
                rootsInRow.clear();
            }
            rootsInRow.add(vertex);
            int x = cursor - this.horizontalVertexSpacing - w / 2;
            this.buildTree(layoutModel, vertex, x, y, seen);
            this.merge(layoutModel, vertex);
        }
        int rowHeight = this.calculateHeight(layoutModel, rootsInRow, seenForHeight);
        if (this.expandLayout) {
            this.expandToFill(layoutModel);
        }
        return roots;
    }

    @Override
    protected int calculateWidth(LayoutModel<V> layoutModel, Collection<V> roots, Set<V> seen) {
        int overallWidth = 0;
        int cursor = this.horizontalVertexSpacing;
        for (V root : roots) {
            if (seen.contains(root)) continue;
            int w = this.calculateWidth(layoutModel, root, seen);
            cursor += w;
            log.trace("width of {} is {}", root, (Object)w);
            if ((cursor += this.horizontalVertexSpacing) > layoutModel.getWidth()) {
                cursor = this.horizontalVertexSpacing;
                cursor += w;
                cursor += this.horizontalVertexSpacing;
                ++this.rowCount;
                log.trace("row count now {}", (Object)this.rowCount);
            }
            overallWidth = Math.max(cursor, overallWidth);
        }
        log.trace("entire width from {} is {}", roots, (Object)overallWidth);
        return overallWidth;
    }

    protected int calculateOverallHeight(LayoutModel<V> layoutModel, Collection<V> roots, int overallWidth) {
        int overallHeight = 0;
        int cursor = this.horizontalVertexSpacing;
        HashSet<V> rootsInRow = new HashSet<V>();
        HashSet seenForWidth = new HashSet();
        HashSet seenForHeight = new HashSet();
        for (V root : roots) {
            if (seenForHeight.contains(root) || seenForWidth.contains(root)) continue;
            int w = this.calculateWidth(layoutModel, root, seenForWidth);
            cursor += w;
            log.trace("width of {} is {}", root, (Object)w);
            if ((cursor += this.horizontalVertexSpacing) > overallWidth) {
                cursor = this.horizontalVertexSpacing;
                cursor += w;
                cursor += this.horizontalVertexSpacing;
                overallHeight += super.calculateHeight(layoutModel, rootsInRow, seenForHeight);
                rootsInRow.clear();
            }
            rootsInRow.add(root);
        }
        return overallHeight += super.calculateHeight(layoutModel, rootsInRow, seenForHeight);
    }

    @Override
    public boolean constrained() {
        return false;
    }

    public static class Builder<V, T extends MultiRowTreeLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    extends TreeLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        @Override
        public T build() {
            return (T)new MultiRowTreeLayoutAlgorithm(this);
        }
    }
}

