/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jgrapht.alg.util.NeighborCache;
import org.jungrapht.visualization.layout.algorithms.AbstractLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TreeLayout;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTreeLayoutAlgorithm<V>
extends AbstractLayoutAlgorithm<V>
implements LayoutAlgorithm<V>,
TreeLayout<V> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTreeLayoutAlgorithm.class);
    protected Predicate<V> rootPredicate;
    protected Predicate<V> defaultRootPredicate;
    protected Comparator<V> rootComparator;
    protected Set<V> visitedVertices = new HashSet<V>();
    protected NeighborCache<V, ?> neighborCache;
    protected Map<V, Rectangle> baseBounds = new HashMap<V, Rectangle>();
    protected int horizontalVertexSpacing;
    protected int verticalVertexSpacing;
    protected Function<V, Rectangle> vertexBoundsFunction;
    protected boolean expandLayout;

    protected AbstractTreeLayoutAlgorithm(Builder<V, ?, ?> builder) {
        super(builder);
        Objects.requireNonNull(builder.vertexBoundsFunction);
        this.rootPredicate = builder.rootPredicate;
        this.rootComparator = builder.rootComparator;
        this.horizontalVertexSpacing = builder.horizontalVertexSpacing;
        this.verticalVertexSpacing = builder.verticalVertexSpacing;
        this.vertexBoundsFunction = builder.vertexBoundsFunction;
        this.expandLayout = builder.expandLayout;
    }

    @Override
    public void setRootPredicate(Predicate<V> rootPredicate) {
        this.rootPredicate = rootPredicate;
    }

    @Override
    public void setRootComparator(Comparator<V> rootComparator) {
        this.rootComparator = rootComparator;
    }

    @Override
    public void setVertexBoundsFunction(Function<V, Rectangle> vertexBoundsFunction) {
        Objects.requireNonNull(vertexBoundsFunction);
        this.vertexBoundsFunction = vertexBoundsFunction;
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        this.neighborCache = new NeighborCache(layoutModel.getGraph());
    }

    @Override
    public Map<V, Rectangle> getBaseBounds() {
        return this.baseBounds;
    }

    protected void adjustToFill(int largerWidth, int largerHeight) {
        if (largerWidth > largerHeight) {
            double expansion = (double)largerWidth / (double)largerHeight;
            this.verticalVertexSpacing = (int)((double)this.verticalVertexSpacing * expansion);
        } else if (largerWidth < largerHeight) {
            double expansion = (double)largerHeight / (double)largerWidth;
            this.horizontalVertexSpacing = (int)((double)this.horizontalVertexSpacing * expansion);
        }
    }

    protected void expandToFill(LayoutModel<V> layoutModel) {
        Rectangle vertexContainingRectangle = this.computeLayoutExtent(layoutModel);
        vertexContainingRectangle = Rectangle.from(vertexContainingRectangle.min().add(-this.horizontalVertexSpacing, -this.verticalVertexSpacing), vertexContainingRectangle.max().add(this.horizontalVertexSpacing, this.verticalVertexSpacing));
        int maxDimension = Math.max((int)vertexContainingRectangle.width, (int)vertexContainingRectangle.height);
        layoutModel.setSize(maxDimension, maxDimension);
        super.expandToFill(layoutModel, vertexContainingRectangle);
    }

    @Override
    public boolean constrained() {
        return false;
    }

    public static abstract class Builder<V, T extends AbstractTreeLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    extends AbstractLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        protected Predicate<V> rootPredicate;
        protected Comparator<V> rootComparator = (v1, v2) -> 0;
        protected int horizontalVertexSpacing = TreeLayout.TREE_LAYOUT_HORIZONTAL_SPACING;
        protected int verticalVertexSpacing = TreeLayout.TREE_LAYOUT_VERTICAL_SPACING;
        protected boolean expandLayout = true;
        protected Function<V, Rectangle> vertexBoundsFunction = v -> Rectangle.of(-5, -5, 10, 10);

        @Override
        protected B self() {
            return (B)this;
        }

        public B rootPredicate(Predicate<V> rootPredicate) {
            this.rootPredicate = rootPredicate;
            return (B)this.self();
        }

        public B rootComparator(Comparator<V> rootComparator) {
            this.rootComparator = rootComparator;
            return (B)this.self();
        }

        public B horizontalVertexSpacing(int horizontalVertexSpacing) {
            if (horizontalVertexSpacing <= 0) {
                throw new IllegalArgumentException("horizontalVertexSpacing must be positive");
            }
            this.horizontalVertexSpacing = horizontalVertexSpacing;
            return (B)this.self();
        }

        public B verticalVertexSpacing(int verticalVertexSpacing) {
            if (verticalVertexSpacing <= 0) {
                throw new IllegalArgumentException("verticalVertexSpacing must be positive");
            }
            this.verticalVertexSpacing = verticalVertexSpacing;
            return (B)this.self();
        }

        public B vertexBoundsFunction(Function<V, Rectangle> vertexBoundsFunction) {
            this.vertexBoundsFunction = vertexBoundsFunction;
            return (B)this.self();
        }

        public B expandLayout(boolean expandLayout) {
            this.expandLayout = expandLayout;
            return (B)this.self();
        }
    }
}

