/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.rmi.remote.RemoteRepository;
import org.apache.jackrabbit.rmi.remote.RemoteSession;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerObject;

public class ServerRepository
extends ServerObject
implements RemoteRepository {
    private Repository repository;

    public ServerRepository(Repository repository, RemoteAdapterFactory factory) throws RemoteException {
        super(factory);
        this.repository = repository;
    }

    public String getDescriptor(String name) throws RemoteException {
        return this.repository.getDescriptor(name);
    }

    public String[] getDescriptorKeys() throws RemoteException {
        return this.repository.getDescriptorKeys();
    }

    public RemoteSession login() throws RepositoryException, RemoteException {
        try {
            Session session = this.repository.login();
            return this.getFactory().getRemoteSession(session);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteSession login(String workspace) throws RepositoryException, RemoteException {
        try {
            Session session = this.repository.login(workspace);
            return this.getFactory().getRemoteSession(session);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteSession login(Credentials credentials) throws RepositoryException, RemoteException {
        try {
            Session session = this.repository.login(credentials);
            return this.getFactory().getRemoteSession(session);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteSession login(Credentials credentials, String workspace) throws RepositoryException, RemoteException {
        try {
            Session session = this.repository.login(credentials, workspace);
            return this.getFactory().getRemoteSession(session);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }
}

