/*
 * Decompiled with CFR 0.152.
 */
package ghidra.service.graph;

import ghidra.service.graph.Attributed;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;

public class AttributedEdge
extends Attributed {
    private final String id;
    private String htmlString;

    public AttributedEdge(String id) {
        this.id = id;
    }

    public String toString() {
        return this.id;
    }

    public String getHtmlString() {
        if (this.htmlString != null) {
            return this.htmlString;
        }
        Set<Map.Entry<String, String>> entries = this.entrySet();
        if (entries.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder("<html>");
        for (Map.Entry<String, String> entry : entries) {
            buf.append(entry.getKey());
            buf.append(":");
            buf.append(StringEscapeUtils.escapeHtml4((String)entry.getValue()));
            buf.append("<br>");
        }
        this.htmlString = buf.toString();
        return this.htmlString;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributedEdge other = (AttributedEdge)obj;
        return this.id.equals(other.id);
    }
}

