/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.map.TransformedMap;

public class LayoutPositions<V extends VisualVertex, E extends VisualEdge<V>> {
    private Map<V, Point2D> vertexLocations;
    private Map<E, List<Point2D>> edgeArticulations;

    public static <V extends VisualVertex, E extends VisualEdge<V>> LayoutPositions<V, E> getCurrentPositions(VisualGraph<V, E> graph, Layout<V, E> graphLayout) {
        HashMap<VisualVertex, Point2D> locations = new HashMap<VisualVertex, Point2D>();
        Collection vertices = graph.getVertices();
        for (VisualVertex vertex : vertices) {
            locations.put(vertex, (Point2D)graphLayout.apply((Object)vertex));
        }
        HashMap<VisualEdge, List<Point2D>> articulations = new HashMap<VisualEdge, List<Point2D>>();
        Collection edges = graph.getEdges();
        for (VisualEdge edge : edges) {
            articulations.put(edge, edge.getArticulationPoints());
        }
        return new LayoutPositions(locations, articulations);
    }

    public static <V extends VisualVertex, E extends VisualEdge<V>> LayoutPositions<V, E> createEmptyPositions() {
        return new LayoutPositions<V, E>();
    }

    public static <V extends VisualVertex, E extends VisualEdge<V>> LayoutPositions<V, E> createNewPositions(Map<V, Point2D> vertexLocations, Map<E, List<Point2D>> edgeArticulations) {
        return new LayoutPositions<V, E>(vertexLocations, edgeArticulations);
    }

    private LayoutPositions() {
        this.vertexLocations = new HashMap<V, Point2D>();
        this.edgeArticulations = new HashMap<E, List<Point2D>>();
    }

    private LayoutPositions(Map<V, Point2D> vertexLocations, Map<E, List<Point2D>> edgeArticulations) {
        this.setVertexLocations(vertexLocations);
        this.setEdgeArticulations(edgeArticulations);
    }

    private void setVertexLocations(Map<V, Point2D> newVertexLocations) {
        this.vertexLocations = TransformedMap.transformedMap(newVertexLocations, (Transformer)TransformerUtils.nopTransformer(), (Transformer)TransformerUtils.cloneTransformer());
    }

    private void setEdgeArticulations(Map<E, List<Point2D>> newEdgeArticulations) {
        this.edgeArticulations = TransformedMap.transformedMap(newEdgeArticulations, (Transformer)TransformerUtils.nopTransformer(), (Transformer)TransformerUtils.cloneTransformer());
    }

    public Map<V, Point2D> getVertexLocations() {
        return this.vertexLocations;
    }

    public Map<E, List<Point2D>> getEdgeArticulations() {
        return this.edgeArticulations;
    }

    public void dispose() {
        this.vertexLocations.clear();
        this.edgeArticulations.clear();
    }
}

