/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import generic.jar.ResourceFile;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraClassLoader;
import ghidra.GhidraLaunchable;
import ghidra.framework.GModule;
import ghidra.util.SystemUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import utility.application.ApplicationLayout;
import utility.module.ModuleUtilities;

public class GhidraLauncher {
    public static void main(String[] args) throws Exception {
        if (!(ClassLoader.getSystemClassLoader() instanceof GhidraClassLoader)) {
            throw new ClassNotFoundException("ERROR: Ghidra class loader not in use.  Confirm JVM argument \"-Djava.system.class.loader argument=" + GhidraClassLoader.class.getName() + "\" is set.");
        }
        GhidraApplicationLayout layout = new GhidraApplicationLayout();
        GhidraClassLoader loader = (GhidraClassLoader)ClassLoader.getSystemClassLoader();
        List<String> classpathList = new ArrayList<String>();
        Map<String, GModule> modules = GhidraLauncher.getOrderedModules(layout);
        if (SystemUtilities.isInDevelopmentMode()) {
            GhidraLauncher.addModuleBinPaths(classpathList, modules);
            GhidraLauncher.addExternalJarPaths(classpathList, layout.getApplicationRootDirs());
        } else {
            GhidraLauncher.addPatchPaths(classpathList, layout.getPatchDir());
            GhidraLauncher.addModuleJarPaths(classpathList, modules);
        }
        classpathList = GhidraLauncher.orderClasspath(classpathList, modules);
        classpathList.forEach(entry -> loader.addPath((String)entry));
        Class<?> cls = ClassLoader.getSystemClassLoader().loadClass(args[0]);
        if (!GhidraLaunchable.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("ERROR: \"" + args[0] + "\" is not a launchable class");
        }
        GhidraLaunchable launchable = (GhidraLaunchable)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        launchable.launch(layout, Arrays.copyOfRange(args, 1, args.length));
    }

    private static void addPatchPaths(List<String> pathList, ResourceFile patchDir) {
        if (patchDir == null || !patchDir.exists()) {
            return;
        }
        pathList.add(patchDir.getAbsolutePath());
        List<String> jars = GhidraLauncher.findJarsInDir(patchDir);
        Collections.sort(jars);
        pathList.addAll(jars);
    }

    private static void addModuleBinPaths(List<String> pathList, Map<String, GModule> modules) {
        Collection<ResourceFile> dirs = ModuleUtilities.getModuleBinDirectories(modules);
        dirs.forEach(d -> pathList.add(d.getAbsolutePath()));
    }

    private static void addModuleJarPaths(List<String> pathList, Map<String, GModule> modules) {
        Collection<ResourceFile> dirs = ModuleUtilities.getModuleLibDirectories(modules);
        dirs.forEach(d -> pathList.addAll(GhidraLauncher.findJarsInDir(d)));
    }

    private static void addExternalJarPaths(List<String> pathList, Collection<ResourceFile> appRootDirs) throws IOException {
        String LIBDEPS = "build/libraryDependencies.txt";
        ResourceFile libraryDependenciesFile = null;
        for (ResourceFile root : appRootDirs) {
            ResourceFile f;
            if (libraryDependenciesFile != null || !(f = new ResourceFile(root.getParentFile(), "build/libraryDependencies.txt")).isFile()) continue;
            libraryDependenciesFile = f;
        }
        if (libraryDependenciesFile == null) {
            throw new FileNotFoundException("build/libraryDependencies.txt file was not found!  Please do a prepDev.");
        }
        HashSet<String> pathSet = new HashSet<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(libraryDependenciesFile.getFile(false)));){
            String line;
            while ((line = reader.readLine()) != null) {
                String path = line.trim();
                if (path.startsWith("Module:") || !path.endsWith(".jar")) continue;
                ResourceFile jarFile = new ResourceFile(path);
                if (!jarFile.isFile()) {
                    System.err.println("Failed to find required jar file: " + jarFile);
                    continue;
                }
                pathSet.add(jarFile.getAbsolutePath());
            }
        }
        if (pathSet.isEmpty()) {
            throw new IllegalStateException("Files listed in 'build/libraryDependencies.txt' are incorrect--rebuild this file");
        }
        pathList.addAll(pathSet);
    }

    public static List<String> findJarsInDir(ResourceFile dir) {
        ArrayList<String> list = new ArrayList<String>();
        ResourceFile[] names = dir.listFiles();
        if (names != null) {
            for (ResourceFile file : names) {
                if (!file.getName().endsWith(".jar")) continue;
                list.add(file.getAbsolutePath());
            }
        }
        return list;
    }

    private static Map<String, GModule> getOrderedModules(ApplicationLayout layout) {
        Comparator comparator = (module1, module2) -> {
            int nameComparison = module1.getName().compareTo(module2.getName());
            boolean external1 = ModuleUtilities.isExternalModule(module1, layout);
            boolean external2 = ModuleUtilities.isExternalModule(module2, layout);
            if (external1 && external2) {
                return nameComparison;
            }
            if (external1) {
                return -1;
            }
            if (external2) {
                return 1;
            }
            HashMap<String, Integer> typePriorityMap = new HashMap<String, Integer>();
            typePriorityMap.put("Framework", 0);
            typePriorityMap.put("Configurations", 1);
            typePriorityMap.put("Features", 2);
            typePriorityMap.put("Processors", 3);
            typePriorityMap.put("GPL", 4);
            typePriorityMap.put("Extensions", 5);
            typePriorityMap.put("Test", 6);
            String type1 = module1.getModuleRoot().getParentFile().getName();
            String type2 = module2.getModuleRoot().getParentFile().getName();
            int priority1 = typePriorityMap.getOrDefault(type1, typePriorityMap.size());
            int priority2 = typePriorityMap.getOrDefault(type2, typePriorityMap.size());
            if (priority1 != priority2) {
                return Integer.compare(priority1, priority2);
            }
            return nameComparison;
        };
        ArrayList<GModule> moduleList = new ArrayList<GModule>(layout.getModules().values());
        Collections.sort(moduleList, comparator);
        LinkedHashMap<String, GModule> moduleMap = new LinkedHashMap<String, GModule>();
        for (GModule module : moduleList) {
            moduleMap.put(module.getName(), module);
        }
        return moduleMap;
    }

    private static List<String> orderClasspath(List<String> pathList, Map<String, GModule> modules) {
        Set fatJars = modules.values().stream().flatMap(m -> m.getFatJars().stream()).collect(Collectors.toSet());
        ArrayList<String> orderedList = new ArrayList<String>(pathList);
        for (String path : pathList) {
            if (!fatJars.contains(new File(path).getName())) continue;
            orderedList.remove(path);
            orderedList.add(path);
        }
        return orderedList;
    }
}

