/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import generic.jar.ResourceFile;
import ghidra.GhidraApplicationLayout;
import ghidra.framework.GModule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import utility.application.ApplicationLayout;
import utility.module.ModuleUtilities;

public class GhidraJarApplicationLayout
extends GhidraApplicationLayout {
    @Override
    public boolean inSingleJarMode() {
        return true;
    }

    @Override
    protected Collection<ResourceFile> findGhidraApplicationRootDirs() {
        ArrayList<ResourceFile> dirs = new ArrayList<ResourceFile>();
        dirs.add(new ResourceFile(ApplicationLayout.class.getResource("/_Root/Ghidra/application.properties").toExternalForm()).getParentFile());
        return dirs;
    }

    @Override
    protected ResourceFile findGhidraApplicationInstallationDir() {
        if (this.getApplicationRootDirs().isEmpty()) {
            return null;
        }
        return this.getApplicationRootDirs().iterator().next().getParentFile();
    }

    @Override
    protected Map<String, GModule> findGhidraModules() throws IOException {
        return ModuleUtilities.findModules(this.getApplicationRootDirs(), ModuleUtilities.findJarModuleRootDirectories(this.getApplicationRootDirs().iterator().next(), new ArrayList<ResourceFile>()));
    }

    @Override
    protected ResourceFile findExtensionArchiveDirectory() {
        return null;
    }

    @Override
    protected List<ResourceFile> findExtensionInstallationDirectories() {
        ResourceFile extensionInstallDir = new ResourceFile(ApplicationLayout.class.getResource("/_Root/Ghidra/Extensions").toExternalForm());
        return Collections.singletonList(extensionInstallDir);
    }
}

