/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.constantpool;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ConstantPoolLongInfo
extends AbstractConstantPoolInfoJava {
    private int highBytes;
    private int lowBytes;

    public ConstantPoolLongInfo(BinaryReader reader) throws IOException {
        super(reader);
        this.highBytes = reader.readNextInt();
        this.lowBytes = reader.readNextInt();
    }

    public long getValue() {
        return ((long)this.highBytes << 32) + ((long)this.lowBytes & 0xFFFFFFFFL);
    }

    public String toString() {
        return "" + this.getValue();
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "CONSTANT_Long_info";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(BYTE, "tag", null);
        structure.add(DWORD, "high_bytes", null);
        structure.add(DWORD, "low_bytes", null);
        return structure;
    }
}

