/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.plugin;

import docking.ActionContext;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import functioncalls.plugin.FcgProvider;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.services.GoToService;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.task.SwingUpdateManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Graph", shortDescription="Function Call Graph Plugin", description="Displays a graph of incoming and outgoing calls for a given function.")
public class FunctionCallGraphPlugin
extends ProgramPlugin {
    static final String NAME = "Function Call Graph";
    static final String SHOW_PROVIDER_ACTION_NAME = "Display Function Call Graph";
    static final HelpLocation DEFAULT_HELP = new HelpLocation(FunctionCallGraphPlugin.class.getSimpleName(), FunctionCallGraphPlugin.class.getSimpleName());
    private FcgProvider provider;
    private static final int MIN_UPDATE_DELAY = 750;
    private SwingUpdateManager locationUpdater = new SwingUpdateManager(750, () -> this.doLocationChanged());

    public FunctionCallGraphPlugin(PluginTool tool) {
        super(tool, true, false);
    }

    protected void init() {
        this.provider = new FcgProvider((Tool)this.tool, this);
        this.createActions();
    }

    public void writeConfigState(SaveState state) {
        this.provider.writeConfigState(state);
    }

    public void readConfigState(SaveState state) {
        this.provider.readConfigState(state);
    }

    protected void locationChanged(ProgramLocation loc) {
        this.locationUpdater.update();
    }

    private void doLocationChanged() {
        this.provider.locationChanged(this.getCurrentLocation());
    }

    void handleProviderLocationChanged(ProgramLocation location) {
        GoToService goTo = (GoToService)this.tool.getService(GoToService.class);
        if (goTo == null) {
            return;
        }
        SystemUtilities.runSwingLater(() -> goTo.goTo(location));
    }

    protected void dispose() {
        this.provider.dispose();
    }

    private void createActions() {
        DockingAction showProviderAction = new DockingAction(SHOW_PROVIDER_ACTION_NAME, this.getName()){

            public void actionPerformed(ActionContext context) {
                FunctionCallGraphPlugin.this.provider.setVisible(true);
            }
        };
        this.tool.addAction((DockingActionIf)showProviderAction);
    }

    void showProvider() {
        this.provider.setVisible(true);
    }

    FcgProvider getProvider() {
        return this.provider;
    }

    Address getCurrentAddress() {
        if (this.currentLocation == null) {
            return null;
        }
        return this.currentLocation.getAddress();
    }

    ProgramLocation getCurrentLocation() {
        return this.currentLocation;
    }
}

