/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.math.ec;

import java.math.BigInteger;
import org.python.bouncycastle.math.ec.AbstractECMultiplier;
import org.python.bouncycastle.math.ec.ECAlgorithms;
import org.python.bouncycastle.math.ec.ECCurve;
import org.python.bouncycastle.math.ec.ECPoint;
import org.python.bouncycastle.math.ec.ECPointMap;
import org.python.bouncycastle.math.ec.endo.GLVEndomorphism;

public class GLVMultiplier
extends AbstractECMultiplier {
    protected final ECCurve curve;
    protected final GLVEndomorphism glvEndomorphism;

    public GLVMultiplier(ECCurve eCCurve, GLVEndomorphism gLVEndomorphism) {
        if (eCCurve == null || eCCurve.getOrder() == null) {
            throw new IllegalArgumentException("Need curve with known group order");
        }
        this.curve = eCCurve;
        this.glvEndomorphism = gLVEndomorphism;
    }

    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        if (!this.curve.equals(eCPoint.getCurve())) {
            throw new IllegalStateException();
        }
        BigInteger bigInteger2 = eCPoint.getCurve().getOrder();
        BigInteger[] bigIntegerArray = this.glvEndomorphism.decomposeScalar(bigInteger.mod(bigInteger2));
        BigInteger bigInteger3 = bigIntegerArray[0];
        BigInteger bigInteger4 = bigIntegerArray[1];
        ECPointMap eCPointMap = this.glvEndomorphism.getPointMap();
        if (this.glvEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.implShamirsTrickWNaf(eCPoint, bigInteger3, eCPointMap, bigInteger4);
        }
        return ECAlgorithms.implShamirsTrickWNaf(eCPoint, bigInteger3, eCPointMap.map(eCPoint), bigInteger4);
    }
}

