/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization.mouse;

import docking.DockingUtils;
import ghidra.graph.visualization.DefaultGraphDisplay;
import ghidra.graph.visualization.mouse.JgtCursorRestoringPlugin;
import ghidra.graph.visualization.mouse.JgtEdgeNavigationPlugin;
import ghidra.graph.visualization.mouse.JgtTranslatingPlugin;
import ghidra.graph.visualization.mouse.JgtVertexFocusingPlugin;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.DefaultGraphMouse;
import org.jungrapht.visualization.control.GraphMousePlugin;
import org.jungrapht.visualization.control.ScalingControl;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;

public class JgtPluggableGraphMouse
extends DefaultGraphMouse<AttributedVertex, AttributedEdge> {
    private DefaultGraphDisplay graphDisplay;

    public JgtPluggableGraphMouse(DefaultGraphDisplay graphDisplay) {
        super(DefaultGraphMouse.builder());
        this.graphDisplay = graphDisplay;
    }

    public void loadPlugins() {
        this.add((GraphMousePlugin)new JgtEdgeNavigationPlugin());
        this.add((GraphMousePlugin)new JgtVertexFocusingPlugin(this.graphDisplay));
        this.add((GraphMousePlugin)new ScalingGraphMousePlugin((ScalingControl)new CrossoverScalingControl(), 0, this.in, this.out));
        this.add((GraphMousePlugin)new JgtTranslatingPlugin());
        this.add((GraphMousePlugin)new SelectingGraphMousePlugin(1024, 0, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        this.add((GraphMousePlugin)new JgtCursorRestoringPlugin());
        this.setPluginsLoaded();
    }
}

