/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import com.google.common.base.Splitter;
import ghidra.service.graph.Attributed;
import ghidra.service.graph.AttributedEdge;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.jungrapht.visualization.util.ShapeFactory;

abstract class ProgramGraphFunctions {
    static float edgeWidth = Float.parseFloat(System.getProperty("jungrapht.edgeWidth", "4.0f"));
    private static ShapeFactory<Attributed> shapeFactory = new ShapeFactory(n -> 50, n -> Float.valueOf(1.0f));

    private ProgramGraphFunctions() {
    }

    private static Shape byShapeName(Attributed n, String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "Square": {
                return shapeFactory.getRectangle((Object)n);
            }
            case "Circle": {
                return shapeFactory.getEllipse((Object)n);
            }
            case "Triangle": {
                return shapeFactory.getRegularPolygon((Object)n, 3);
            }
            case "TriangleDown": {
                return shapeFactory.getRegularPolygon((Object)n, 3, Math.PI);
            }
            case "Diamond": {
                return shapeFactory.getRectangle((Object)n, 0.7853981633974483);
            }
            case "Star": {
                return shapeFactory.getRegularStar((Object)n, 5);
            }
            case "Pentagon": {
                return shapeFactory.getRegularPolygon((Object)n, 5);
            }
            case "Hexagon": {
                return shapeFactory.getRegularPolygon((Object)n, 6);
            }
            case "Octagon": {
                return shapeFactory.getRegularPolygon((Object)n, 8);
            }
        }
        return null;
    }

    public static Shape getVertexShape(Attributed vertex) {
        try {
            String vertexType = vertex.getAttribute("VertexType");
            Shape shape = ProgramGraphFunctions.byShapeName(vertex, vertex.getAttribute("Icon"));
            if (shape != null) {
                return shape;
            }
            if (vertexType == null) {
                return shapeFactory.getRectangle((Object)vertex);
            }
            switch (vertexType) {
                case "Entry": {
                    return shapeFactory.getRegularPolygon((Object)vertex, 3, Math.PI);
                }
                case "Exit": {
                    return shapeFactory.getRegularPolygon((Object)vertex, 3);
                }
                case "Switch": {
                    return shapeFactory.getRectangle((Object)vertex, 0.7853981633974483);
                }
                case "Body": 
                case "External": {
                    return shapeFactory.getRectangle((Object)vertex);
                }
            }
            return shapeFactory.getEllipse((Object)vertex);
        }
        catch (Exception ex) {
            return shapeFactory.getRectangle((Object)vertex);
        }
    }

    public static Stroke getEdgeStroke(AttributedEdge edge) {
        String edgeType = edge.getAttribute("EdgeType");
        if (edgeType != null && edgeType.equals("Fall-Through")) {
            return new BasicStroke(edgeWidth * 2.0f);
        }
        return new BasicStroke(edgeWidth);
    }

    public static String getLabel(Attributed attributed) {
        Map map = attributed.getAttributeMap();
        if (map.get("Code") != null) {
            String code = StringEscapeUtils.escapeHtml4((String)((String)map.get("Code")));
            return "<html>" + String.join((CharSequence)"<p>", Splitter.on((char)'\n').split((CharSequence)code));
        }
        return (String)map.get("Name");
    }
}

