/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import ghidra.service.graph.AttributedVertex;
import java.util.function.Function;
import org.jungrapht.visualization.layout.algorithms.BalloonLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.CircleLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.EiglspergerLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.FRLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.GEMLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.KKLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.RadialTreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TidierRadialTreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TidierTreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.repulsion.BarnesHutFRRepulsion;
import org.jungrapht.visualization.layout.algorithms.repulsion.StandardFRRepulsion;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Layering;

class LayoutFunction
implements Function<String, LayoutAlgorithm.Builder<AttributedVertex, ?, ?>> {
    static final String KAMADA_KAWAI = "Force Balanced";
    static final String FRUCTERMAN_REINGOLD = "Force Directed";
    static final String CIRCLE_MINCROSS = "Circle";
    static final String TIDIER_TREE = "Compact Hierarchical";
    static final String TIDIER_RADIAL_TREE = "Compact Radial";
    static final String MIN_CROSS_TOP_DOWN = "Hierarchical MinCross Top Down";
    static final String MIN_CROSS_LONGEST_PATH = "Hierarchical MinCross Longest Path";
    static final String MIN_CROSS_NETWORK_SIMPLEX = "Hierarchical MinCross Network Simplex";
    static final String MIN_CROSS_COFFMAN_GRAHAM = "Hierarchical MinCross Coffman Graham";
    static final String TREE = "Hierarchical";
    static final String RADIAL = "Radial";
    static final String BALLOON = "Balloon";
    static final String GEM = "Gem (Graph Embedder)";

    LayoutFunction() {
    }

    public String[] getNames() {
        return new String[]{TIDIER_TREE, TREE, TIDIER_RADIAL_TREE, MIN_CROSS_TOP_DOWN, MIN_CROSS_LONGEST_PATH, MIN_CROSS_NETWORK_SIMPLEX, MIN_CROSS_COFFMAN_GRAHAM, CIRCLE_MINCROSS, KAMADA_KAWAI, FRUCTERMAN_REINGOLD, RADIAL, BALLOON, GEM};
    }

    @Override
    public LayoutAlgorithm.Builder<AttributedVertex, ?, ?> apply(String name) {
        switch (name) {
            case "Gem (Graph Embedder)": {
                return GEMLayoutAlgorithm.edgeAwareBuilder();
            }
            case "Force Balanced": {
                return KKLayoutAlgorithm.builder().preRelaxDuration(1000);
            }
            case "Force Directed": {
                return FRLayoutAlgorithm.builder().repulsionContractBuilder((StandardFRRepulsion.Builder)BarnesHutFRRepulsion.builder());
            }
            case "Circle": {
                return CircleLayoutAlgorithm.builder().reduceEdgeCrossing(true);
            }
            case "Compact Radial": {
                return TidierRadialTreeLayoutAlgorithm.edgeAwareBuilder();
            }
            case "Hierarchical MinCross Top Down": {
                return EiglspergerLayoutAlgorithm.edgeAwareBuilder().layering(Layering.TOP_DOWN);
            }
            case "Hierarchical MinCross Longest Path": {
                return EiglspergerLayoutAlgorithm.edgeAwareBuilder().layering(Layering.LONGEST_PATH);
            }
            case "Hierarchical MinCross Network Simplex": {
                return EiglspergerLayoutAlgorithm.edgeAwareBuilder().layering(Layering.NETWORK_SIMPLEX);
            }
            case "Hierarchical MinCross Coffman Graham": {
                return EiglspergerLayoutAlgorithm.edgeAwareBuilder().layering(Layering.COFFMAN_GRAHAM);
            }
            case "Radial": {
                return RadialTreeLayoutAlgorithm.builder().verticalVertexSpacing(300);
            }
            case "Balloon": {
                return BalloonLayoutAlgorithm.builder().verticalVertexSpacing(300);
            }
            case "Hierarchical": {
                return TreeLayoutAlgorithm.builder();
            }
        }
        return TidierTreeLayoutAlgorithm.edgeAwareBuilder();
    }
}

