/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class IconShape {

    static class Function
    implements java.util.function.Function<Shape, Type> {
        Function() {
        }

        @Override
        public Type apply(Shape shape) {
            List<Point2D> points = this.getShapePoints(shape);
            if (points.size() == 3) {
                if (this.isInvertedTriangle(points)) {
                    return Type.INVERTED_TRIANGLE;
                }
                return Type.TRIANGLE;
            }
            if (points.size() == 5) {
                if (this.isDiamond(points)) {
                    return Type.DIAMOND;
                }
                return Type.RECTANGLE;
            }
            return Type.ELLIPSE;
        }

        boolean isInvertedTriangle(List<Point2D> threePoints) {
            if (threePoints.size() != 3) {
                throw new IllegalArgumentException("Shape from " + threePoints + " is not a triangle");
            }
            return threePoints.stream().filter(p -> p.getY() < 0.0).count() <= (long)(threePoints.size() / 2);
        }

        boolean isDiamond(List<Point2D> fivePoints) {
            if (fivePoints.size() != 5) {
                throw new IllegalArgumentException("Shape from " + fivePoints + " is not a quadrilateral");
            }
            return fivePoints.stream().filter(p -> (int)p.getY() == 0).count() == 2L;
        }

        List<Point2D> getShapePoints(Shape shape) {
            float[] seg = new float[6];
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            PathIterator i = shape.getPathIterator(null, 1.0);
            while (!i.isDone()) {
                int ret = i.currentSegment(seg);
                if (ret == 0) {
                    points.add(new Point2D.Float(seg[0], seg[1]));
                } else if (ret == 1) {
                    points.add(new Point2D.Float(seg[0], seg[1]));
                }
                i.next();
            }
            return points;
        }
    }

    public static enum Type {
        TRIANGLE,
        INVERTED_TRIANGLE,
        RECTANGLE,
        DIAMOND,
        ELLIPSE;

    }
}

