/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedGraph;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EdgeComparator
implements Comparator<AttributedEdge> {
    private final Set<AttributedEdge> prioritized;

    public EdgeComparator(AttributedGraph graph, String attributeName, String value) {
        this.prioritized = graph.edgeSet().stream().filter(e -> Objects.equals(e.getAttribute(attributeName), value)).collect(Collectors.toSet());
    }

    @Override
    public int compare(AttributedEdge edgeOne, AttributedEdge edgeTwo) {
        boolean edgeOnePriority = this.prioritized.contains(edgeOne);
        boolean edgeTwoPriority = this.prioritized.contains(edgeTwo);
        if (edgeOnePriority && !edgeTwoPriority) {
            return -1;
        }
        if (!edgeOnePriority && edgeTwoPriority) {
            return 1;
        }
        return 0;
    }
}

