/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import ghidra.framework.options.Options;
import ghidra.framework.options.PreferenceState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.visualization.DefaultGraphDisplay;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayProvider;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.Set;

public class DefaultGraphDisplayProvider
implements GraphDisplayProvider {
    private static final String PREFERENCES_KEY = "GRAPH_DISPLAY_SERVICE";
    private static final String DEFAULT_SATELLITE_STATE = "DEFAULT_SATELLITE_STATE";
    private final Set<DefaultGraphDisplay> displays = new HashSet<DefaultGraphDisplay>();
    private PluginTool pluginTool;
    private Options options;
    private int displayCounter = 1;
    private boolean defaultSatelliteState;
    private PreferenceState preferences;

    public String getName() {
        return "Default Graph Display";
    }

    public PluginTool getPluginTool() {
        return this.pluginTool;
    }

    public Options getOptions() {
        return this.options;
    }

    public GraphDisplay getGraphDisplay(boolean reuseGraph, TaskMonitor monitor) {
        if (reuseGraph && !this.displays.isEmpty()) {
            DefaultGraphDisplay visibleGraph = this.getVisibleGraph();
            visibleGraph.restoreToDefaultSetOfActions();
            return visibleGraph;
        }
        DefaultGraphDisplay display = (DefaultGraphDisplay)Swing.runNow(() -> new DefaultGraphDisplay(this, this.displayCounter++));
        this.displays.add(display);
        return display;
    }

    public void initialize(PluginTool tool, Options graphOptions) {
        this.pluginTool = tool;
        this.options = graphOptions;
        this.preferences = this.pluginTool.getWindowManager().getPreferenceState(PREFERENCES_KEY);
        if (this.preferences == null) {
            this.preferences = new PreferenceState();
            this.pluginTool.getWindowManager().putPreferenceState(PREFERENCES_KEY, this.preferences);
        }
        this.defaultSatelliteState = this.preferences.getBoolean(DEFAULT_SATELLITE_STATE, false);
    }

    private DefaultGraphDisplay getVisibleGraph() {
        return this.displays.stream().filter(d -> d.getComponent().isShowing()).findAny().orElse(this.displays.iterator().next());
    }

    public void optionsChanged(Options graphOptions) {
    }

    public void dispose() {
        HashSet<DefaultGraphDisplay> set = new HashSet<DefaultGraphDisplay>(this.displays);
        for (DefaultGraphDisplay display : set) {
            display.close();
        }
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("GraphServices", "Default_Graph_Display");
    }

    public void remove(DefaultGraphDisplay defaultGraphDisplay) {
        this.displays.remove(defaultGraphDisplay);
    }

    boolean getDefaultSatelliteState() {
        return this.defaultSatelliteState;
    }

    void setDefaultSatelliteState(boolean b) {
        this.defaultSatelliteState = b;
        this.preferences.putBoolean(DEFAULT_SATELLITE_STATE, b);
    }
}

