/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.export;

import docking.DialogComponentProvider;
import docking.options.editor.ButtonPanelFactory;
import docking.widgets.OptionDialog;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GLabel;
import ghidra.framework.preferences.Preferences;
import ghidra.graph.export.AttributedGraphExporterFactory;
import ghidra.graph.export.GraphExportFormat;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jgrapht.Graph;
import org.jgrapht.nio.GraphExporter;

public class GraphExporterDialog
extends DialogComponentProvider {
    private static GraphExportFormat lastUsedExporterFormat = GraphExportFormat.GRAPHML;
    private JTextField filePathTextField;
    private JButton fileChooserButton;
    private GhidraComboBox<GraphExportFormat> comboBox;
    private final Graph<AttributedVertex, AttributedEdge> graph;

    public GraphExporterDialog(Graph<AttributedVertex, AttributedEdge> graph) {
        super("Export Graph");
        this.graph = graph;
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation("GraphServices", "Graph_Exporter"));
        this.validate();
    }

    private JComponent buildWorkPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.buildMainPanel());
        panel.add(this.buildButtonPanel());
        return panel;
    }

    private Component buildButtonPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        return panel;
    }

    private Component buildMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)new GLabel("Format: ", 4));
        panel.add(this.buildFormatChooser());
        panel.add((Component)new GLabel("Output File: ", 4));
        panel.add(this.buildFilePanel());
        return panel;
    }

    public void setFilePath(String filePath) {
        this.filePathTextField.setText(filePath);
    }

    private Component buildFilePanel() {
        this.filePathTextField = new JTextField();
        this.filePathTextField.setName("OUTPUT_FILE_TEXTFIELD");
        this.filePathTextField.setText(this.getFileName());
        this.filePathTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                GraphExporterDialog.this.validate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                GraphExporterDialog.this.validate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GraphExporterDialog.this.validate();
            }
        });
        this.fileChooserButton = ButtonPanelFactory.createButton((int)2);
        this.fileChooserButton.addActionListener(e -> this.chooseDestinationFile());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.filePathTextField, "Center");
        panel.add((Component)this.fileChooserButton, "East");
        return panel;
    }

    private String getFileName() {
        String name = "graph";
        File lastDir = this.getLastExportDirectory();
        return lastDir.getAbsolutePath() + File.separator + name;
    }

    private void chooseDestinationFile() {
        File file;
        String filePath;
        File currentFile;
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.getComponent());
        chooser.setSelectedFile(this.getLastExportDirectory());
        chooser.setTitle("Select Output File");
        chooser.setApproveButtonText("Select Output File");
        chooser.setApproveButtonToolTipText("Select File");
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        chooser.setSelectedFileFilter(GhidraFileFilter.ALL);
        GraphExportFormat exporter = this.getSelectedExporter();
        if (exporter != null) {
            chooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(exporter.getDefaultFileExtension(), exporter.toString()));
        }
        File file2 = currentFile = (filePath = this.filePathTextField.getText().trim()).isEmpty() ? null : new File(filePath);
        if (currentFile != null) {
            chooser.setSelectedFile(currentFile);
        }
        if ((file = chooser.getSelectedFile()) != null) {
            this.setLastExportDirectory(file);
            this.filePathTextField.setText(file.getAbsolutePath());
        }
    }

    private void setLastExportDirectory(File file) {
        Preferences.setProperty((String)"LastExportDirectory", (String)file.getParent());
        Preferences.store();
    }

    private File getLastExportDirectory() {
        String lastDirStr = Preferences.getProperty((String)"LastExportDirectory", (String)System.getProperty("user.home"), (boolean)true);
        return new File(lastDirStr);
    }

    private Component buildFormatChooser() {
        List<GraphExportFormat> exporters = this.getApplicableExporters();
        this.comboBox = new GhidraComboBox((Object[])exporters.toArray(new GraphExportFormat[0]));
        GraphExportFormat defaultExporter = this.getDefaultExporter(exporters);
        if (defaultExporter != null) {
            this.comboBox.setSelectedItem((Object)defaultExporter);
        }
        return this.comboBox;
    }

    private List<GraphExportFormat> getApplicableExporters() {
        return Arrays.asList(GraphExportFormat.values());
    }

    private GraphExportFormat getDefaultExporter(List<GraphExportFormat> list) {
        for (GraphExportFormat exporter : list) {
            if (!lastUsedExporterFormat.equals((Object)exporter)) continue;
            return exporter;
        }
        return list.isEmpty() ? null : list.get(0);
    }

    private void validate() {
        this.setOkEnabled(false);
        this.setStatusText("");
        if (this.getSelectedExporter() == null) {
            this.setStatusText("Please select an exporter format.");
            return;
        }
        String fileToExportInto = this.filePathTextField.getText();
        if (fileToExportInto.length() == 0) {
            this.setStatusText("Please enter a destination file.");
            return;
        }
        File file = new File(fileToExportInto);
        if (file.isDirectory()) {
            this.setStatusText("The specified output file is a directory.");
            return;
        }
        if (file.exists() && !file.canWrite()) {
            this.setStatusText("The specified output file is read-only.");
            return;
        }
        this.setOkEnabled(true);
    }

    private GraphExportFormat getSelectedExporter() {
        return (GraphExportFormat)((Object)this.comboBox.getSelectedItem());
    }

    private File getSelectedOutputFile() {
        String filename = this.appendExporterFileExtension(this.filePathTextField.getText().trim());
        File outputFileName = new File(filename);
        if (outputFileName.getParent() == null) {
            File defaultParent = new File(System.getProperty("user.home"));
            outputFileName = new File(defaultParent, filename);
        }
        return outputFileName;
    }

    private String appendExporterFileExtension(String filename) {
        GraphExportFormat exporterFormat = this.getSelectedExporter();
        String extension = "." + exporterFormat.getDefaultFileExtension();
        if (!filename.toLowerCase().endsWith(extension.toLowerCase())) {
            return filename + extension;
        }
        return filename;
    }

    protected void okCallback() {
        lastUsedExporterFormat = this.getSelectedExporter();
        this.setLastExportDirectory(this.getSelectedOutputFile());
        if (this.doExport()) {
            this.close();
        }
    }

    private boolean doExport() {
        AtomicBoolean success = new AtomicBoolean();
        TaskLauncher.launchModal((String)"Exporting Graph", monitor -> success.set(this.tryExport(monitor)));
        return success.get();
    }

    private boolean tryExport(TaskMonitor monitor) {
        boolean bl;
        GraphExportFormat exporterFormat = this.getSelectedExporter();
        File outputFile = this.getSelectedOutputFile();
        if (outputFile.exists() && OptionDialog.showOptionDialog((Component)this.getComponent(), (String)"Overwrite Existing File?", (String)("The file " + outputFile + " already exists.\nDo you want to overwrite it?"), (String)"Overwrite", (int)3) != 1) {
            return false;
        }
        FileWriter writer = new FileWriter(outputFile);
        try {
            GraphExporter<AttributedVertex, AttributedEdge> exporter = AttributedGraphExporterFactory.getExporter(exporterFormat);
            exporter.exportGraph(this.graph, (Writer)writer);
            this.displaySummaryResults(exporterFormat);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Msg.error((Object)((Object)this), (Object)"Exception exporting", (Throwable)e);
                SystemUtilities.runSwingLater(() -> this.setStatusText("Exception exporting: " + e.getMessage() + ".  If null, see log for details."));
                return false;
            }
        }
        ((Writer)writer).close();
        return bl;
    }

    private void displaySummaryResults(GraphExportFormat exporter) {
        File outputFile = this.getSelectedOutputFile();
        String results = "Destination file:       Destination file Size:  " + outputFile.length() + "\nFormat:                 " + exporter.toString() + "\n\n";
        String log = exporter.toString();
        if (log != null) {
            results = results + log;
        }
    }

    public void setOutputFile(String outputFilePath) {
        this.filePathTextField.setText(outputFilePath);
    }

    public void setExportFormat(GraphExportFormat format) {
        this.comboBox.setSelectedItem((Object)format);
    }
}

