/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.export;

import ghidra.graph.export.AbstractGraphExporterFactory;
import ghidra.graph.export.GraphExportFormat;
import ghidra.service.graph.Attributed;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jgrapht.nio.Attribute;
import org.jgrapht.nio.AttributeType;
import org.jgrapht.nio.DefaultAttribute;
import org.jgrapht.nio.GraphExporter;

public class AttributedGraphExporterFactory
extends AbstractGraphExporterFactory<AttributedVertex, AttributedEdge> {
    AttributedGraphExporterFactory() {
        this.vertexLabelProvider = AttributedVertex::getName;
        this.edgeLabelProvider = Object::toString;
        this.edgeIdProvider = AttributedEdge::getId;
        this.edgeAttributeProvider = AttributedGraphExporterFactory::getComponentAttributes;
        this.vertexAttributeProvider = AttributedGraphExporterFactory::getComponentAttributes;
        this.vertexIdProvider = AttributedVertex::getId;
    }

    public static GraphExporter<AttributedVertex, AttributedEdge> getExporter(GraphExportFormat format) {
        return new AttributedGraphExporterFactory().createExporter(format);
    }

    private static Map<String, Attribute> getComponentAttributes(Attributed v) {
        return v.getAttributeMap().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, DefaultAttribute>((String)entry.getKey(), new DefaultAttribute((Object)((String)entry.getValue()), AttributeType.STRING))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

