/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.export;

import ghidra.graph.export.GraphExportFormat;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jgrapht.nio.Attribute;
import org.jgrapht.nio.BaseExporter;
import org.jgrapht.nio.GraphExporter;
import org.jgrapht.nio.IntegerIdProvider;
import org.jgrapht.nio.csv.CSVExporter;
import org.jgrapht.nio.csv.CSVFormat;
import org.jgrapht.nio.csv.VisioExporter;
import org.jgrapht.nio.dimacs.DIMACSExporter;
import org.jgrapht.nio.dimacs.DIMACSFormat;
import org.jgrapht.nio.dot.DOTExporter;
import org.jgrapht.nio.gml.GmlExporter;
import org.jgrapht.nio.graphml.GraphMLExporter;
import org.jgrapht.nio.json.JSONExporter;
import org.jgrapht.nio.lemon.LemonExporter;
import org.jgrapht.nio.matrix.MatrixExporter;

public abstract class AbstractGraphExporterFactory<V, E> {
    protected char csvDelimiter = (char)44;
    protected CSVFormat csvFormat = CSVFormat.EDGE_LIST;
    protected DIMACSFormat dimacsFormat = DIMACSExporter.DEFAULT_DIMACS_FORMAT;
    protected MatrixExporter.Format matrixFormat = MatrixExporter.Format.SPARSE_ADJACENCY_MATRIX;
    protected Function<V, String> defaultVertexIdProvider = new IntegerIdProvider();
    protected Function<E, String> defaultEdgeIdProvider = new IntegerIdProvider();
    protected Supplier<String> graphIdProvider = () -> "Ghidra";
    protected Function<V, String> vertexLabelProvider = Object::toString;
    protected Function<E, String> edgeLabelProvider = Object::toString;
    protected Function<E, String> edgeIdProvider = this.defaultEdgeIdProvider;
    protected Function<V, String> vertexIdProvider = this.defaultVertexIdProvider;
    protected Function<E, Map<String, Attribute>> edgeAttributeProvider = e -> Collections.emptyMap();
    protected Function<V, Map<String, Attribute>> vertexAttributeProvider = v -> Collections.emptyMap();

    public GraphExporter<V, E> createExporter(GraphExportFormat format) {
        switch (format) {
            case CSV: {
                return this.createCsvExporter();
            }
            case DIMACS: {
                return this.createDimacsExporter();
            }
            case DOT: {
                return this.createDotExporter();
            }
            case GML: {
                return this.createGmlExporter();
            }
            case JSON: {
                return this.createJsonExporter();
            }
            case LEMON: {
                return this.createLemonExporter();
            }
            case MATRIX: {
                return this.createMatrixExporter();
            }
            case VISIO: {
                return this.createVisioExporter();
            }
        }
        return this.createGraphMlExporter();
    }

    private GraphExporter<V, E> createGraphMlExporter() {
        GraphMLExporter exporter = new GraphMLExporter(this.vertexIdProvider);
        this.setupExporter((BaseExporter<V, E>)exporter);
        return exporter;
    }

    private GraphExporter<V, E> createVisioExporter() {
        VisioExporter exporter = new VisioExporter(this.vertexIdProvider);
        this.setupExporter((BaseExporter<V, E>)exporter);
        return exporter;
    }

    private GraphExporter<V, E> createMatrixExporter() {
        MatrixExporter exporter = new MatrixExporter(this.matrixFormat, this.vertexIdProvider);
        this.setupExporter((BaseExporter<V, E>)exporter);
        return exporter;
    }

    private GraphExporter<V, E> createLemonExporter() {
        LemonExporter exporter = new LemonExporter(this.vertexIdProvider);
        this.setupExporter((BaseExporter<V, E>)exporter);
        return exporter;
    }

    private GraphExporter<V, E> createJsonExporter() {
        JSONExporter exporter = new JSONExporter(this.vertexIdProvider);
        this.setupExporter((BaseExporter<V, E>)exporter);
        return exporter;
    }

    private GraphExporter<V, E> createGmlExporter() {
        GmlExporter exporter = new GmlExporter(this.vertexIdProvider);
        this.setupExporter((BaseExporter<V, E>)exporter);
        return exporter;
    }

    String getQuotedId(V vertex) {
        String id = this.vertexIdProvider.apply(vertex);
        return "\"" + id + "\"";
    }

    private GraphExporter<V, E> createDotExporter() {
        DOTExporter exporter = new DOTExporter(this::getQuotedId);
        this.setupExporter((BaseExporter<V, E>)exporter);
        return exporter;
    }

    private GraphExporter<V, E> createDimacsExporter() {
        DIMACSExporter exporter = new DIMACSExporter(this.vertexIdProvider, this.dimacsFormat);
        this.setupExporter((BaseExporter<V, E>)exporter);
        return exporter;
    }

    private GraphExporter<V, E> createCsvExporter() {
        CSVExporter exporter = new CSVExporter(this.vertexIdProvider, this.csvFormat, this.csvDelimiter);
        this.setupExporter((BaseExporter<V, E>)exporter);
        return exporter;
    }

    private void setupExporter(BaseExporter<V, E> exporter) {
        exporter.setEdgeIdProvider(this.defaultEdgeIdProvider);
        exporter.setVertexAttributeProvider(this.vertexAttributeProvider);
        exporter.setEdgeAttributeProvider(this.edgeAttributeProvider);
        exporter.setGraphIdProvider(this.graphIdProvider);
    }
}

