/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.bin.format.pdb.PdbException;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.pdb.PdbLocator;
import ghidra.app.util.pdb.PdbProgramAttributes;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorRestrictions;
import ghidra.framework.Application;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.net.http.HttpUtil;
import ghidra.program.model.listing.Program;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Properties;
import pdb.AskPdbOptionsDialog;
import pdb.AskPdbUrlDialog;
import pdb.LoadPdbTask;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Download PDB Files from a Symbol Server", description="This plugin manages the downloading of PDB files from a Symbol Server.")
public class PdbSymbolServerPlugin
extends Plugin {
    private static final String symbolServerEnvVar = "_NT_SYMBOL_PATH";
    private static final String PDB_URL_PROPERTY = "PDB Symbol Server";
    private static String expectedPdbContentType = "application/octet-stream";
    private static String expectedXmlContentType = "text/xml";
    private static Properties urlProperties = null;
    private static String serverUrl = null;
    private static File localDir = null;
    private PdbParser.PdbFileType fileType = PdbParser.PdbFileType.PDB;
    private boolean includePePdbPath = false;

    public PdbSymbolServerPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        urlProperties = new Properties();
        urlProperties.setProperty("User-Agent", "Microsoft-Symbol-Server/6.3.9600.17298");
    }

    public void setPdbFileType(PdbParser.PdbFileType fileType) {
        this.fileType = fileType;
    }

    private void createActions() {
        ProgramContextAction downloadPdbAction = new ProgramContextAction("Download_PDB_File", this.getName()){

            public boolean isEnabledForContext(ProgramActionContext context) {
                return context.getProgram() != null;
            }

            protected void actionPerformed(ProgramActionContext programContext) {
                PdbSymbolServerPlugin.this.downloadPDB();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&File", "Download PDB File..."}, null, "Import PDB");
        menuData.setMenuSubGroup("4");
        downloadPdbAction.setMenuBarData(menuData);
        downloadPdbAction.setEnabled(false);
        downloadPdbAction.setHelpLocation(new HelpLocation("Pdb", downloadPdbAction.getName()));
        this.tool.addAction((DockingActionIf)downloadPdbAction);
    }

    private void downloadPDB() {
        block9: {
            Program program = GhidraProgramUtilities.getCurrentProgram((PluginTool)this.tool);
            try {
                PdbFileAndStatus returnPdb = this.getPdbFile(program);
                File returnedPdbFile = returnPdb.getPdbFile();
                switch (returnPdb.getPdbStatus()) {
                    case NOT_FOUND: {
                        Msg.showInfo(((Object)((Object)this)).getClass(), null, (String)"Error", (Object)("Could not download the " + this.fileType + " file for this version of " + program.getName() + " from " + serverUrl));
                        break;
                    }
                    case DOWNLOADED: {
                        Msg.showInfo(((Object)((Object)this)).getClass(), null, (String)"File Retrieved", (Object)("Downloaded and saved file '" + returnedPdbFile.getName() + "' to \n" + returnedPdbFile.getParent()));
                    }
                    case EXISTING: {
                        this.tryToLoadPdb(returnedPdbFile, program);
                    }
                }
            }
            catch (CancelledException ce) {
                this.tool.setStatusInfo("Downloading PDB from Symbol Server was cancelled.");
                return;
            }
            catch (PdbException pe) {
                Msg.showInfo(((Object)((Object)this)).getClass(), null, (String)"Error", (Object)("Error: " + pe.getMessage()));
            }
            catch (IOException ioe) {
                Msg.showInfo(((Object)((Object)this)).getClass(), null, (String)"Error", (Object)(ioe.getClass().getSimpleName() + ": " + ioe.getMessage()));
                if (!(ioe instanceof UnknownHostException)) break block9;
                serverUrl = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PdbFileAndStatus getPdbFile(Program program) throws CancelledException, IOException, PdbException {
        try {
            File downloadedPdb;
            File pdbFile;
            PdbProgramAttributes pdbAttributes = PdbParser.getPdbAttributes(program);
            if (pdbAttributes.getGuidAgeCombo() == null) {
                throw new PdbException("Incomplete PDB information (GUID/Signature and/or age) associated with this program.\nEither the program is not a PE, or it was not compiled with debug information.");
            }
            this.fileType = this.askForFileExtension();
            this.includePePdbPath = this.askIncludePeHeaderPdbPath();
            String symbolEnv = System.getenv(symbolServerEnvVar);
            if (symbolEnv != null) {
                this.parseSymbolEnv(symbolEnv);
            }
            if ((pdbFile = PdbParser.findPDB(pdbAttributes, this.includePePdbPath, localDir = this.askForLocalStorageLocation(), this.fileType)) != null && pdbFile.getName().endsWith(this.fileType.toString())) {
                String htmlString = HTMLUtilities.toWrappedHTML((String)("Found potential* matching PDB at: \n   " + pdbFile.getAbsolutePath() + "\n\n* Match determined by file name only; not vetted for matching GUID/version.\n\nContinue with download?\n\n<i>(downloaded file will be saved in a directory of the form " + localDir.getAbsolutePath() + File.separator + "&lt;pdbFilename&gt;" + File.separator + "&lt;GUID&gt;" + File.separator + ")</i>"));
                int response = OptionDialog.showYesNoDialog(null, (String)"Potential Matching PDB Found", (String)htmlString);
                switch (response) {
                    case 0: {
                        throw new CancelledException();
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        PdbFileAndStatus pdbFileAndStatus = new PdbFileAndStatus(pdbFile, ReturnPdbStatus.EXISTING);
                        return pdbFileAndStatus;
                    }
                }
            }
            if (!(serverUrl = this.askForSymbolServerUrl()).endsWith("/")) {
                serverUrl = serverUrl + "/";
            }
            if ((downloadedPdb = this.attemptToDownloadPdb(pdbAttributes, serverUrl, localDir)) != null) {
                PdbFileAndStatus pdbFileAndStatus = new PdbFileAndStatus(downloadedPdb, ReturnPdbStatus.DOWNLOADED);
                return pdbFileAndStatus;
            }
            PdbFileAndStatus pdbFileAndStatus = new PdbFileAndStatus();
            return pdbFileAndStatus;
        }
        finally {
            Preferences.store();
        }
    }

    private void parseSymbolEnv(String envString) {
        if (!envString.startsWith("srv") && !envString.startsWith("SRV")) {
            return;
        }
        String[] envParts = envString.split("\\*");
        if (envParts.length < 3) {
            return;
        }
        File storageDir = new File(envParts[1]);
        if (storageDir.isDirectory()) {
            localDir = storageDir;
        }
        serverUrl = envParts[2];
        Msg.info(((Object)((Object)this)).getClass(), (Object)("Using server URL: " + serverUrl));
    }

    private PdbParser.PdbFileType askForFileExtension() throws CancelledException {
        int choice = OptionDialog.showOptionDialog(null, (String)"pdb or pdb.xml", (String)"Download a .pdb or .pdb.xml file?", (String)"PDB", (String)"XML");
        if (choice == 0) {
            throw new CancelledException();
        }
        return choice == 1 ? PdbParser.PdbFileType.PDB : PdbParser.PdbFileType.XML;
    }

    private boolean askIncludePeHeaderPdbPath() throws CancelledException {
        int choice = OptionDialog.showOptionDialog(null, (String)"PE-specified PDB Path", (String)"Unsafe: Include PE-specified PDB Path in search for existing PDB", (String)"Yes", (String)"No");
        if (choice == 0) {
            throw new CancelledException();
        }
        return choice == 1;
    }

    String askForSymbolServerUrl() throws CancelledException {
        String storedURL;
        String dialogResponse = null;
        if (serverUrl != null) {
            storedURL = serverUrl;
        } else {
            storedURL = Preferences.getProperty((String)PDB_URL_PROPERTY);
            if (storedURL == null) {
                storedURL = "";
            }
        }
        while (dialogResponse == null) {
            AskPdbUrlDialog dialog = new AskPdbUrlDialog("Symbol Server URL", "What is the Symbol Server URL?", (Object)storedURL);
            if (dialog.isCanceled()) {
                throw new CancelledException();
            }
            dialogResponse = dialog.getValueAsString();
            if (!dialogResponse.startsWith("http")) {
                Msg.showInfo(((Object)((Object)this)).getClass(), null, (String)"Incomplete URL", (Object)"URL should start with either 'http' or 'https'.");
                dialogResponse = null;
                continue;
            }
            try {
                new URL(dialogResponse);
            }
            catch (MalformedURLException malExc) {
                Msg.showInfo(((Object)((Object)this)).getClass(), null, (String)"Malformed URL", (Object)malExc.toString());
                dialogResponse = null;
            }
        }
        Preferences.setProperty((String)PDB_URL_PROPERTY, dialogResponse);
        return dialogResponse;
    }

    private File askForLocalStorageLocation() throws CancelledException {
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this.tool.getActiveWindow());
        File[] chosenDir = new File[1];
        File testDirectory = null;
        testDirectory = localDir != null ? localDir : PdbLocator.getDefaultPdbSymbolsDir();
        File storedDirectory = testDirectory;
        Runnable r = () -> {
            while (chosenDir[0] == null && !fileChooser.wasCancelled()) {
                fileChooser.setSelectedFile(storedDirectory);
                fileChooser.setTitle("Select Location to Save Retrieved File");
                fileChooser.setApproveButtonText("OK");
                fileChooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
                chosenDir[0] = fileChooser.getSelectedFile();
                if (chosenDir[0] == null) continue;
                if (!chosenDir[0].exists()) {
                    Msg.showInfo(((Object)((Object)this)).getClass(), null, (String)"Directory does not exist", (Object)("The directory '" + chosenDir[0].getAbsolutePath() + "' does not exist. Please create it or choose a valid directory."));
                    chosenDir[0] = null;
                    continue;
                }
                if (!chosenDir[0].isFile()) continue;
                Msg.showInfo(((Object)((Object)this)).getClass(), null, (String)"Invalid Directory", (Object)("The location '" + chosenDir[0].getAbsolutePath() + "' represents a file, not a directory. Please choose a directory."));
                chosenDir[0] = null;
            }
        };
        SystemUtilities.runSwingNow((Runnable)r);
        if (fileChooser.wasCancelled()) {
            throw new CancelledException();
        }
        PdbLocator.setDefaultPdbSymbolsDir(chosenDir[0]);
        return chosenDir[0];
    }

    boolean retrieveFile(String fileUrl, File fileDestination) throws IOException, PdbException {
        return this.retrieveFile(fileUrl, fileDestination, null);
    }

    boolean retrieveFile(String fileUrl, File fileDestination, Properties retrieveProperties) throws IOException, PdbException {
        block4: {
            String expectedContentType = this.fileType == PdbParser.PdbFileType.PDB ? expectedPdbContentType : expectedXmlContentType;
            try {
                String contentType = HttpUtil.getFile((String)fileUrl, (Properties)retrieveProperties, (boolean)true, (File)fileDestination);
                if (contentType != null && !contentType.equals(expectedContentType)) {
                    fileDestination.delete();
                    return false;
                }
            }
            catch (IOException ioe) {
                if (ioe.getMessage().equals("Forbidden")) {
                    throw new PdbException("PKI Certificate needed for user authentication.\nTo set a certificate, use the Project Window's 'Edit -> Set PKI Certificate' Action.");
                }
                if (ioe.getMessage().equals("Not Found")) break block4;
                throw ioe;
            }
        }
        return fileDestination.exists();
    }

    File createSubFoldersAndMoveFile(File destinationFolder, String pdbFilename, String guidAgeString, String downloadFilename, File tempFile) throws IOException {
        File pdbOuterSaveDir = this.makeDirectory(destinationFolder, pdbFilename);
        File pdbInnerSaveDir = this.makeDirectory(pdbOuterSaveDir, guidAgeString);
        File finalDestFile = new File(pdbInnerSaveDir, downloadFilename);
        try {
            Files.move(tempFile.toPath(), finalDestFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            tempFile.delete();
            throw new IOException("Could not save file: " + finalDestFile.getAbsolutePath());
        }
        return finalDestFile;
    }

    private File makeDirectory(File parentFolder, String directoryName) throws IOException {
        boolean madeDir;
        File newDir = new File(parentFolder, directoryName);
        if (newDir.isFile()) {
            throw new IOException("Trying to create folder " + newDir.getAbsolutePath() + ",\nbut it shares the same name as an existing file.\nPlease try downloading PDB again, selecting a non-conflicting destination folder.");
        }
        if (!newDir.isDirectory() && !(madeDir = newDir.mkdir())) {
            throw new IOException("Trying to create parent folders to store PDB file. Could not create directory " + newDir.getAbsolutePath() + ".");
        }
        return newDir;
    }

    File uncompressCabFile(File cabFile, String targetFilename) throws PdbException, IOException {
        String[] cabextractCmdLine;
        String cabextractPath = null;
        if (PdbParser.onWindows) {
            File cabextractExe = new File("C:\\Windows\\System32\\expand.exe");
            if (!cabextractExe.exists()) {
                throw new PdbException("Expected to find cabinet expansion utility 'expand.exe' in " + cabextractExe.getParent());
            }
            cabextractPath = cabextractExe.getAbsolutePath();
            cabextractCmdLine = new String[]{cabextractPath, "-R", cabFile.getAbsolutePath(), "-F:" + targetFilename, cabFile.getParent()};
        } else {
            try {
                cabextractPath = Application.getOSFile((String)"cabextract").getAbsolutePath();
            }
            catch (FileNotFoundException e) {
                throw new PdbException("Unable to find 'cabextract' executable.");
            }
            cabextractCmdLine = new String[]{cabextractPath, "-q", "-d", cabFile.getParent(), "-F", targetFilename, cabFile.getAbsolutePath()};
        }
        ProcessBuilder builder = new ProcessBuilder(cabextractCmdLine);
        Process currentProcess = builder.start();
        try {
            int exitValue = currentProcess.waitFor();
            if (exitValue != 0) {
                throw new PdbException("Abnormal termination of 'cabextract' process.");
            }
        }
        catch (InterruptedException exitValue) {
            // empty catch block
        }
        FilenameFilter pdbFilter = (dir, filename) -> {
            String lowercaseName = filename.toLowerCase();
            return lowercaseName.endsWith(this.fileType.toString());
        };
        File[] files = cabFile.getParentFile().listFiles(pdbFilter);
        if (files != null) {
            for (File childFile : files) {
                if (!childFile.getName().equals(targetFilename)) continue;
                return childFile;
            }
        }
        return null;
    }

    private File attemptToDownloadPdb(PdbProgramAttributes pdbAttributes, String downloadUrl, File saveToLocation) throws PdbException, IOException {
        RetrieveFileType retrieveType;
        String tempDirPath = System.getProperty("java.io.tmpdir");
        File tempDir = new File(tempDirPath);
        File createdFile = this.downloadExtractAndMoveFile(pdbAttributes, downloadUrl, tempDir, saveToLocation, retrieveType = this.fileType == PdbParser.PdbFileType.XML ? RetrieveFileType.XML : RetrieveFileType.PDB);
        if (createdFile != null) {
            return createdFile;
        }
        if (retrieveType == RetrieveFileType.PDB) {
            return this.downloadExtractAndMoveFile(pdbAttributes, downloadUrl, tempDir, saveToLocation, RetrieveFileType.CAB);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File downloadExtractAndMoveFile(PdbProgramAttributes pdbAttributes, String downloadUrl, File tempSaveDirectory, File finalSaveDirectory, RetrieveFileType retrieveFileType) throws IOException, PdbException {
        String guidAgeString = pdbAttributes.getGuidAgeCombo();
        List<String> potentialPdbFilenames = pdbAttributes.getPotentialPdbFilenames();
        File tempFile = null;
        String tempFileExtension = retrieveFileType == RetrieveFileType.CAB ? "cab" : "pdb";
        File returnFile = null;
        try {
            tempFile = new File(tempSaveDirectory, "TempPDB." + tempFileExtension);
            block8: for (String pdbFilename : potentialPdbFilenames) {
                Object downloadFilename = pdbFilename;
                String currentUrl = downloadUrl + pdbFilename + "/" + guidAgeString + "/";
                boolean retrieveSuccess = false;
                switch (retrieveFileType) {
                    case CAB: {
                        currentUrl = currentUrl + (String)downloadFilename;
                        retrieveSuccess = this.retrieveFile(currentUrl = currentUrl.substring(0, currentUrl.length() - 1) + "_", tempFile, urlProperties);
                        if (!retrieveSuccess) continue block8;
                        File extractedFile = this.uncompressCabFile(tempFile, pdbFilename);
                        if (extractedFile == null) {
                            throw new IOException("Unable to uncompress .cab file extracted for " + pdbFilename);
                        }
                        returnFile = extractedFile;
                        break;
                    }
                    case PDB: {
                        currentUrl = currentUrl + (String)downloadFilename;
                        retrieveSuccess = this.retrieveFile(currentUrl, tempFile);
                        if (!retrieveSuccess) continue block8;
                        returnFile = tempFile;
                        break;
                    }
                    case XML: {
                        downloadFilename = (String)downloadFilename + ".xml";
                        currentUrl = currentUrl + (String)downloadFilename;
                        retrieveSuccess = this.retrieveFile(currentUrl, tempFile);
                        if (!retrieveSuccess) continue block8;
                        returnFile = tempFile;
                    }
                }
                File file = this.createSubFoldersAndMoveFile(finalSaveDirectory, pdbFilename, guidAgeString, (String)downloadFilename, returnFile);
                return file;
            }
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
        return null;
    }

    private void tryToLoadPdb(File downloadedPdb, Program currentProgram) {
        String htmlString;
        int response;
        AutoAnalysisManager aam = AutoAnalysisManager.getAnalysisManager((Program)currentProgram);
        if (aam.isAnalyzing()) {
            Msg.showWarn(((Object)((Object)this)).getClass(), null, (String)"Load PDB", (Object)"Unable to load PDB file while analysis is running.");
            return;
        }
        boolean analyzed = currentProgram.getOptions("Program Information").getBoolean("Analyzed", false);
        String message = "Would you like to apply the following PDB:\n\n" + downloadedPdb.getAbsolutePath() + "\n\n to " + currentProgram.getName() + "?";
        if (analyzed) {
            message = message + "\n \nWARNING: Loading PDB after analysis has been performed may produce\npoor results.  PDBs should generally be loaded prior to analysis or\nautomatically during auto-analysis.";
        }
        if ((response = OptionDialog.showYesNoDialog(null, (String)"Load PDB?", (String)(htmlString = HTMLUtilities.toWrappedHTML((String)message)))) != 1) {
            return;
        }
        AskPdbOptionsDialog optionsDialog = new AskPdbOptionsDialog(null, this.fileType == PdbParser.PdbFileType.PDB);
        if (optionsDialog.isCanceled()) {
            return;
        }
        boolean useMsDiaParser = optionsDialog.useMsDiaParser();
        PdbApplicatorRestrictions restrictions = optionsDialog.getApplicatorRestrictions();
        this.tool.setStatusInfo("");
        try {
            DataTypeManagerService service = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
            if (service == null) {
                Msg.showWarn(((Object)((Object)this)).getClass(), null, (String)"Load PDB", (Object)"Unable to locate DataTypeService in the current tool.");
                return;
            }
            TaskLauncher.launch((Task)new LoadPdbTask(currentProgram, downloadedPdb, useMsDiaParser, restrictions, service));
        }
        catch (Exception pe) {
            Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Error", (Object)pe.getMessage());
        }
    }

    class PdbFileAndStatus {
        private File pdbFile;
        private ReturnPdbStatus pdbStatus;

        public PdbFileAndStatus() {
            this.pdbFile = null;
            this.pdbStatus = ReturnPdbStatus.NOT_FOUND;
        }

        public PdbFileAndStatus(File pdbFile, ReturnPdbStatus pdbStatus) {
            this.pdbFile = pdbFile;
            this.pdbStatus = pdbStatus;
        }

        public File getPdbFile() {
            return this.pdbFile;
        }

        public ReturnPdbStatus getPdbStatus() {
            return this.pdbStatus;
        }
    }

    static enum ReturnPdbStatus {
        DOWNLOADED,
        EXISTING,
        NOT_FOUND;

    }

    static enum RetrieveFileType {
        PDB,
        XML,
        CAB;

    }
}

