/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorRestrictions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.io.File;
import pdb.AskPdbOptionsDialog;
import pdb.LoadPdbTask;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Import External PDB Files", description="This plugin manages the import of PDB files to add debug information to a program.")
public class PdbPlugin
extends Plugin {
    private ProgramContextAction loadPdbAction;
    private GhidraFileChooser pdbChooser;

    public PdbPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void createActions() {
        this.loadPdbAction = new ProgramContextAction("Load PDB File", this.getName()){

            public boolean isEnabledForContext(ProgramActionContext context) {
                return context.getProgram() != null;
            }

            protected void actionPerformed(ProgramActionContext programContext) {
                PdbPlugin.this.loadPDB();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&File", "Load PDB File..."}, null, "Import PDB");
        menuData.setMenuSubGroup("3");
        this.loadPdbAction.setMenuBarData(menuData);
        this.loadPdbAction.setEnabled(false);
        this.loadPdbAction.setHelpLocation(new HelpLocation("ImporterPlugin", this.loadPdbAction.getName()));
        this.tool.addAction((DockingActionIf)this.loadPdbAction);
    }

    private void loadPDB() {
        int response;
        Program program = GhidraProgramUtilities.getCurrentProgram((PluginTool)this.tool);
        AutoAnalysisManager aam = AutoAnalysisManager.getAnalysisManager((Program)program);
        if (aam.isAnalyzing()) {
            Msg.showWarn(((Object)((Object)this)).getClass(), null, (String)"Load PDB", (Object)"Unable to load PDB file while analysis is running.");
            return;
        }
        boolean analyzed = program.getOptions("Program Information").getBoolean("Analyzed", false);
        if (analyzed && (response = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Load PDB Warning", (String)"Loading PDB after running analysis may produce poor results.\nPDBs should generally be loaded prior to analysis or\nautomatically during auto-analysis.", (String)"Continue")) != 1) {
            return;
        }
        try {
            File pdb = this.getPdbFile(program);
            if (pdb == null) {
                this.tool.setStatusInfo("Loading PDB was cancelled.");
                return;
            }
            boolean isPdbFile = pdb.getName().toLowerCase().endsWith(".pdb");
            AskPdbOptionsDialog optionsDialog = new AskPdbOptionsDialog(null, isPdbFile);
            if (optionsDialog.isCanceled()) {
                return;
            }
            boolean useMsDiaParser = optionsDialog.useMsDiaParser();
            PdbApplicatorRestrictions restrictions = optionsDialog.getApplicatorRestrictions();
            this.tool.setStatusInfo("");
            DataTypeManagerService service = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
            if (service == null) {
                Msg.showWarn(((Object)((Object)this)).getClass(), null, (String)"Load PDB", (Object)"Unable to locate DataTypeService in the current tool.");
                return;
            }
            TaskLauncher.launch((Task)new LoadPdbTask(program, pdb, useMsDiaParser, restrictions, service));
        }
        catch (Exception pe) {
            Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Error", (Object)pe.getMessage());
        }
    }

    private File getPdbFile(Program program) {
        File pdbFile = PdbParser.findPDB(program);
        if (this.pdbChooser == null) {
            this.pdbChooser = new GhidraFileChooser((Component)this.tool.getToolFrame());
            this.pdbChooser.setTitle("Select PDB file to load:");
            this.pdbChooser.setApproveButtonText("Select PDB");
            this.pdbChooser.setFileSelectionMode(0);
            this.pdbChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(new String[]{"pdb", "xml"}, "Program Database Files and PDB XML Representations"));
        }
        if (pdbFile != null) {
            this.pdbChooser.setSelectedFile(pdbFile);
        }
        File selectedFile = this.pdbChooser.getSelectedFile();
        return selectedFile;
    }
}

