/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.MultiLineMessageDialog;
import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.MicrosoftDemanglerAnalyzer;
import ghidra.app.plugin.core.datamgr.archive.DuplicateIdException;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.bin.format.pdb.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbIdentifiers;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.PdbLocator;
import ghidra.app.util.pdb.PdbProgramAttributes;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorOptions;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorRestrictions;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class LoadPdbTask
extends Task {
    private File pdbFile;
    private DataTypeManagerService service;
    private final Program program;
    private final boolean useMsDiaParser;
    private final PdbApplicatorRestrictions restrictions;
    private static final String BLANK_LINE = " \n";

    LoadPdbTask(Program program, File pdbFile, boolean useMsDiaParser, PdbApplicatorRestrictions restrictions, DataTypeManagerService service) {
        super("Load PDB", true, false, true, true);
        this.program = program;
        this.pdbFile = pdbFile;
        this.useMsDiaParser = useMsDiaParser;
        this.restrictions = restrictions;
        this.service = service;
    }

    public void run(final TaskMonitor monitor) {
        final MessageLog log = new MessageLog();
        AnalysisWorker worker = new AnalysisWorker(){

            public String getWorkerName() {
                return "Load PDB";
            }

            public boolean analysisWorkerCallback(Program currentProgram, Object workerContext, TaskMonitor currentMonitor) throws CancelledException {
                try {
                    if (LoadPdbTask.this.useMsDiaParser ? !LoadPdbTask.this.parseWithMsDiaParser(log, monitor) : !LoadPdbTask.this.parseWithNewParser(log, monitor)) {
                        return false;
                    }
                    LoadPdbTask.this.analyzeSymbols(currentMonitor, log);
                }
                catch (IOException e) {
                    log.appendMsg("PDB IO Error: " + e.getMessage());
                }
                return false;
            }
        };
        try {
            AutoAnalysisManager.getAnalysisManager((Program)this.program).scheduleWorker(worker, null, true, monitor);
            if (log.hasMessages()) {
                MultiLineMessageDialog dialog = new MultiLineMessageDialog("Load PDB File", "There were warnings/errors loading the PDB file.", log.toString(), 2, false);
                DockingWindowManager.showDialog(null, (DialogComponentProvider)dialog);
            }
        }
        catch (CancelledException | InterruptedException dialog) {
        }
        catch (InvocationTargetException e) {
            Object message;
            Throwable t = e.getCause();
            if (t == null) {
                message = "Unknown cause";
            } else {
                message = t.getMessage();
                if (message == null) {
                    message = t.toString();
                }
            }
            message = "Error processing PDB file:  " + this.pdbFile + ".\n" + (String)message;
            Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Load PDB Failed", (Object)message, (Throwable)t);
        }
    }

    private boolean parseWithMsDiaParser(MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ghidra.app.util.bin.format.pdb.PdbParser parser = new ghidra.app.util.bin.format.pdb.PdbParser(this.pdbFile, this.program, this.service, true, monitor);
        try {
            parser.parse();
            parser.openDataTypeArchives();
            parser.applyTo(log);
            return true;
        }
        catch (DuplicateIdException | PdbException e) {
            log.appendMsg("PDB Error: " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseWithNewParser(MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        PdbReaderOptions pdbReaderOptions = new PdbReaderOptions();
        PdbApplicatorOptions pdbApplicatorOptions = new PdbApplicatorOptions();
        pdbApplicatorOptions.setRestrictions(this.restrictions);
        PdbProgramAttributes programAttributes = new PdbProgramAttributes(this.program);
        try (AbstractPdb pdb = PdbParser.parse(this.pdbFile.getAbsolutePath(), pdbReaderOptions, monitor);){
            PdbIdentifiers identifiers = pdb.getIdentifiers();
            if (!PdbLocator.verifyPdbSignature(programAttributes, identifiers)) {
                StringBuilder builder = new StringBuilder();
                builder.append("Selected PDB does not match program's PDB specification!\n");
                builder.append(BLANK_LINE);
                builder.append("Program's PDB specification:\n");
                builder.append((CharSequence)PdbLocator.formatPdbIdentifiers(programAttributes));
                builder.append(BLANK_LINE);
                builder.append("Selected PDB file specification:\n");
                builder.append((CharSequence)PdbLocator.formatPdbIdentifiers(this.pdbFile.getAbsolutePath(), identifiers));
                builder.append(BLANK_LINE);
                builder.append("Do you wish to force load this PDB?");
                if (1 != OptionDialog.showYesNoDialog(null, (String)"Confirm PDB Load", (String)builder.toString())) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            monitor.setMessage("PDB: Parsing " + this.pdbFile + "...");
            pdb.deserialize(monitor);
            PdbApplicator applicator = new PdbApplicator(this.pdbFile.getAbsolutePath(), pdb);
            applicator.applyTo(this.program, (DataTypeManager)this.program.getDataTypeManager(), this.program.getImageBase(), pdbApplicatorOptions, monitor, log);
            boolean bl = true;
            return bl;
        }
        catch (ghidra.app.util.bin.format.pdb2.pdbreader.PdbException e) {
            log.appendMsg("PDB Error: " + e.getMessage());
            return false;
        }
    }

    private void analyzeSymbols(TaskMonitor monitor, MessageLog log) {
        MicrosoftDemanglerAnalyzer demanglerAnalyzer = new MicrosoftDemanglerAnalyzer();
        String analyzerName = demanglerAnalyzer.getName();
        Options analysisProperties = this.program.getOptions("Analyzers");
        String defaultValueAsString = analysisProperties.getValueAsString(analyzerName);
        boolean doDemangle = true;
        if (defaultValueAsString != null) {
            doDemangle = Boolean.parseBoolean(defaultValueAsString);
        }
        if (doDemangle) {
            Memory addrs = this.program.getMemory();
            monitor.initialize(addrs.getNumAddresses());
            try {
                demanglerAnalyzer.added(this.program, (AddressSetView)addrs, monitor, log);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }
    }
}

