/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.combobox.GComboBox;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorRestrictions;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

class AskPdbOptionsDialog
extends DialogComponentProvider {
    private boolean isCanceled;
    private boolean useMsDiaParser;
    private PdbApplicatorRestrictions restrictions = PdbApplicatorRestrictions.NONE;

    AskPdbOptionsDialog(Component parent, boolean isPdbFile) {
        super("Load PDB Options", true, true, true, false);
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel optionsPanel = new JPanel((LayoutManager)new PairLayout(10, 10));
        GComboBox restrictionsCombo = new GComboBox((Object[])PdbApplicatorRestrictions.values());
        restrictionsCombo.setSelectedItem((Object)PdbApplicatorRestrictions.NONE);
        restrictionsCombo.addActionListener(e -> {
            this.restrictions = (PdbApplicatorRestrictions)((Object)((Object)restrictionsCombo.getSelectedItem()));
        });
        optionsPanel.add(new JLabel("PDB Parser:"));
        if (isPdbFile) {
            this.useMsDiaParser = false;
            if (PdbParser.onWindows) {
                GComboBox combo = new GComboBox((Object[])new String[]{"PDB Universal", "PDB MSDIA"});
                combo.setSelectedIndex(0);
                restrictionsCombo.setEnabled(!this.useMsDiaParser);
                combo.addActionListener(e -> {
                    this.useMsDiaParser = combo.getSelectedIndex() == 1;
                    restrictionsCombo.setEnabled(!this.useMsDiaParser);
                    if (this.useMsDiaParser) {
                        restrictionsCombo.setSelectedItem((Object)PdbApplicatorRestrictions.NONE);
                    }
                });
                optionsPanel.add((Component)combo);
            } else {
                this.useMsDiaParser = false;
                JLabel label = new JLabel("PDB Universal");
                optionsPanel.add(label);
            }
        } else {
            this.useMsDiaParser = true;
            return;
        }
        optionsPanel.add(new JLabel("Restrictions:"));
        optionsPanel.add((Component)restrictionsCombo);
        panel.add((Component)optionsPanel, "Center");
        this.addWorkPanel(panel);
        this.addApplyButton();
        this.addCancelButton();
        this.setDefaultButton(this.applyButton);
        this.setRememberSize(false);
        DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this);
    }

    protected void applyCallback() {
        this.isCanceled = false;
        this.close();
    }

    protected void cancelCallback() {
        this.isCanceled = true;
        this.close();
    }

    boolean isCanceled() {
        return this.isCanceled;
    }

    boolean useMsDiaParser() {
        return this.useMsDiaParser;
    }

    PdbApplicatorRestrictions getApplicatorRestrictions() {
        return this.restrictions;
    }
}

