/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SymbolGroup {
    private Map<Long, AbstractMsSymbol> symbolsByOffset;
    private int moduleNumber;
    private List<Long> offsets;
    private Map<Long, Integer> indexByOffset;

    public SymbolGroup(Map<Long, AbstractMsSymbol> symbolsByOffset, int moduleNumber) {
        this(symbolsByOffset, moduleNumber, 0L);
    }

    public SymbolGroup(Map<Long, AbstractMsSymbol> symbolsByOffset, int moduleNumber, long offset) {
        this.symbolsByOffset = symbolsByOffset;
        this.moduleNumber = moduleNumber;
        this.initOffsets();
    }

    List<AbstractMsSymbol> getSymbols() {
        return new ArrayList<AbstractMsSymbol>(this.symbolsByOffset.values());
    }

    int getModuleNumber() {
        return this.moduleNumber;
    }

    int size() {
        return this.symbolsByOffset.size();
    }

    List<Long> getOrderedOffsets() {
        return new ArrayList<Long>(this.symbolsByOffset.keySet());
    }

    Set<Long> getOffsets() {
        return this.symbolsByOffset.keySet();
    }

    List<AbstractMsSymbol> getOrderedSymbols() {
        ArrayList<AbstractMsSymbol> symbols = new ArrayList<AbstractMsSymbol>();
        for (long offset : this.offsets) {
            symbols.add(this.symbolsByOffset.get(offset));
        }
        return symbols;
    }

    private void initOffsets() {
        this.offsets = new ArrayList<Long>();
        this.indexByOffset = new HashMap<Long, Integer>();
        int index = 0;
        for (Map.Entry<Long, AbstractMsSymbol> entry : this.symbolsByOffset.entrySet()) {
            this.offsets.add(index, entry.getKey());
            this.indexByOffset.put(entry.getKey(), index++);
        }
    }

    protected void dump(Writer writer) throws IOException {
        writer.write("SymbolGroup-------------------------------------------------");
        for (Map.Entry<Long, AbstractMsSymbol> entry : this.symbolsByOffset.entrySet()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\n------------------------------------------------------------\n");
            builder.append(String.format("Offset: 0X%08X\n", entry.getKey()));
            builder.append(entry.getValue());
            writer.write(builder.toString());
        }
        writer.write("\nEnd SymbolGroup---------------------------------------------\n");
    }

    AbstractMsSymbolIterator iterator() {
        return new AbstractMsSymbolIterator();
    }

    class AbstractMsSymbolIterator
    implements Iterator<AbstractMsSymbol> {
        private int currentIndex = 0;
        private long currentOffset = 0L;

        @Override
        public boolean hasNext() {
            return this.currentIndex != SymbolGroup.this.offsets.size();
        }

        public AbstractMsSymbol peek() throws NoSuchElementException {
            if (this.currentIndex == SymbolGroup.this.offsets.size()) {
                throw new NoSuchElementException("none left");
            }
            long temporaryOffset = SymbolGroup.this.offsets.get(this.currentIndex);
            AbstractMsSymbol symbol = SymbolGroup.this.symbolsByOffset.get(temporaryOffset);
            if (symbol == null) {
                throw new NoSuchElementException("No symbol");
            }
            return symbol;
        }

        @Override
        public AbstractMsSymbol next() {
            if (this.currentIndex == SymbolGroup.this.offsets.size()) {
                throw new NoSuchElementException("none left");
            }
            this.currentOffset = SymbolGroup.this.offsets.get(this.currentIndex++);
            return SymbolGroup.this.symbolsByOffset.get(this.currentOffset);
        }

        long getCurrentOffset() {
            return this.currentOffset;
        }

        void initGet() {
            this.currentIndex = 0;
        }

        void initGetByOffset(long offset) {
            int index = SymbolGroup.this.indexByOffset.get(offset);
            if (index < 0) {
                index = 0;
            }
            this.currentIndex = index;
            this.currentOffset = offset;
        }

        int getModuleNumber() {
            return SymbolGroup.this.moduleNumber;
        }
    }
}

