/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractEnumMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsProperty;
import ghidra.app.util.pdb.pdbapplicator.AbstractComplexTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.EnumerateTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.FieldListTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;
import java.util.List;

public class EnumTypeApplier
extends AbstractComplexTypeApplier {
    public EnumTypeApplier(PdbApplicator applicator, AbstractEnumMsType msType) {
        super(applicator, msType);
    }

    @Override
    BigInteger getSize() {
        MsTypeApplier underlyingApplier = this.getUnderlyingTypeApplier();
        if (underlyingApplier == null) {
            return BigInteger.ZERO;
        }
        return underlyingApplier.getSize();
    }

    private long getMask() {
        switch (this.getLength()) {
            case 1: {
                return 255L;
            }
            case 2: {
                return 65535L;
            }
            case 4: {
                return 0xFFFFFFFFL;
            }
        }
        return -1L;
    }

    private int getLength() {
        MsTypeApplier underlyingApplier = this.getUnderlyingTypeApplier();
        if (underlyingApplier == null) {
            return 1;
        }
        DataType underlyingType = underlyingApplier.getDataType();
        if (underlyingType == null) {
            return 1;
        }
        return Integer.max(underlyingType.getLength(), 1);
    }

    boolean isSigned() {
        MsTypeApplier underlyingApplier = this.getUnderlyingTypeApplier();
        if (underlyingApplier == null) {
            return false;
        }
        DataType underlyingType = underlyingApplier.getDataType();
        if (underlyingType == null) {
            return false;
        }
        if (underlyingType instanceof AbstractIntegerDataType) {
            return ((AbstractIntegerDataType)underlyingType).isSigned();
        }
        return false;
    }

    @Override
    EnumTypeApplier getDependencyApplier() {
        if (this.definitionApplier != null && this.definitionApplier instanceof EnumTypeApplier) {
            return (EnumTypeApplier)this.definitionApplier;
        }
        return this;
    }

    String getName() {
        return this.getMsType().getName();
    }

    private MsTypeApplier getUnderlyingTypeApplier() {
        MsTypeApplier under = null;
        AbstractComplexTypeApplier applier = this.definitionApplier != null ? this.definitionApplier : this;
        RecordNumber underlyingRecordNumber = ((AbstractEnumMsType)applier.getMsType()).getUnderlyingRecordNumber();
        under = this.applicator.getTypeApplier(underlyingRecordNumber);
        if (under == null) {
            this.applicator.appendLogMsg("Missing applier for underlying type index " + underlyingRecordNumber + " in Enum " + this.msType.getName());
        }
        return under;
    }

    private EnumDataType createEmptyEnum(AbstractEnumMsType type) {
        SymbolPath fixedPath = this.getFixedSymbolPath();
        CategoryPath categoryPath = this.applicator.getCategory(fixedPath.getParent());
        EnumDataType enumDataType = new EnumDataType(categoryPath, fixedPath.getName(), this.getLength(), this.applicator.getDataTypeManager());
        return enumDataType;
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.getOrCreateEnum();
        AbstractEnumMsType type = (AbstractEnumMsType)this.msType;
        MsProperty property = type.getMsProperty();
        if (property.isForwardReference()) {
            return;
        }
        this.applyEnumMsType((AbstractEnumMsType)this.msType);
    }

    @Override
    void resolve() {
        if (!this.isForwardReference()) {
            super.resolve();
        }
    }

    private void getOrCreateEnum() {
        AbstractEnumMsType neededType = (AbstractEnumMsType)this.msType;
        if (this.dataType != null) {
            return;
        }
        if (this.isForwardReference()) {
            if (this.definitionApplier != null) {
                this.dataType = this.definitionApplier.getDataTypeInternal();
                if (this.dataType != null) {
                    return;
                }
                neededType = (AbstractEnumMsType)this.definitionApplier.getMsType();
            }
        } else if (this.forwardReferenceApplier != null) {
            this.dataType = this.forwardReferenceApplier.getDataTypeInternal();
            if (this.dataType != null) {
                return;
            }
        }
        this.dataType = this.createEmptyEnum(neededType);
    }

    private EnumDataType applyEnumMsType(AbstractEnumMsType type) throws PdbException {
        String fullPathName = type.getName();
        RecordNumber fieldListRecordNumber = type.getFieldDescriptorListRecordNumber();
        FieldListTypeApplier fieldListApplier = FieldListTypeApplier.getFieldListApplierSpecial(this.applicator, fieldListRecordNumber);
        List<MsTypeApplier> memberList = fieldListApplier.getMemberList();
        int numElements = type.getNumElements();
        if (memberList.size() != numElements) {
            this.pdbLogAndInfoMessage(this, "Enum expecting " + numElements + " elements, but only " + memberList.size() + " available for " + fullPathName);
        }
        EnumDataType enumDataType = (EnumDataType)this.dataType;
        int length = this.getLength();
        boolean isSigned = this.isSigned();
        for (MsTypeApplier memberApplier : memberList) {
            if (memberApplier instanceof EnumerateTypeApplier) {
                EnumerateTypeApplier enumerateApplier = (EnumerateTypeApplier)memberApplier;
                SymbolPath memberSymbolPath = new SymbolPath(enumerateApplier.getName());
                enumDataType.add(memberSymbolPath.getName(), this.narrowingConversion(length, isSigned, enumerateApplier.getNumeric()));
                continue;
            }
            this.pdbLogAndInfoMessage(this, this.getClass().getSimpleName() + ": unexpected " + memberApplier.getClass().getSimpleName());
        }
        return enumDataType;
    }

    private long narrowingConversion(int outputSize, boolean outputSigned, Numeric numeric) {
        if (!numeric.isIntegral()) {
            Msg.info((Object)this, (Object)("Non-integral numeric found: " + numeric));
            return 0L;
        }
        if (!numeric.isIntegral()) {
            this.pdbLogAndInfoMessage(this, "Using zero in place of non-integral enumerate: " + numeric);
            return 0L;
        }
        return numeric.getIntegral().longValue() & this.getMask();
    }
}

