/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractTypeProgramInterface;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.pdb.pdbapplicator.AbstractComplexTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.CompositeTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.EnumTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;

public class ComplexTypeApplierMapper {
    private PdbApplicator applicator;
    private Map<SymbolPath, LinkedList<AbstractComplexTypeApplier>> compositeAppliersQueueBySymbolPath;
    private Map<SymbolPath, LinkedList<AbstractComplexTypeApplier>> enumAppliersQueueBySymbolPath;

    public ComplexTypeApplierMapper(PdbApplicator applicator) {
        Objects.requireNonNull(applicator, "applicator cannot be null");
        this.applicator = applicator;
        this.compositeAppliersQueueBySymbolPath = new HashMap<SymbolPath, LinkedList<AbstractComplexTypeApplier>>();
        this.enumAppliersQueueBySymbolPath = new HashMap<SymbolPath, LinkedList<AbstractComplexTypeApplier>>();
    }

    void mapAppliers(TaskMonitor monitor) throws CancelledException {
        AbstractTypeProgramInterface typeProgramInterface = this.applicator.getPdb().getTypeProgramInterface();
        if (typeProgramInterface == null) {
            return;
        }
        int indexLimit = typeProgramInterface.getTypeIndexMaxExclusive();
        int indexNumber = typeProgramInterface.getTypeIndexMin();
        monitor.initialize((long)(indexLimit - indexNumber));
        this.applicator.setMonitorMessage("PDB: Mapping Composites...");
        while (indexNumber < indexLimit) {
            monitor.checkCanceled();
            MsTypeApplier applier = this.applicator.getTypeApplier(RecordNumber.typeRecordNumber(indexNumber++));
            if (applier instanceof CompositeTypeApplier) {
                this.mapComplexApplierTwoWayBySymbolPath(this.compositeAppliersQueueBySymbolPath, (AbstractComplexTypeApplier)applier);
            } else if (applier instanceof EnumTypeApplier) {
                this.mapComplexApplierTwoWayBySymbolPath(this.enumAppliersQueueBySymbolPath, (AbstractComplexTypeApplier)applier);
            }
            monitor.incrementProgress(1L);
        }
    }

    private void mapComplexApplierTwoWayBySymbolPath(Map<SymbolPath, LinkedList<AbstractComplexTypeApplier>> applierQueueBySymbolPath, AbstractComplexTypeApplier complexApplier) {
        SymbolPath symbolPath = complexApplier.getSymbolPath();
        Objects.requireNonNull(symbolPath, "SymbolPath may not be null");
        LinkedList<AbstractComplexTypeApplier> appliers = applierQueueBySymbolPath.get(symbolPath);
        if (appliers == null) {
            appliers = new LinkedList();
            applierQueueBySymbolPath.put(symbolPath, appliers);
            if (!appliers.add(complexApplier)) {
                // empty if block
            }
        } else if (appliers.peekFirst().isForwardReference() == complexApplier.isForwardReference()) {
            if (!appliers.add(complexApplier)) {
                // empty if block
            }
        } else {
            if (complexApplier.isForwardReference()) {
                AbstractComplexTypeApplier definitionApplier = appliers.removeFirst();
                definitionApplier.setForwardReferenceApplier(complexApplier);
                complexApplier.setDefinitionApplier(definitionApplier);
            } else {
                AbstractComplexTypeApplier forwardReferenceApplier = appliers.removeFirst();
                forwardReferenceApplier.setDefinitionApplier(complexApplier);
                complexApplier.setForwardReferenceApplier(forwardReferenceApplier);
            }
            if (appliers.isEmpty()) {
                applierQueueBySymbolPath.remove(symbolPath);
            }
        }
    }
}

