/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractArrayMsType;
import ghidra.app.util.pdb.pdbapplicator.ModifierTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class ArrayTypeApplier
extends MsTypeApplier {
    private MsTypeApplier underlyingTypeApplier = null;
    private boolean isFlexibleArray = false;

    public ArrayTypeApplier(PdbApplicator applicator, AbstractArrayMsType msType) {
        super(applicator, msType);
    }

    boolean isFlexibleArray() {
        return this.isFlexibleArray;
    }

    @Override
    void deferredApply() throws PdbException, CancelledException {
    }

    @Override
    BigInteger getSize() {
        return ((AbstractArrayMsType)this.msType).getSize();
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.applyOrDeferForDependencies();
    }

    private void applyOrDeferForDependencies() {
        AbstractArrayMsType type = (AbstractArrayMsType)this.msType;
        this.underlyingTypeApplier = this.applicator.getTypeApplier(type.getElementTypeRecordNumber());
        if (this.underlyingTypeApplier instanceof ModifierTypeApplier) {
            this.underlyingTypeApplier = ((ModifierTypeApplier)this.underlyingTypeApplier).getModifiedTypeApplier();
        }
        this.underlyingTypeApplier = this.underlyingTypeApplier.getDependencyApplier();
        this.applyType(type);
    }

    private void applyType(AbstractArrayMsType type) {
        this.applyArrayMsType((AbstractArrayMsType)this.msType);
    }

    private void applyArrayMsType(AbstractArrayMsType type) {
        ArrayDataType arrayDataType;
        String msg;
        String msg2;
        if (this.isApplied()) {
            return;
        }
        long longUnderlyingSize = PdbApplicator.bigIntegerToLong(this.applicator, this.underlyingTypeApplier.getSize());
        DataType underlyingDataType = this.underlyingTypeApplier.getDataType();
        if (longUnderlyingSize > Integer.MAX_VALUE) {
            msg2 = "PDB " + type.getClass().getSimpleName() + ": Underlying type too large " + underlyingDataType.getName();
            Msg.warn((Object)this, (Object)msg2);
            underlyingDataType = Undefined1DataType.dataType;
            longUnderlyingSize = 1L;
        } else if (longUnderlyingSize == 0L) {
            msg2 = "PDB " + type.getClass().getSimpleName() + ": Zero-sized underlying type " + underlyingDataType.getName();
            Msg.warn((Object)this, (Object)msg2);
            underlyingDataType = Undefined1DataType.dataType;
            longUnderlyingSize = 1L;
        }
        long longArraySize = this.getSizeLong();
        long longNumElements = longArraySize / longUnderlyingSize;
        if (longNumElements > Integer.MAX_VALUE) {
            msg = "PDB " + type.getClass().getSimpleName() + ": Array num elements too large: " + longUnderlyingSize;
            Msg.warn((Object)this, (Object)msg);
            longNumElements = 1L;
        } else if (longArraySize == 0L) {
            longNumElements = 0L;
        } else if (longArraySize % longUnderlyingSize != 0L) {
            msg = "PDB " + type.getClass().getSimpleName() + ": Array num elements calculation error underlying type " + longArraySize + " % " + longUnderlyingSize;
            Msg.warn((Object)this, (Object)msg);
            underlyingDataType = Undefined1DataType.dataType;
            longUnderlyingSize = 1L;
            longNumElements = longArraySize;
        }
        int numElements = (int)longNumElements;
        if (numElements == 0) {
            arrayDataType = new ArrayDataType(underlyingDataType, 1, underlyingDataType.getLength(), this.applicator.getDataTypeManager());
            this.isFlexibleArray = true;
        } else {
            arrayDataType = new ArrayDataType(underlyingDataType, numElements, -1, this.applicator.getDataTypeManager());
            this.isFlexibleArray = false;
        }
        this.setApplied();
        this.dataType = arrayDataType;
    }
}

