/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;

public abstract class AbstractOverloadedMethodMsType
extends AbstractMsType
implements MsTypeField {
    protected int count;
    protected RecordNumber methodListRecordNumber;
    protected String name;

    public AbstractOverloadedMethodMsType(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.count = reader.parseUnsignedShortVal();
        this.methodListRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.name = reader.parseString(pdb, strType);
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append("overloaded[");
        builder.append(this.count);
        builder.append("]:");
        builder.append(this.name);
        builder.append(this.pdb.getTypeRecord(this.methodListRecordNumber));
    }
}

