/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.CallingConvention;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FunctionMsAttributes;

public abstract class AbstractMemberFunctionMsType
extends AbstractMsType {
    protected RecordNumber returnValueRecordNumber;
    protected RecordNumber containingClassRecordNumber;
    protected RecordNumber thisPointerRecordNumber;
    protected CallingConvention callingConvention;
    protected FunctionMsAttributes functionAttributes;
    protected int numParameters;
    protected RecordNumber argListRecordNumber;
    protected int thisAdjuster;

    public AbstractMemberFunctionMsType(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize) throws PdbException {
        super(pdb, reader);
        this.returnValueRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.containingClassRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.thisPointerRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.callingConvention = CallingConvention.fromValue(reader.parseUnsignedByteVal());
        this.functionAttributes = new FunctionMsAttributes(reader);
        this.numParameters = reader.parseUnsignedShortVal();
        this.argListRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.thisAdjuster = reader.parseInt();
    }

    public RecordNumber getReturnRecordNumber() {
        return this.returnValueRecordNumber;
    }

    public AbstractMsType getReturnType() {
        return this.pdb.getTypeRecord(this.returnValueRecordNumber);
    }

    public CallingConvention getCallingConvention() {
        return this.callingConvention;
    }

    public FunctionMsAttributes getFunctionAttributes() {
        return this.functionAttributes;
    }

    public int getNumParams() {
        return this.numParameters;
    }

    public RecordNumber getArgListRecordNumber() {
        return this.argListRecordNumber;
    }

    public AbstractMsType getArgumentsListType() {
        return this.pdb.getTypeRecord(this.argListRecordNumber);
    }

    public RecordNumber getContainingClassRecordNumber() {
        return this.containingClassRecordNumber;
    }

    public AbstractMsType getContainingClassType() {
        return this.pdb.getTypeRecord(this.containingClassRecordNumber);
    }

    public RecordNumber getThisPointerRecordNumber() {
        return this.thisPointerRecordNumber;
    }

    public AbstractMsType getThisPointerType() {
        return this.pdb.getTypeRecord(this.thisPointerRecordNumber);
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        if (bind.ordinal() < AbstractMsType.Bind.PROC.ordinal()) {
            builder.insert(0, "(");
            builder.append(")");
        }
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(this.getContainingClassType());
        myBuilder.append("::");
        builder.insert(0, myBuilder);
        builder.append(this.getArgumentsListType());
        builder.append("<");
        myBuilder = new StringBuilder();
        myBuilder.append("this");
        this.getThisPointerType().emit(myBuilder, AbstractMsType.Bind.NONE);
        builder.append((CharSequence)myBuilder);
        builder.append(",");
        builder.append(this.thisAdjuster);
        builder.append(",");
        builder.append(this.numParameters);
        builder.append(",");
        builder.append(this.functionAttributes);
        builder.append(">");
        this.getReturnType().emit(builder, AbstractMsType.Bind.PROC);
    }
}

