/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsfDirectoryStream;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsfFreePageMap;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsfStreamTable;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfFileReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStream;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class AbstractMsf
implements AutoCloseable {
    private static final int HEADER_PAGE_NUMBER = 0;
    private static final int DIRECTORY_STREAM_NUMBER = 0;
    protected String filename;
    protected MsfFileReader fileReader;
    protected AbstractMsfFreePageMap freePageMap;
    protected AbstractMsfDirectoryStream directoryStream;
    protected AbstractMsfStreamTable streamTable;
    protected int pageSize;
    protected int log2PageSize;
    protected int freePageMapNumSequentialPage;
    protected int pageSizeModMask;
    protected int currentFreePageMapFirstPageNumber;
    protected int numPages = 1;
    protected PdbReaderOptions pdbOptions;

    public AbstractMsf(RandomAccessFile file, PdbReaderOptions pdbOptions) throws IOException, PdbException {
        this.pdbOptions = pdbOptions;
        this.pageSize = 4096;
        this.configureParameters();
        this.fileReader = new MsfFileReader(this, file);
        this.create();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getNumStreams() {
        return this.streamTable.getNumStreams();
    }

    public MsfStream getStream(int streamNumber) {
        return this.streamTable.getStream(streamNumber);
    }

    @Override
    public void close() throws IOException {
        if (this.fileReader != null) {
            this.fileReader.close();
        }
    }

    static final int floorDivisionWithLog2Divisor(int dividend, int log2Divisor) {
        return dividend + (1 << log2Divisor) - 1 >> log2Divisor;
    }

    protected abstract byte[] getIdentification();

    protected abstract int getPageSizeOffset();

    protected abstract void parseFreePageMapPageNumber(PdbByteReader var1) throws PdbException;

    protected abstract void parseCurrentNumPages(PdbByteReader var1) throws PdbException;

    abstract void create();

    abstract void configureParameters() throws PdbException;

    protected abstract int getPageNumberSize();

    protected int getLog2PageSize() {
        return this.log2PageSize;
    }

    protected int getPageSizeModMask() {
        return this.pageSizeModMask;
    }

    protected int getNumSequentialFreePageMapPages() {
        return this.freePageMapNumSequentialPage;
    }

    protected int getHeaderPageNumber() {
        return 0;
    }

    protected int getDirectoryStreamNumber() {
        return 0;
    }

    protected int getNumPages() {
        return this.numPages;
    }

    protected int getCurrentFreePageMapFirstPageNumber() {
        return this.currentFreePageMapFirstPageNumber;
    }

    protected void deserialize(TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        byte[] bytes = new byte[this.getPageSize()];
        this.fileReader.read(this.getHeaderPageNumber(), 0, this.getPageSize(), bytes, 0);
        PdbByteReader reader = new PdbByteReader(bytes);
        reader.setIndex(this.getPageSizeOffset());
        this.pageSize = reader.parseInt();
        this.parseFreePageMapPageNumber(reader);
        this.parseCurrentNumPages(reader);
        this.configureParameters();
        this.directoryStream.deserializeStreamInfo(reader, monitor);
        this.freePageMap.deserialize(monitor);
        this.streamTable.deserialize(this.directoryStream, monitor);
    }
}

