/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import generic.io.NullWriter;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractTypeProgramInterface;
import ghidra.app.util.bin.format.pdb2.pdbreader.IdMsParsable;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.framework.Application;
import ghidra.util.Msg;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.function.Supplier;

public class PdbLog {
    private static File logFile;
    private static Writer nullWriter;
    private static Writer fileWriter;
    private static Writer writer;
    private static boolean enabled;

    public static void setEnabled(boolean enable) throws IOException {
        if (fileWriter == null) {
            fileWriter = PdbLog.createFileWriter();
        }
        if (nullWriter == null) {
            nullWriter = new NullWriter();
        }
        writer = enable ? fileWriter : nullWriter;
        enabled = enable;
    }

    @SafeVarargs
    public static void message(String format, Supplier<String> ... suppliers) {
        if (!enabled) {
            return;
        }
        Object[] varArgs = new Object[suppliers.length];
        for (int i = 0; i < suppliers.length; ++i) {
            Supplier<String> supplier = suppliers[i];
            String var = supplier.get().toString();
            varArgs[i] = var;
        }
        try {
            writer.append(String.format(format, varArgs));
            writer.append("\n");
            writer.flush();
        }
        catch (IOException e) {
            PdbLog.handleIOException(e);
        }
    }

    public static void message(Supplier<String> supplier) {
        if (!enabled) {
            return;
        }
        try {
            writer.append(supplier.get());
            writer.append("\n");
            writer.flush();
        }
        catch (IOException e) {
            PdbLog.handleIOException(e);
        }
    }

    public static void message(String message) {
        try {
            writer.append(message);
            writer.append("\n");
            writer.flush();
        }
        catch (IOException e) {
            PdbLog.handleIOException(e);
        }
    }

    public static void logSerializationItemClassMismatch(IdMsParsable parsable, Class<?> requiredClass, int dataTypeId) {
        PdbLog.message("Parsed type (" + parsable.getClass().getSimpleName() + ") does not matched required (" + requiredClass.getSimpleName() + ") for dataTypeId " + dataTypeId);
    }

    public static void logDeserializationFailure(PdbByteReader reader, int dataTypeId, Exception e) {
        PdbLog.message("Encountered exception on dataTypeId " + dataTypeId + " near reader index " + reader.getIndex() + ": " + e);
    }

    public static void logBadTypeRecordIndex(AbstractTypeProgramInterface tpi, int recordNumber) {
        PdbLog.message("Bad requested type record " + recordNumber + ", min: " + tpi.getTypeIndexMin() + ", max: " + tpi.getTypeIndexMaxExclusive());
    }

    public static void logGetTypeClassMismatch(AbstractMsType type, Class<?> itemRequiredClass) {
        PdbLog.message("Mismatch type  " + type.getClass().getSimpleName() + " for " + type.getName() + ", expected: " + itemRequiredClass.getSimpleName());
    }

    public static void dispose() {
        try {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        fileWriter = null;
    }

    private static Writer createFileWriter() throws IOException {
        logFile = new File(Application.getUserSettingsDirectory(), "pdb.analyzer.log");
        if (logFile.exists()) {
            logFile.delete();
        }
        return new FileWriter(logFile);
    }

    private static void handleIOException(IOException exception) {
        try {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Msg.error(PdbLog.class, (Object)"IOException encountered; disabling writer", (Throwable)exception);
        writer = nullWriter;
        enabled = false;
    }

    static {
        writer = nullWriter = new NullWriter();
    }
}

